/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.disasters;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMeteor
extends Entity {
    private BlockPos targetPos = BlockPos.f_121853_;
    private long impactGameTime = 0L;
    private long lockGameTime = 0L;
    private UUID trackingPlayer = null;
    private float explosionPower = 8.0f;
    private boolean causeFire = true;
    private double damageRadius = 10.0;
    private float oneShotDamage = 1000.0f;
    private float armoredDamage = 18.0f;

    public EntityMeteor(EntityType<? extends EntityMeteor> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public void setup(BlockPos target, long impactTime, long lockTime, UUID trackingPlayer) {
        this.targetPos = target;
        this.impactGameTime = impactTime;
        this.lockGameTime = lockTime;
        this.trackingPlayer = trackingPlayer;
    }

    public void setExplosionPower(float p) {
        this.explosionPower = p;
    }

    public void setCauseFire(boolean fire) {
        this.causeFire = fire;
    }

    public void setDamageRadius(double r) {
        this.damageRadius = r;
    }

    public void setArmoredDamage(float d) {
        this.armoredDamage = d;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        ServerPlayer p;
        super.m_8119_();
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        long now = level2.m_46467_();
        if (this.trackingPlayer != null && now < this.lockGameTime && (p = level2.m_7654_().m_6846_().m_11259_(this.trackingPlayer)) != null && p.m_6084_()) {
            BlockPos bp = p.m_20183_();
            this.targetPos = new BlockPos(bp.m_123341_(), bp.m_123342_(), bp.m_123343_());
        }
        if (this.impactGameTime > 0L && now >= this.impactGameTime) {
            this.impact(level2);
            return;
        }
        long remaining = Math.max(1L, this.impactGameTime - now);
        Vec3 cur = this.m_20182_();
        Vec3 target = new Vec3((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_() + 0.5, (double)this.targetPos.m_123343_() + 0.5);
        Vec3 step = target.m_82546_(cur).m_82490_(1.0 / (double)remaining);
        double max = 3.0;
        double dx = Mth.m_14008_((double)step.f_82479_, (double)(-max), (double)max);
        double dy = Mth.m_14008_((double)step.f_82480_, (double)(-max), (double)max);
        double dz = Mth.m_14008_((double)step.f_82481_, (double)(-max), (double)max);
        this.m_6034_(cur.f_82479_ + dx, cur.f_82480_ + dy, cur.f_82481_ + dz);
        if (this.m_20238_(target) <= 0.8) {
            this.impact(level2);
        }
    }

    private void impact(ServerLevel level) {
        level.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, this.causeFire, Level.ExplosionInteraction.MOB);
        AABB box = new AABB(this.m_20185_() - this.damageRadius, this.m_20186_() - this.damageRadius, this.m_20189_() - this.damageRadius, this.m_20185_() + this.damageRadius, this.m_20186_() + this.damageRadius, this.m_20189_() + this.damageRadius);
        for (LivingEntity e : level.m_45976_(LivingEntity.class, box)) {
            double d2;
            if (!e.m_6084_() || (d2 = e.m_20280_((Entity)this)) > this.damageRadius * this.damageRadius) continue;
            if (e instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)e;
                int armor = sp.m_21230_();
                if (armor <= 0) {
                    sp.m_6469_(sp.m_269291_().m_269036_((Entity)this, (Entity)this), this.oneShotDamage);
                    continue;
                }
                sp.m_6469_(sp.m_269291_().m_269036_((Entity)this, (Entity)this), this.armoredDamage);
                continue;
            }
            e.m_6469_(e.m_269291_().m_269036_((Entity)this, (Entity)this), 40.0f);
        }
        if (this.causeFire) {
            BlockPos c = this.m_20183_();
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BlockState below;
                    BlockPos p;
                    BlockPos above;
                    if (level.f_46441_.m_188501_() > 0.35f || !level.m_8055_(above = (p = c.m_7918_(dx, 0, dz)).m_7494_()).m_60795_() || !(below = level.m_8055_(p)).isFlammable((BlockGetter)level, p, Direction.UP)) continue;
                    level.m_7731_(above, Blocks.f_50083_.m_49966_(), 3);
                }
            }
        }
        this.m_146870_();
    }

    protected void m_7378_(CompoundTag tag) {
        this.targetPos = new BlockPos(tag.m_128451_("tx"), tag.m_128451_("ty"), tag.m_128451_("tz"));
        this.impactGameTime = tag.m_128454_("impact");
        this.lockGameTime = tag.m_128454_("lock");
        this.trackingPlayer = tag.m_128403_("track") ? tag.m_128342_("track") : null;
        this.explosionPower = tag.m_128457_("exp");
        this.causeFire = tag.m_128471_("fire");
        this.damageRadius = tag.m_128459_("rad");
        this.oneShotDamage = tag.m_128457_("one");
        this.armoredDamage = tag.m_128457_("arm");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("tx", this.targetPos.m_123341_());
        tag.m_128405_("ty", this.targetPos.m_123342_());
        tag.m_128405_("tz", this.targetPos.m_123343_());
        tag.m_128356_("impact", this.impactGameTime);
        tag.m_128356_("lock", this.lockGameTime);
        if (this.trackingPlayer != null) {
            tag.m_128362_("track", this.trackingPlayer);
        }
        tag.m_128350_("exp", this.explosionPower);
        tag.m_128379_("fire", this.causeFire);
        tag.m_128347_("rad", this.damageRadius);
        tag.m_128350_("one", this.oneShotDamage);
        tag.m_128350_("arm", this.armoredDamage);
    }
}

