/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.disasters;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityTornado
extends Entity {
    private int lifeTicks = 0;
    private int maxLifeTicks = 3000;
    private boolean forced = false;
    private final ServerBossEvent bossBar;
    private ChunkPos globalPriorityChunk = null;
    private BlockPos currentTarget = null;
    private Vec3 wanderCenter = null;
    private double baseSpeed;
    private double currentSpeed = this.baseSpeed = 0.14;
    private int desireTimer = 0;
    private TornadoDesire desire = TornadoDesire.WANDER;
    private int orbitTimer = 0;
    private double orbitAngle = 0.0;
    private int visualHeight = 22;
    private float visualBaseRadius = 2.2f;
    private float visualTopRadius = 7.5f;
    private int breakRadius = 6;
    private int breakHeight = 18;
    private int suckRadius = 7;
    private int suckHeight = 26;
    private double desiredY = 0.0;
    private int groundSampleCooldown = 0;
    private final RandomSource r = RandomSource.m_216327_();
    private int damageCooldown = 0;

    public EntityTornado(EntityType<?> type, Level level) {
        super(type, level);
        this.bossBar = new ServerBossEvent((Component)Component.m_237113_((String)"Tornado"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.f_19794_ = true;
    }

    public void setForced(boolean forcedByCommand) {
        this.forced = forcedByCommand;
    }

    public void setGlobalPriorityChunk(ChunkPos cp) {
        this.globalPriorityChunk = cp;
    }

    public int getVisualHeight() {
        return this.visualHeight;
    }

    public float getVisualBaseRadius() {
        return this.visualBaseRadius;
    }

    public float getVisualTopRadius() {
        return this.visualTopRadius;
    }

    public void killTornado(boolean silent) {
        Level level;
        if (!silent && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.WEATHER, 2.0f, 0.7f);
        }
        this.bossBar.m_7706_();
        this.m_146870_();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifeTicks = tag.m_128451_("LifeTicks");
        this.maxLifeTicks = tag.m_128451_("MaxLifeTicks");
        this.forced = tag.m_128471_("Forced");
        if (tag.m_128441_("TargetX")) {
            int tx = tag.m_128451_("TargetX");
            int ty = tag.m_128451_("TargetY");
            int tz = tag.m_128451_("TargetZ");
            this.currentTarget = new BlockPos(tx, ty, tz);
        } else {
            this.currentTarget = null;
        }
        this.globalPriorityChunk = tag.m_128441_("PriorityCX") ? new ChunkPos(tag.m_128451_("PriorityCX"), tag.m_128451_("PriorityCZ")) : null;
        this.desire = TornadoDesire.valueOf(tag.m_128461_("Desire"));
        this.desireTimer = tag.m_128451_("DesireTimer");
        this.orbitTimer = tag.m_128451_("OrbitTimer");
        this.orbitAngle = tag.m_128459_("OrbitAngle");
        this.desiredY = tag.m_128459_("DesiredY");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LifeTicks", this.lifeTicks);
        tag.m_128405_("MaxLifeTicks", this.maxLifeTicks);
        tag.m_128379_("Forced", this.forced);
        if (this.currentTarget != null) {
            tag.m_128405_("TargetX", this.currentTarget.m_123341_());
            tag.m_128405_("TargetY", this.currentTarget.m_123342_());
            tag.m_128405_("TargetZ", this.currentTarget.m_123343_());
        }
        if (this.globalPriorityChunk != null) {
            tag.m_128405_("PriorityCX", this.globalPriorityChunk.f_45578_);
            tag.m_128405_("PriorityCZ", this.globalPriorityChunk.f_45579_);
        }
        tag.m_128359_("Desire", this.desire.name());
        tag.m_128405_("DesireTimer", this.desireTimer);
        tag.m_128405_("OrbitTimer", this.orbitTimer);
        tag.m_128347_("OrbitAngle", this.orbitAngle);
        tag.m_128347_("DesiredY", this.desiredY);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        ++this.lifeTicks;
        this.updateBossBar(sl);
        if (this.lifeTicks >= this.maxLifeTicks) {
            this.killTornado(true);
            return;
        }
        if (this.lifeTicks > this.maxLifeTicks - 100) {
            this.currentSpeed = 0.06;
        } else {
            double w = 0.85 + Math.sin((double)this.f_19797_ * 0.03) * 0.12;
            this.currentSpeed = this.baseSpeed * w;
        }
        this.tickDesires(sl);
        this.tickGroundFollow(sl);
        this.tickMovement(sl);
        this.breakBlocks(sl);
        this.suckEntities(sl);
        this.playWindSounds(sl);
        this.syncBossBarPlayers(sl);
    }

    private void updateBossBar(ServerLevel sl) {
        float progress = 1.0f - (float)this.lifeTicks / (float)this.maxLifeTicks;
        this.bossBar.m_142711_(Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f));
    }

    private void syncBossBarPlayers(ServerLevel sl) {
        for (ServerPlayer p : sl.m_6907_()) {
            if (this.bossBar.m_8324_().contains(p)) continue;
            this.bossBar.m_6543_(p);
        }
        for (ServerPlayer p : new ArrayList(this.bossBar.m_8324_())) {
            if (!(p.m_20270_((Entity)this) > 256.0f)) continue;
            this.bossBar.m_6539_(p);
        }
        this.bossBar.m_8321_(true);
    }

    private void tickDesires(ServerLevel sl) {
        --this.desireTimer;
        if (this.desireTimer <= 0) {
            int pick = this.r.m_188503_(100);
            this.desire = pick < 35 ? TornadoDesire.WANDER : (pick < 70 ? TornadoDesire.ORBIT_PRIORITY : (pick < 90 ? TornadoDesire.CHASE_PLAYER : TornadoDesire.BREAK_FUNCTIONAL_NEAR_PRIORITY));
            this.desireTimer = 160 + this.r.m_188503_(260);
            this.pickNewTarget(sl);
            if (this.desire == TornadoDesire.ORBIT_PRIORITY) {
                this.orbitTimer = 180 + this.r.m_188503_(220);
                this.orbitAngle = this.r.m_188500_() * Math.PI * 2.0;
            }
        }
        if (this.orbitTimer > 0) {
            --this.orbitTimer;
        }
    }

    private void pickNewTarget(ServerLevel sl) {
        if (this.desire == TornadoDesire.WANDER) {
            if (this.wanderCenter == null) {
                this.wanderCenter = this.m_20182_();
            }
            this.pickRandomWanderTarget(sl);
            return;
        }
        if (this.desire == TornadoDesire.ORBIT_PRIORITY) {
            this.pickOrbitTarget(sl);
            return;
        }
        if (this.desire == TornadoDesire.CHASE_PLAYER) {
            this.pickPlayerTarget(sl);
            return;
        }
        if (this.desire == TornadoDesire.BREAK_FUNCTIONAL_NEAR_PRIORITY) {
            this.pickFunctionalTargetNearPriority(sl);
        }
    }

    private void pickRandomWanderTarget(ServerLevel sl) {
        int range = 16 * (6 + this.r.m_188503_(10));
        int x = (int)this.m_20185_() + this.r.m_188503_(range) - range / 2;
        int z = (int)this.m_20189_() + this.r.m_188503_(range) - range / 2;
        int y = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
        this.currentTarget = new BlockPos(x, y, z);
    }

    private void pickOrbitTarget(ServerLevel sl) {
        ChunkPos cp = this.globalPriorityChunk;
        if (cp == null) {
            this.pickRandomWanderTarget(sl);
            return;
        }
        int radiusChunks = 2 + this.r.m_188503_(3);
        double angle = this.orbitAngle + (double)this.f_19797_ * 0.04;
        int cx = cp.m_45604_() + 8;
        int cz = cp.m_45605_() + 8;
        int tx = cx + (int)Math.round(Math.cos(angle) * (double)(radiusChunks * 16));
        int tz = cz + (int)Math.round(Math.sin(angle) * (double)(radiusChunks * 16));
        int ty = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, tx, tz) + 1;
        this.currentTarget = new BlockPos(tx, ty, tz);
        this.orbitAngle += (this.r.m_188500_() - 0.5) * 0.02;
    }

    private void pickPlayerTarget(ServerLevel sl) {
        List ps = sl.m_6907_();
        if (ps.isEmpty()) {
            this.pickRandomWanderTarget(sl);
            return;
        }
        ServerPlayer p = (ServerPlayer)ps.get(this.r.m_188503_(ps.size()));
        Vec3 to = p.m_20182_().m_82546_(this.m_20182_());
        Vec3 side = new Vec3(-to.f_82481_, 0.0, to.f_82479_).m_82541_().m_82490_((double)(10 + this.r.m_188503_(12)));
        BlockPos bp = p.m_20183_().m_7918_((int)side.f_82479_, 0, (int)side.f_82481_);
        int y = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, bp.m_123341_(), bp.m_123343_()) + 1;
        this.currentTarget = new BlockPos(bp.m_123341_(), y, bp.m_123343_());
    }

    private void pickFunctionalTargetNearPriority(ServerLevel sl) {
        if (this.globalPriorityChunk == null) {
            this.pickRandomWanderTarget(sl);
            return;
        }
        int cx = this.globalPriorityChunk.m_45604_() + 8;
        int cz = this.globalPriorityChunk.m_45605_() + 8;
        int tries = 140;
        int search = 32;
        BlockPos best = null;
        for (int i = 0; i < tries; ++i) {
            int z;
            int surfaceY;
            int x = cx + this.r.m_188503_(search) - search / 2;
            BlockPos pos = new BlockPos(x, surfaceY = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = cz + this.r.m_188503_(search) - search / 2), z);
            Block b = sl.m_8055_(pos).m_60734_();
            if (this.isFunctionalBlock(b)) {
                best = pos;
                break;
            }
            if (b == Blocks.f_50016_ || b == Blocks.f_50440_ || b == Blocks.f_50493_ || b == Blocks.f_50069_) continue;
            best = pos;
            break;
        }
        if (best == null) {
            this.pickOrbitTarget(sl);
            return;
        }
        this.currentTarget = best.m_7494_();
    }

    private boolean isFunctionalBlock(Block b) {
        return b == Blocks.f_50091_ || b == Blocks.f_50094_ || b == Blocks.f_50620_ || b == Blocks.f_50619_ || b == Blocks.f_50087_ || b == Blocks.f_50325_ || b == Blocks.f_50618_ || b == Blocks.f_50201_ || b == Blocks.f_50322_ || b == Blocks.f_50323_ || b == Blocks.f_50324_ || b == Blocks.f_50624_ || b == Blocks.f_50679_ || b == Blocks.f_50621_ || b == Blocks.f_50622_ || b == Blocks.f_50625_ || b == Blocks.f_50617_ || b == Blocks.f_50255_;
    }

    private void tickGroundFollow(ServerLevel sl) {
        double y;
        --this.groundSampleCooldown;
        if (this.groundSampleCooldown <= 0) {
            this.groundSampleCooldown = 5;
            int gx = Mth.m_14107_((double)this.m_20185_());
            int gz = Mth.m_14107_((double)this.m_20189_());
            int gy = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, gx, gz);
            this.desiredY = (double)gy + 1.0;
        }
        if ((y = this.m_20186_()) > this.desiredY + 0.05) {
            y = Math.max(this.desiredY, y - 0.55);
        } else if (y < this.desiredY - 0.05) {
            double diff = this.desiredY - y;
            y = diff <= 1.2 ? Math.min(this.desiredY, y + 0.35) : Math.min(this.desiredY, y + 0.1);
        }
        this.m_6034_(this.m_20185_(), y, this.m_20189_());
    }

    private void tickMovement(ServerLevel sl) {
        if (this.currentTarget == null) {
            this.pickNewTarget(sl);
            return;
        }
        BlockPos ct = this.currentTarget;
        int ty = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ct.m_123341_(), ct.m_123343_()) + 1;
        this.currentTarget = new BlockPos(ct.m_123341_(), ty, ct.m_123343_());
        Vec3 to = new Vec3((double)this.currentTarget.m_123341_() + 0.5 - this.m_20185_(), 0.0, (double)this.currentTarget.m_123343_() + 0.5 - this.m_20189_());
        double dist = Math.sqrt(to.f_82479_ * to.f_82479_ + to.f_82481_ * to.f_82481_);
        if (dist < 5.0) {
            this.pickNewTarget(sl);
            return;
        }
        Vec3 dir = new Vec3(to.f_82479_ / dist, 0.0, to.f_82481_ / dist);
        this.breakObstaclesInFront(sl, dir);
        double nx = this.m_20185_() + dir.f_82479_ * this.currentSpeed;
        double nz = this.m_20189_() + dir.f_82481_ * this.currentSpeed;
        this.m_6034_(nx, this.m_20186_(), nz);
    }

    private void breakObstaclesInFront(ServerLevel sl, Vec3 dir) {
        int y0;
        int y;
        int fx = Mth.m_14107_((double)(this.m_20185_() + dir.f_82479_ * 2.2));
        int fz = Mth.m_14107_((double)(this.m_20189_() + dir.f_82481_ * 2.2));
        int hereGround = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20189_()));
        int frontGround = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, fx, fz);
        int diff = frontGround - hereGround;
        if (diff >= 2) {
            int baseY;
            for (y = baseY = hereGround + 1; y <= baseY + diff + 2; ++y) {
                for (int w = -1; w <= 1; ++w) {
                    int x = fx + (int)Math.round(-dir.f_82481_ * (double)w);
                    int z = fz + (int)Math.round(dir.f_82479_ * (double)w);
                    this.destroyIfBreakable(sl, new BlockPos(x, y, z));
                }
            }
        }
        for (y = y0 = hereGround + 1; y < y0 + 4; ++y) {
            this.destroyIfBreakable(sl, new BlockPos(fx, y, fz));
        }
    }

    private void breakBlocks(ServerLevel sl) {
        int cx = Mth.m_14107_((double)this.m_20185_());
        int cz = Mth.m_14107_((double)this.m_20189_());
        int floorY = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, cx, cz);
        int minY = floorY + 1;
        int maxY = minY + this.breakHeight;
        for (int dx = -this.breakRadius; dx <= this.breakRadius; ++dx) {
            for (int dz = -this.breakRadius; dz <= this.breakRadius; ++dz) {
                double d2 = dx * dx + dz * dz;
                if (d2 > (double)(this.breakRadius * this.breakRadius)) continue;
                int x = cx + dx;
                int z = cz + dz;
                for (int y = minY; y <= maxY; ++y) {
                    this.destroyIfBreakable(sl, new BlockPos(x, y, z));
                }
            }
        }
    }

    private void destroyIfBreakable(ServerLevel sl, BlockPos pos) {
        Block b = sl.m_8055_(pos).m_60734_();
        if (b == Blocks.f_50016_) {
            return;
        }
        if (b == Blocks.f_50752_) {
            return;
        }
        if (!sl.m_46739_(pos)) {
            return;
        }
        sl.m_46961_(pos, true);
    }

    private void suckEntities(ServerLevel sl) {
        AABB box = new AABB(this.m_20185_() - (double)this.suckRadius, this.m_20186_() - 2.0, this.m_20189_() - (double)this.suckRadius, this.m_20185_() + (double)this.suckRadius, this.m_20186_() + (double)this.suckHeight, this.m_20189_() + (double)this.suckRadius);
        List ents = sl.m_45933_((Entity)this, box);
        if (this.damageCooldown > 0) {
            --this.damageCooldown;
        }
        for (Entity e : ents) {
            if (e == this) continue;
            boolean isItem = e instanceof ItemEntity;
            boolean isPlayer = e instanceof ServerPlayer;
            Vec3 rel = new Vec3(this.m_20185_() - e.m_20185_(), 0.0, this.m_20189_() - e.m_20189_());
            double dist = Math.max(0.8, Math.sqrt(rel.f_82479_ * rel.f_82479_ + rel.f_82481_ * rel.f_82481_));
            double pull = 0.14 * (1.0 - Math.min(1.0, dist / (double)this.suckRadius));
            pull = Math.max(0.03, pull);
            Vec3 tangent = new Vec3(-rel.f_82481_, 0.0, rel.f_82479_).m_82541_();
            double lift = 0.1 + (1.0 - Math.min(1.0, dist / (double)this.suckRadius)) * 0.22;
            Vec3 add = new Vec3(rel.f_82479_ / dist * pull, lift, rel.f_82481_ / dist * pull).m_82549_(tangent.m_82490_(0.22));
            if (isPlayer) {
                Vec3 cur = e.m_20184_();
                Vec3 next = cur.m_82549_(add);
                next = new Vec3(Mth.m_14008_((double)next.f_82479_, (double)-0.9, (double)0.9), Mth.m_14008_((double)next.f_82480_, (double)-0.2, (double)0.95), Mth.m_14008_((double)next.f_82481_, (double)-0.9, (double)0.9));
                e.m_20256_(next);
                if (this.damageCooldown == 0) {
                    ((ServerPlayer)e).m_6469_(((ServerPlayer)e).m_269291_().m_269264_(), 1.0f);
                    this.damageCooldown = 30;
                }
            } else {
                Vec3 next = e.m_20184_().m_82549_(add.m_82490_(isItem ? 1.35 : 1.0));
                next = new Vec3(Mth.m_14008_((double)next.f_82479_, (double)-1.2, (double)1.2), Mth.m_14008_((double)next.f_82480_, (double)-0.2, (double)1.1), Mth.m_14008_((double)next.f_82481_, (double)-1.2, (double)1.2));
                e.m_20256_(next);
            }
            e.f_19864_ = true;
            if (!(e.m_20186_() < this.m_20186_() + 2.0)) continue;
            e.m_6034_(e.m_20185_(), e.m_20186_() + 0.05, e.m_20189_());
        }
    }

    private void playWindSounds(ServerLevel sl) {
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        double minDist = 32.0;
        double maxDist = 48.0;
        for (ServerPlayer p : sl.m_6907_()) {
            double d = p.m_20270_((Entity)this);
            if (d < minDist || d > maxDist) continue;
            float t = (float)((d - minDist) / (maxDist - minDist));
            float volume = Mth.m_14179_((float)(1.0f - t), (float)2.8f, (float)1.0f);
            float pitch = 0.7f + this.r.m_188501_() * 0.2f;
            p.m_6330_(SoundEvents.f_11886_, SoundSource.WEATHER, volume, pitch);
        }
    }

    private static enum TornadoDesire {
        WANDER,
        ORBIT_PRIORITY,
        CHASE_PLAYER,
        BREAK_FUNCTIONAL_NEAR_PRIORITY;

    }
}

