/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.disasters;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class HeatWaveEvent {
    public static final long END_DAYTIME = 11800L;
    private final ServerLevel level;
    private final ServerBossEvent bossBar;
    private boolean active = false;
    private long startGameTime = 0L;
    private long endGameTime = 0L;
    private long totalDurationTicks = 1L;
    private final Set<UUID> players = new HashSet<UUID>();

    public HeatWaveEvent(ServerLevel level) {
        this.level = level;
        this.bossBar = new ServerBossEvent((Component)Component.m_237113_((String)"HEAT WAVE"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.bossBar.m_142711_(1.0f);
    }

    public boolean isActive() {
        return this.active;
    }

    public void start() {
        if (this.active) {
            return;
        }
        long dayTime = this.level.m_46468_() % 24000L;
        long ticksToEnd = 11800L - dayTime;
        if (ticksToEnd <= 0L) {
            this.active = false;
            return;
        }
        this.active = true;
        this.startGameTime = this.level.m_46467_();
        this.totalDurationTicks = Math.max(1L, ticksToEnd);
        this.endGameTime = this.startGameTime + this.totalDurationTicks;
        this.syncPlayers();
        this.bossBar.m_142711_(1.0f);
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        for (UUID id : this.players) {
            ServerPlayer p = this.level.m_7654_().m_6846_().m_11259_(id);
            if (p == null) continue;
            this.bossBar.m_6539_(p);
        }
        this.players.clear();
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        long dayTime = this.level.m_46468_() % 24000L;
        if (dayTime >= 11800L) {
            this.stop();
            return;
        }
        long now = this.level.m_46467_();
        long remaining = this.endGameTime - now;
        if (remaining <= 0L) {
            this.stop();
            return;
        }
        float progress = (float)remaining / (float)Math.max(1L, this.totalDurationTicks);
        this.bossBar.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
        this.syncPlayers();
    }

    private void syncPlayers() {
        for (ServerPlayer p : this.level.m_6907_()) {
            if (!this.players.add(p.m_20148_())) continue;
            this.bossBar.m_6543_(p);
        }
        this.players.removeIf(id -> {
            ServerPlayer p = this.level.m_7654_().m_6846_().m_11259_(id);
            if (p == null) {
                return true;
            }
            if (p.m_9236_() != this.level) {
                this.bossBar.m_6539_(p);
                return true;
            }
            return false;
        });
    }
}

