/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.events;

import com.rogerinscii.naturaldisasters.manager.DisasterManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ServerEvents {
    private static long currentDay = -1L;
    private static long randomSpawnTick = -1L;
    private static boolean spawnCheckedToday = false;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        DisasterManager.tick(level2);
        long totalDayTime = level2.m_46468_();
        long day = totalDayTime / 24000L;
        long dayTime = totalDayTime % 24000L;
        if (day != currentDay) {
            currentDay = day;
            randomSpawnTick = 1000L + (long)level2.m_213780_().m_188503_(11000);
            spawnCheckedToday = false;
            System.out.println("[NaturalDisasters] Day " + day + " -> disaster spawn tick chosen: " + randomSpawnTick);
        }
        if (!spawnCheckedToday && randomSpawnTick >= 0L && dayTime >= randomSpawnTick) {
            spawnCheckedToday = true;
            System.out.println("[NaturalDisasters] Day " + day + " -> checking disaster spawn at tick " + dayTime);
            DisasterManager.onNewDay(level2);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        DisasterManager.onChunkLoaded(level, event.getChunk().m_7697_());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        DisasterManager.onChunkUnloaded(level, event.getChunk().m_7697_());
    }

    @SubscribeEvent
    public static void onDrink(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!(player.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ItemStack stack = event.getItem();
        if (stack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
            DisasterManager.onPlayerDrinkWater(player);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!event.getItemStack().m_150930_(Items.f_42590_)) {
            return;
        }
        BlockPos pos = event.getPos();
        if (!level2.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return;
        }
        if (DisasterManager.isBoilingWater(level2, pos)) {
            event.setCanceled(true);
            player2.m_5661_((Component)Component.m_237113_((String)"Water is boiling!"), true);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        DisasterManager.syncWaterStateToPlayer(level2, player2);
    }
}

