/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.manager;

import com.rogerinscii.naturaldisasters.disasters.EntityMeteor;
import com.rogerinscii.naturaldisasters.disasters.EntityTornado;
import com.rogerinscii.naturaldisasters.network.ModNetwork;
import com.rogerinscii.naturaldisasters.network.S2CWaterHeatBulk;
import com.rogerinscii.naturaldisasters.network.S2CWaterHeatClear;
import com.rogerinscii.naturaldisasters.network.S2CWaterHeatUpdate;
import com.rogerinscii.naturaldisasters.registry.ModEntities;
import com.rogerinscii.naturaldisasters.save.HeatWaveSavedData;
import com.rogerinscii.naturaldisasters.save.MeteorShowerSavedData;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class DisasterManager {
    private static int spawnChance = 15;
    private static final List<EntityTornado> activeTornados = new ArrayList<EntityTornado>();
    public static final long HEATWAVE_END_DAYTIME = 11800L;
    private static final int GRACE_TICKS = 200;
    private static final int HEAT_DAMAGE_INTERVAL = 30;
    private static final float HEAT_DAMAGE = 2.0f;
    private static final int BOIL_DAMAGE_INTERVAL = 20;
    private static final float BOIL_DAMAGE = 2.0f;
    private static final int WATER_MAX_HEAT = 2400;
    private static final int HEAT_ADD = 10;
    private static final int COOL_SHADE = 80;
    private static final int COOL_ICE = 200;
    private static final int WATER_CHUNKS_PER_TICK = 8;
    private static final int FIRE_CHUNKS_PER_TICK = 6;
    private static final int ICE_CHUNKS_PER_TICK = 5;
    private static final int WATER_SAMPLES_PER_CHUNK = 3;
    private static final int FIRE_ATTEMPTS_PER_CHUNK = 2;
    private static final int ICE_SAMPLES_PER_CHUNK = 2;
    private static ServerBossEvent heatBar = null;
    private static final Map<UUID, Integer> exposureTicks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> heatDmgTicks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> boilDmgTicks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastDrinkTime = new HashMap<UUID, Long>();
    private static final LongOpenHashSet HEAT_ACTIVE_CHUNKS = new LongOpenHashSet();
    private static long[] heatChunkSnapshot = new long[0];
    private static int heatChunkRebuildCooldown = 0;
    private static int waterChunkCursor = 0;
    private static int fireChunkCursor = 0;
    private static int iceChunkCursor = 0;
    private static final long METEOR_DURATION_TICKS = 1200L;
    private static final int METEOR_DEFAULT_COUNT = 50;
    private static final int METEOR_MODE1_CHUNK_RADIUS = 10;
    private static final int METEOR_MODE2_CHUNK_RADIUS = 2;
    private static final int METEOR_FALL_TICKS = 120;
    private static final int METEOR_LOCK_TICKS = 60;
    private static ServerBossEvent meteorBar = null;

    public static void setCustomChance(int chance) {
        spawnChance = chance;
    }

    public static int getCustomChance() {
        return spawnChance;
    }

    public static void spawnTornadoAt(ServerLevel level, BlockPos pos) {
        if (DisasterManager.isMeteorActive(level)) {
            return;
        }
        EntityTornado tornado = new EntityTornado((EntityType)ModEntities.TORNADO.get(), (Level)level);
        tornado.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        tornado.setGlobalPriorityChunk(new ChunkPos(pos));
        level.m_7967_((Entity)tornado);
        activeTornados.add(tornado);
    }

    public static void stopAllDisasters(ServerLevel level) {
        for (EntityTornado t : new ArrayList<EntityTornado>(activeTornados)) {
            t.killTornado(true);
        }
        activeTornados.clear();
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        if (hw.active) {
            DisasterManager.stopHeatWave(level, hw);
        }
        MeteorShowerSavedData ms = MeteorShowerSavedData.get(level);
        if (ms.active) {
            DisasterManager.stopMeteorShower(level, ms);
        }
    }

    public static void onNewDay(ServerLevel level) {
        if (DisasterManager.isMeteorActive(level)) {
            return;
        }
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        if (hw.active) {
            return;
        }
        if (!activeTornados.isEmpty()) {
            return;
        }
        RandomSource r = RandomSource.m_216327_();
        int players = level.m_6907_().size();
        int chance = spawnChance + Math.max(0, players - 1) * 10;
        if (chance > 90) {
            chance = 90;
        }
        if (r.m_188503_(100) >= chance) {
            return;
        }
        int pick = r.m_188503_(3);
        if (pick == 0) {
            BlockPos spawn = DisasterManager.findRandomSurfacePosition(level);
            DisasterManager.spawnTornadoAt(level, spawn);
        } else if (pick == 1) {
            DisasterManager.spawnHeatWave(level);
        } else {
            DisasterManager.startMeteorShower(level);
        }
    }

    private static BlockPos findRandomSurfacePosition(ServerLevel level) {
        RandomSource r = RandomSource.m_216327_();
        int x = r.m_188503_(2000) - 1000;
        int z = r.m_188503_(2000) - 1000;
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        return new BlockPos(x, y + 1, z);
    }

    public static void spawnHeatWave(ServerLevel level) {
        if (DisasterManager.isMeteorActive(level)) {
            return;
        }
        DisasterManager.startHeatWave(level);
    }

    public static void startHeatWave(ServerLevel level) {
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        if (hw.active) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        long duration = 11800L - dayTime;
        if (duration <= 0L) {
            return;
        }
        hw.active = true;
        hw.startGameTime = level.m_46467_();
        hw.endGameTime = hw.startGameTime + duration;
        hw.totalDurationTicks = duration;
        hw.m_77762_();
        DisasterManager.rebuildHeatActiveChunks(level);
        DisasterManager.broadcastWaterClear(level);
    }

    private static void stopHeatWave(ServerLevel level, HeatWaveSavedData hw) {
        hw.active = false;
        hw.m_77762_();
        if (heatBar != null) {
            heatBar.m_7706_();
            heatBar.m_8321_(false);
            heatBar = null;
        }
        DisasterManager.broadcastWaterClear(level);
        exposureTicks.clear();
        heatDmgTicks.clear();
        boilDmgTicks.clear();
        lastDrinkTime.clear();
        HEAT_ACTIVE_CHUNKS.clear();
        heatChunkSnapshot = new long[0];
        heatChunkRebuildCooldown = 0;
        iceChunkCursor = 0;
        fireChunkCursor = 0;
        waterChunkCursor = 0;
    }

    public static void startMeteorShower(ServerLevel level) {
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        if (hw.active) {
            return;
        }
        MeteorShowerSavedData ms = MeteorShowerSavedData.get(level);
        if (ms.active) {
            return;
        }
        ms.active = true;
        ms.startGameTime = level.m_46467_();
        ms.endGameTime = ms.startGameTime + 1200L;
        ms.totalDurationTicks = 1200L;
        ms.meteorsSpawned = 0;
        ms.pendingPlayers.clear();
        ms.singlePlayer = null;
        ms.seed = level.m_213780_().m_188505_();
        List players = level.m_6907_();
        int pc = players.size();
        RandomSource r = RandomSource.m_216335_((long)ms.seed);
        boolean pickMode1 = r.m_188499_();
        if (pc <= 1) {
            int n = ms.mode = pickMode1 ? 1 : 2;
            if (!players.isEmpty()) {
                ms.singlePlayer = ((ServerPlayer)players.get(0)).m_20148_();
            }
            ms.meteorsTotal = 50;
        } else if (pickMode1) {
            ms.mode = 1;
            ms.meteorsTotal = 50;
        } else {
            ms.mode = 3;
            ms.meteorsTotal = pc;
            for (ServerPlayer p : players) {
                ms.pendingPlayers.add(p.m_20148_());
            }
        }
        ChunkPos base = DisasterManager.averageChunk(players);
        ms.baseChunkLong = ChunkPos.m_45589_((int)base.f_45578_, (int)base.f_45579_);
        ms.nextSpawnGameTime = ms.startGameTime + 10L;
        ms.m_77762_();
    }

    private static void stopMeteorShower(ServerLevel level, MeteorShowerSavedData ms) {
        ms.active = false;
        ms.m_77762_();
        if (meteorBar != null) {
            meteorBar.m_7706_();
            meteorBar.m_8321_(false);
            meteorBar = null;
        }
    }

    private static boolean isMeteorActive(ServerLevel level) {
        return MeteorShowerSavedData.get((ServerLevel)level).active;
    }

    private static void tickMeteorBossbar(ServerLevel level, MeteorShowerSavedData ms) {
        if (meteorBar == null) {
            meteorBar = new ServerBossEvent((Component)Component.m_237113_((String)"METEOR SHOWER"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
            meteorBar.m_8321_(true);
        }
        for (ServerPlayer p : level.m_6907_()) {
            meteorBar.m_6543_(p);
        }
        long remaining = Math.max(0L, ms.endGameTime - level.m_46467_());
        float progress = (float)remaining / (float)Math.max(1L, ms.totalDurationTicks);
        meteorBar.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
    }

    private static void tickMeteorShower(ServerLevel level) {
        MeteorShowerSavedData ms = MeteorShowerSavedData.get(level);
        if (!ms.active) {
            return;
        }
        long now = level.m_46467_();
        DisasterManager.tickMeteorBossbar(level, ms);
        if (now >= ms.endGameTime) {
            DisasterManager.stopMeteorShower(level, ms);
            return;
        }
        if (ms.meteorsSpawned >= ms.meteorsTotal) {
            ms.m_77762_();
            return;
        }
        if (now < ms.nextSpawnGameTime) {
            return;
        }
        DisasterManager.spawnOneMeteor(level, ms);
        ++ms.meteorsSpawned;
        long remaining = Math.max(1L, ms.endGameTime - now);
        int left = Math.max(1, ms.meteorsTotal - ms.meteorsSpawned);
        long baseInterval = Math.max(6L, remaining / (long)left);
        long jitter = level.m_213780_().m_188503_(15);
        ms.nextSpawnGameTime = now + baseInterval + jitter;
        ms.m_77762_();
    }

    private static void spawnOneMeteor(ServerLevel level, MeteorShowerSavedData ms) {
        BlockPos target;
        RandomSource r = RandomSource.m_216335_((long)(ms.seed + (long)ms.meteorsSpawned * 3418731287123L));
        UUID tracking = null;
        if (ms.mode == 1) {
            ChunkPos base = new ChunkPos(ms.baseChunkLong);
            int cx = base.f_45578_ + (r.m_188503_(21) - 10);
            int cz = base.f_45579_ + (r.m_188503_(21) - 10);
            int x = (cx << 4) + r.m_188503_(16);
            int z = (cz << 4) + r.m_188503_(16);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            target = new BlockPos(x, y + 1, z);
        } else if (ms.mode == 2) {
            ServerPlayer p;
            ServerPlayer serverPlayer = ms.singlePlayer == null ? (level.m_6907_().isEmpty() ? null : (ServerPlayer)level.m_6907_().get(0)) : (p = level.m_7654_().m_6846_().m_11259_(ms.singlePlayer));
            if (p == null) {
                BlockPos sp;
                target = sp = DisasterManager.findRandomSurfacePosition(level);
            } else {
                BlockPos c = p.m_20183_();
                int rx = 32;
                int rz = 32;
                int x = c.m_123341_() + (r.m_188503_(rx * 2 + 1) - rx);
                int z = c.m_123343_() + (r.m_188503_(rz * 2 + 1) - rz);
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                target = new BlockPos(x, y + 1, z);
            }
        } else {
            ServerPlayer p;
            UUID pick = null;
            if (!ms.pendingPlayers.isEmpty()) {
                pick = ms.pendingPlayers.remove(0);
            }
            ServerPlayer serverPlayer = p = pick == null ? null : level.m_7654_().m_6846_().m_11259_(pick);
            if (p == null) {
                BlockPos sp;
                target = sp = DisasterManager.findRandomSurfacePosition(level);
            } else {
                BlockPos bp = p.m_20183_();
                target = new BlockPos(bp.m_123341_(), bp.m_123342_(), bp.m_123343_());
                tracking = p.m_20148_();
            }
        }
        int startY = Math.min(level.m_151558_() - 1, target.m_123342_() + 90);
        if (startY < target.m_123342_() + 40) {
            startY = target.m_123342_() + 40;
        }
        Vec3 start = new Vec3((double)target.m_123341_() + 0.5, (double)startY + 0.5, (double)target.m_123343_() + 0.5);
        long now = level.m_46467_();
        long impact = now + 120L;
        long lock = impact - 60L;
        EntityMeteor meteor = new EntityMeteor((EntityType<? extends EntityMeteor>)((EntityType)ModEntities.METEOR.get()), (Level)level);
        meteor.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        meteor.setup(target, impact, lock, tracking);
        meteor.setExplosionPower(2.6f);
        meteor.setCauseFire(true);
        meteor.setDamageRadius(6.0);
        meteor.setArmoredDamage(18.0f);
        level.m_7967_((Entity)meteor);
    }

    private static ChunkPos averageChunk(List<ServerPlayer> players) {
        if (players == null || players.isEmpty()) {
            return new ChunkPos(0, 0);
        }
        long sx = 0L;
        long sz = 0L;
        for (ServerPlayer p : players) {
            ChunkPos c = p.m_146902_();
            sx += (long)c.f_45578_;
            sz += (long)c.f_45579_;
        }
        int ax = (int)Math.round((double)sx / (double)players.size());
        int az = (int)Math.round((double)sz / (double)players.size());
        return new ChunkPos(ax, az);
    }

    public static void tick(ServerLevel level) {
        DisasterManager.tickMeteorShower(level);
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        if (!hw.active) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        if (dayTime >= 11800L || level.m_46467_() >= hw.endGameTime) {
            DisasterManager.stopHeatWave(level, hw);
            return;
        }
        DisasterManager.tickBossbar(level, hw);
        DisasterManager.tickPlayerDamage(level, hw);
        if (++heatChunkRebuildCooldown >= 20) {
            heatChunkRebuildCooldown = 0;
            DisasterManager.rebuildHeatActiveChunks(level);
        }
        DisasterManager.tickGlobalWater(level, hw);
        DisasterManager.tickGlobalFires(level);
        DisasterManager.tickIceMelting(level);
    }

    private static void tickBossbar(ServerLevel level, HeatWaveSavedData hw) {
        if (heatBar == null) {
            heatBar = new ServerBossEvent((Component)Component.m_237113_((String)"HEAT WAVE"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
            heatBar.m_8321_(true);
        }
        for (ServerPlayer p : level.m_6907_()) {
            heatBar.m_6543_(p);
        }
        long remaining = Math.max(0L, hw.endGameTime - level.m_46467_());
        float progress = (float)remaining / (float)Math.max(1L, hw.totalDurationTicks);
        heatBar.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
    }

    public static void onPlayerDrinkWater(ServerPlayer player) {
        lastDrinkTime.put(player.m_20148_(), player.m_9236_().m_46467_());
        exposureTicks.put(player.m_20148_(), 0);
        heatDmgTicks.put(player.m_20148_(), 0);
    }

    private static void tickPlayerDamage(ServerLevel level, HeatWaveSavedData hw) {
        for (ServerPlayer p : level.m_6907_()) {
            boolean inShade;
            UUID id = p.m_20148_();
            boolean inWater = DisasterManager.isPlayerInAnyWater(p);
            boolean bl = inShade = !level.m_45527_(p.m_20183_());
            if (inWater) {
                exposureTicks.put(id, 0);
                heatDmgTicks.put(id, 0);
                if (DisasterManager.isBoilingUnderPlayer(level, hw, p)) {
                    int t = boilDmgTicks.getOrDefault(id, 0) + 1;
                    if (t >= 20) {
                        p.m_6469_(p.m_269291_().m_269047_(), 2.0f);
                        t = 0;
                    }
                    boilDmgTicks.put(id, t);
                    continue;
                }
                boilDmgTicks.put(id, 0);
                continue;
            }
            boilDmgTicks.put(id, 0);
            if (inShade) {
                exposureTicks.put(id, 0);
                heatDmgTicks.put(id, 0);
                continue;
            }
            long last = lastDrinkTime.getOrDefault(id, -999999L);
            if (level.m_46467_() - last <= 200L) {
                exposureTicks.put(id, 0);
                heatDmgTicks.put(id, 0);
                continue;
            }
            int e = exposureTicks.getOrDefault(id, 0) + 1;
            exposureTicks.put(id, e);
            if (e < 200) {
                heatDmgTicks.put(id, 0);
                continue;
            }
            int ht = heatDmgTicks.getOrDefault(id, 0) + 1;
            if (ht >= 30) {
                p.m_6469_(p.m_269291_().m_269549_(), 2.0f);
                ht = 0;
            }
            heatDmgTicks.put(id, ht);
        }
    }

    private static boolean isPlayerInAnyWater(ServerPlayer p) {
        BlockPos pos = p.m_20183_();
        if (p.m_9236_().m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            return true;
        }
        if (p.m_9236_().m_6425_(pos.m_7495_()).m_76152_() == Fluids.f_76193_) {
            return true;
        }
        return p.m_20069_();
    }

    private static boolean isBoilingUnderPlayer(ServerLevel level, HeatWaveSavedData hw, ServerPlayer p) {
        BlockPos pos = p.m_20183_();
        if (level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return hw.waterStage.getOrDefault(pos.m_121878_(), (byte)0) >= 4;
        }
        BlockPos below = pos.m_7495_();
        if (level.m_8055_(below).m_60713_(Blocks.f_49990_)) {
            return hw.waterStage.getOrDefault(below.m_121878_(), (byte)0) >= 4;
        }
        return false;
    }

    private static void rebuildHeatActiveChunks(ServerLevel level) {
        HEAT_ACTIVE_CHUNKS.clear();
        int view = level.m_7654_().m_6846_().m_11312_();
        int sim = level.m_7654_().m_6846_().m_184213_();
        int radius = Math.max(view, sim);
        if (radius < 2) {
            radius = 2;
        }
        for (ServerPlayer p : level.m_6907_()) {
            ChunkPos pc = p.m_146902_();
            int cx = pc.f_45578_;
            int cz = pc.f_45579_;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    HEAT_ACTIVE_CHUNKS.add(ChunkPos.m_45589_((int)(cx + dx), (int)(cz + dz)));
                }
            }
        }
        heatChunkSnapshot = HEAT_ACTIVE_CHUNKS.toLongArray();
        if (waterChunkCursor >= heatChunkSnapshot.length) {
            waterChunkCursor = 0;
        }
        if (fireChunkCursor >= heatChunkSnapshot.length) {
            fireChunkCursor = 0;
        }
        if (iceChunkCursor >= heatChunkSnapshot.length) {
            iceChunkCursor = 0;
        }
    }

    private static void tickGlobalWater(ServerLevel level, HeatWaveSavedData hw) {
        if (heatChunkSnapshot.length == 0) {
            return;
        }
        RandomSource r = level.m_213780_();
        int chunksToProcess = Math.min(8, heatChunkSnapshot.length);
        for (int c = 0; c < chunksToProcess; ++c) {
            if (waterChunkCursor >= heatChunkSnapshot.length) {
                waterChunkCursor = 0;
            }
            long chunkKey = heatChunkSnapshot[waterChunkCursor++];
            ChunkPos cp = new ChunkPos(chunkKey);
            block1: for (int s = 0; s < 3; ++s) {
                int x = cp.m_45604_() + r.m_188503_(16);
                int z = cp.m_45605_() + r.m_188503_(16);
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                for (int k = 0; k < 10 && y > level.m_141937_(); ++k, --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!level.m_8055_(pos).m_60713_(Blocks.f_49990_)) continue;
                    if (!level.m_45527_(pos.m_7494_())) {
                        DisasterManager.coolWater(level, hw, pos, 80);
                        continue block1;
                    }
                    if (DisasterManager.hasIceInRadius(level, pos, 5)) {
                        DisasterManager.coolWater(level, hw, pos, 200);
                        continue block1;
                    }
                    DisasterManager.heatWater(level, hw, pos, 10);
                    continue block1;
                }
            }
        }
    }

    private static void heatWater(ServerLevel level, HeatWaveSavedData hw, BlockPos pos, int add) {
        long key = pos.m_121878_();
        int heat = hw.waterHeat.getOrDefault(key, 0);
        int newHeat = Math.min(2400, heat + add);
        if (newHeat == heat) {
            return;
        }
        hw.waterHeat.put(key, newHeat);
        byte stage = DisasterManager.heatToStage(newHeat);
        byte prev = hw.waterStage.getOrDefault(key, (byte)0);
        if (stage != prev) {
            if (stage <= 0) {
                hw.waterStage.remove(key);
            } else {
                hw.waterStage.put(key, stage);
            }
            ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)new S2CWaterHeatUpdate(pos, stage));
        }
        hw.m_77762_();
    }

    private static void coolWater(ServerLevel level, HeatWaveSavedData hw, BlockPos pos, int sub) {
        long key = pos.m_121878_();
        int heat = hw.waterHeat.getOrDefault(key, 0);
        if (heat <= 0) {
            return;
        }
        int newHeat = Math.max(0, heat - sub);
        if (newHeat == 0) {
            hw.waterHeat.remove(key);
            byte prev = hw.waterStage.getOrDefault(key, (byte)0);
            if (prev != 0) {
                hw.waterStage.remove(key);
                ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)new S2CWaterHeatUpdate(pos, 0));
            }
        } else {
            hw.waterHeat.put(key, newHeat);
            byte stage = DisasterManager.heatToStage(newHeat);
            byte prev = hw.waterStage.getOrDefault(key, (byte)0);
            if (stage != prev) {
                hw.waterStage.put(key, stage);
                ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)new S2CWaterHeatUpdate(pos, stage));
            }
        }
        hw.m_77762_();
    }

    private static byte heatToStage(int heat) {
        if (heat <= 0) {
            return 0;
        }
        if (heat <= 600) {
            return 1;
        }
        if (heat <= 1200) {
            return 2;
        }
        if (heat <= 1800) {
            return 3;
        }
        return 4;
    }

    private static boolean hasIceInRadius(ServerLevel level, BlockPos center, int r) {
        int cx = center.m_123341_();
        int cy = center.m_123342_();
        int cz = center.m_123343_();
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos p = new BlockPos(cx + dx, cy + dy, cz + dz);
                    BlockState s = level.m_8055_(p);
                    if (!s.m_60713_(Blocks.f_50126_) && !s.m_60713_(Blocks.f_50354_) && !s.m_60713_(Blocks.f_50568_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void tickIceMelting(ServerLevel level) {
        if (heatChunkSnapshot.length == 0) {
            return;
        }
        RandomSource r = level.m_213780_();
        int chunksToProcess = Math.min(5, heatChunkSnapshot.length);
        for (int c = 0; c < chunksToProcess; ++c) {
            if (iceChunkCursor >= heatChunkSnapshot.length) {
                iceChunkCursor = 0;
            }
            long chunkKey = heatChunkSnapshot[iceChunkCursor++];
            ChunkPos cp = new ChunkPos(chunkKey);
            block1: for (int s = 0; s < 2; ++s) {
                int x = cp.m_45604_() + r.m_188503_(16);
                int z = cp.m_45605_() + r.m_188503_(16);
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                for (int k = 0; k < 10 && y > level.m_141937_(); ++k, --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState st = level.m_8055_(pos);
                    if (!level.m_45527_(pos.m_7494_())) continue;
                    if (st.m_60713_(Blocks.f_50126_)) {
                        if (!(r.m_188501_() < 0.65f)) continue block1;
                        level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                        continue block1;
                    }
                    if (st.m_60713_(Blocks.f_50354_)) {
                        if (!(r.m_188501_() < 0.35f)) continue block1;
                        level.m_7731_(pos, Blocks.f_50126_.m_49966_(), 3);
                        continue block1;
                    }
                    if (!st.m_60713_(Blocks.f_50568_)) continue;
                    if (!(r.m_188501_() < 0.12f)) continue block1;
                    level.m_7731_(pos, Blocks.f_50354_.m_49966_(), 3);
                    continue block1;
                }
            }
        }
    }

    private static void tickGlobalFires(ServerLevel level) {
        if (heatChunkSnapshot.length == 0) {
            return;
        }
        RandomSource r = level.m_213780_();
        int chunksToProcess = Math.min(6, heatChunkSnapshot.length);
        for (int c = 0; c < chunksToProcess; ++c) {
            if (fireChunkCursor >= heatChunkSnapshot.length) {
                fireChunkCursor = 0;
            }
            long chunkKey = heatChunkSnapshot[fireChunkCursor++];
            ChunkPos cp = new ChunkPos(chunkKey);
            for (int a = 0; a < 2; ++a) {
                BlockState fire;
                BlockPos below;
                BlockState belowState;
                int z;
                int y;
                int x = cp.m_45604_() + r.m_188503_(16);
                BlockPos pos = new BlockPos(x, (y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = cp.m_45605_() + r.m_188503_(16))) + 1, z);
                if (!level.m_8055_(pos).m_60795_() || !(belowState = level.m_8055_(below = pos.m_7495_())).isFlammable((BlockGetter)level, below, Direction.UP) || level.m_46758_(pos) || DisasterManager.isNearWater(level, pos, 2) && r.m_188501_() < 0.9f || !(fire = Blocks.f_50083_.m_49966_()).m_60710_((LevelReader)level, pos)) continue;
                level.m_7731_(pos, fire, 3);
            }
        }
    }

    private static boolean isNearWater(ServerLevel level, BlockPos center, int r) {
        int cx = center.m_123341_();
        int cy = center.m_123342_();
        int cz = center.m_123343_();
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos p = new BlockPos(cx + dx, cy + dy, cz + dz);
                    if (level.m_6425_(p).m_76152_() != Fluids.f_76193_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void onChunkLoaded(ServerLevel level, ChunkPos pos) {
    }

    public static void onChunkUnloaded(ServerLevel level, ChunkPos pos) {
    }

    private static void broadcastWaterClear(ServerLevel level) {
        ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), (Object)new S2CWaterHeatClear());
    }

    public static void syncWaterStateToPlayer(ServerLevel level, ServerPlayer player) {
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CWaterHeatClear());
        int radius = 96;
        int max = 5000;
        ArrayList<S2CWaterHeatBulk.Entry> list = new ArrayList<S2CWaterHeatBulk.Entry>();
        BlockPos c = player.m_20183_();
        int count = 0;
        for (Long2ByteMap.Entry e : hw.waterStage.long2ByteEntrySet()) {
            BlockPos p;
            if (count >= max) break;
            byte st = e.getByteValue();
            if (st <= 0 || Math.abs((p = BlockPos.m_122022_((long)e.getLongKey())).m_123341_() - c.m_123341_()) > radius || Math.abs(p.m_123342_() - c.m_123342_()) > 64 || Math.abs(p.m_123343_() - c.m_123343_()) > radius) continue;
            list.add(new S2CWaterHeatBulk.Entry(p, st));
            ++count;
        }
        if (!list.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CWaterHeatBulk(list));
        }
    }

    public static boolean isBoilingWater(ServerLevel level, BlockPos pos) {
        HeatWaveSavedData hw = HeatWaveSavedData.get(level);
        return hw.waterStage.getOrDefault(pos.m_121878_(), (byte)0) >= 4;
    }
}

