/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.network;

import com.rogerinscii.naturaldisasters.client.water.WaterHeatClientData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CWaterHeatBulk {
    private final List<Entry> entries;

    public S2CWaterHeatBulk(List<Entry> entries) {
        this.entries = entries;
    }

    public static void encode(S2CWaterHeatBulk msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entries.size());
        for (Entry e : msg.entries) {
            buf.m_130064_(e.pos);
            buf.writeByte((int)e.stage);
        }
    }

    public static S2CWaterHeatBulk decode(FriendlyByteBuf buf) {
        int n = buf.m_130242_();
        ArrayList<Entry> list = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            BlockPos pos = buf.m_130135_();
            byte st = buf.readByte();
            list.add(new Entry(pos, st));
        }
        return new S2CWaterHeatBulk(list);
    }

    public static void handle(S2CWaterHeatBulk msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            for (Entry e : msg.entries) {
                WaterHeatClientData.setStage(e.pos, e.stage);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class Entry {
        public final BlockPos pos;
        public final byte stage;

        public Entry(BlockPos pos, byte stage) {
            this.pos = pos;
            this.stage = stage;
        }
    }
}

