/*
 * Decompiled with CFR 0.152.
 */
package com.rogerinscii.naturaldisasters.save;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class MeteorShowerSavedData
extends SavedData {
    public boolean active = false;
    public int mode = 1;
    public long startGameTime = 0L;
    public long endGameTime = 0L;
    public long totalDurationTicks = 1200L;
    public int meteorsTotal = 10;
    public int meteorsSpawned = 0;
    public long nextSpawnGameTime = 0L;
    public long baseChunkLong = 0L;
    public UUID singlePlayer = null;
    public final List<UUID> pendingPlayers = new ArrayList<UUID>();
    public long seed = 0L;

    public static MeteorShowerSavedData get(ServerLevel level) {
        return (MeteorShowerSavedData)level.m_8895_().m_164861_(MeteorShowerSavedData::load, MeteorShowerSavedData::new, "naturaldisasters_meteor_shower");
    }

    public static MeteorShowerSavedData load(CompoundTag tag) {
        MeteorShowerSavedData d = new MeteorShowerSavedData();
        d.active = tag.m_128471_("a");
        d.mode = tag.m_128451_("m");
        d.startGameTime = tag.m_128454_("st");
        d.endGameTime = tag.m_128454_("et");
        d.totalDurationTicks = tag.m_128454_("dur");
        d.meteorsTotal = tag.m_128451_("tot");
        d.meteorsSpawned = tag.m_128451_("sp");
        d.nextSpawnGameTime = tag.m_128454_("nx");
        d.baseChunkLong = tag.m_128454_("base");
        if (tag.m_128403_("single")) {
            d.singlePlayer = tag.m_128342_("single");
        }
        d.seed = tag.m_128454_("seed");
        d.pendingPlayers.clear();
        int n = tag.m_128451_("pn");
        for (int i = 0; i < n; ++i) {
            String key = "p" + i;
            if (!tag.m_128403_(key)) continue;
            d.pendingPlayers.add(tag.m_128342_(key));
        }
        return d;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("a", this.active);
        tag.m_128405_("m", this.mode);
        tag.m_128356_("st", this.startGameTime);
        tag.m_128356_("et", this.endGameTime);
        tag.m_128356_("dur", this.totalDurationTicks);
        tag.m_128405_("tot", this.meteorsTotal);
        tag.m_128405_("sp", this.meteorsSpawned);
        tag.m_128356_("nx", this.nextSpawnGameTime);
        tag.m_128356_("base", this.baseChunkLong);
        if (this.singlePlayer != null) {
            tag.m_128362_("single", this.singlePlayer);
        }
        tag.m_128356_("seed", this.seed);
        tag.m_128405_("pn", this.pendingPlayers.size());
        for (int i = 0; i < this.pendingPlayers.size(); ++i) {
            tag.m_128362_("p" + i, this.pendingPlayers.get(i));
        }
        return tag;
    }
}

