/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.darkblood.item;

import java.util.List;
import net.mcreator.darkblood.procedures.RunningButcherAxeLivingEntityIsHitWithToolProcedure;
import net.mcreator.darkblood.procedures.RunningButcherAxeToolInHandTickProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RunningButcherAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 200;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 22;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public RunningButcherAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)14.8f, (float)-2.4f)).fireResistant());
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        RunningButcherAxeLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.dark_blood.running_butcher_axe.description_0"));
        list.add((Component)Component.translatable((String)"item.dark_blood.running_butcher_axe.description_1"));
        list.add((Component)Component.translatable((String)"item.dark_blood.running_butcher_axe.description_2"));
        list.add((Component)Component.translatable((String)"item.dark_blood.running_butcher_axe.description_3"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            RunningButcherAxeToolInHandTickProcedure.execute(entity);
        }
    }
}

