/*
 * Decompiled with CFR 0.152.
 */
package net.mangoreggie.blockarmor.init;

import net.mangoreggie.blockarmor.network.FlootMessage;
import net.mangoreggie.blockarmor.network.SpecialEffectKeyMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class BlockArmorModKeyMappings {
    public static final KeyMapping FLOOT = new KeyMapping("key.block_armor.floot", 32, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new FlootMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                FlootMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
                FLOOT_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - FLOOT_LASTPRESS);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new FlootMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                FlootMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    public static final KeyMapping SPECIAL_EFFECT_KEY = new KeyMapping("key.block_armor.special_effect_key", 82, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SpecialEffectKeyMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SpecialEffectKeyMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
                SPECIAL_EFFECT_KEY_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - SPECIAL_EFFECT_KEY_LASTPRESS);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SpecialEffectKeyMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SpecialEffectKeyMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    private static long FLOOT_LASTPRESS = 0L;
    private static long SPECIAL_EFFECT_KEY_LASTPRESS = 0L;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(FLOOT);
        event.register(SPECIAL_EFFECT_KEY);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                FLOOT.consumeClick();
                SPECIAL_EFFECT_KEY.consumeClick();
            }
        }
    }
}

