/*
 * Decompiled with CFR 0.152.
 */
package net.mangoreggie.blockarmor.network;

import net.mangoreggie.blockarmor.BlockArmorMod;
import net.mangoreggie.blockarmor.procedures.EffectKeyPressedProcedure;
import net.mangoreggie.blockarmor.procedures.EffectKeyReleasedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record SpecialEffectKeyMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpecialEffectKeyMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"block_armor", (String)"key_special_effect_key"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpecialEffectKeyMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new SpecialEffectKeyMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SpecialEffectKeyMessage> type() {
        return TYPE;
    }

    public static void handleData(SpecialEffectKeyMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> SpecialEffectKeyMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            EffectKeyPressedProcedure.execute((LevelAccessor)world);
        }
        if (type == 1) {
            EffectKeyReleasedProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BlockArmorMod.addNetworkMessage(TYPE, STREAM_CODEC, SpecialEffectKeyMessage::handleData);
    }
}

