/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.xkball.panoramic_screenshot.Config;
import com.xkball.panoramic_screenshot.IExtendedWindow;
import com.xkball.panoramic_screenshot.PanoramicScreenShotHelper;
import com.xkball.panoramic_screenshot.utils.TickSequence;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PanoramicScreenshotParameters;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

@Mod(value="panoramic_screenshot", dist={Dist.CLIENT})
@EventBusSubscriber(value={Dist.CLIENT})
public class PanoramicScreenshot {
    public static final String MODID = "panoramic_screenshot";
    private static final Logger LOGGER = LogUtils.getLogger();

    public PanoramicScreenshot(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public static void onRegClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"screenshot").then(((LiteralArgumentBuilder)Commands.literal((String)"normal").executes(c -> {
            Screenshot.grab((File)FMLPaths.GAMEDIR.get().toFile(), (RenderTarget)Minecraft.getInstance().getMainRenderTarget(), co -> Minecraft.getInstance().execute(() -> Minecraft.getInstance().gui.getChat().addMessage(co)));
            return 0;
        })).then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(PanoramicScreenshot::screenshotWithSize))))).then(Commands.literal((String)"panoramic").then(((RequiredArgumentBuilder)Commands.argument((String)"mode", (ArgumentType)EnumArgument.enumArgument(PanoramicScreenShotHelper.Mode.class)).executes(PanoramicScreenShotHelper.INSTANCE::startDefault)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).then(Commands.argument((String)"fov", (ArgumentType)IntegerArgumentType.integer((int)1, (int)179)).then(Commands.argument((String)"yaw_start", (ArgumentType)IntegerArgumentType.integer((int)0, (int)360)).then(Commands.argument((String)"frame_delay", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(PanoramicScreenShotHelper.INSTANCE::start)))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"skybox").executes(c -> {
            Component co = PanoramicScreenshot.grabPanoramixScreenshot("skybox", 2048, 2048);
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().gui.getChat().addMessage(co));
            return 0;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(c -> {
            String name = StringArgumentType.getString((CommandContext)c, (String)"name");
            int size = IntegerArgumentType.getInteger((CommandContext)c, (String)"size");
            Component co = PanoramicScreenshot.grabPanoramixScreenshot(name, size, size);
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().gui.getChat().addMessage(co));
            return 0;
        })))));
    }

    public static int screenshotWithSize(CommandContext<CommandSourceStack> context) {
        int width = IntegerArgumentType.getInteger(context, (String)"width");
        int height = IntegerArgumentType.getInteger(context, (String)"height");
        TickSequence.builder().append(() -> IExtendedWindow.get().enableOverride(width, height)).waitTicks(1).append("after game render", () -> Screenshot.grab((File)FMLPaths.GAMEDIR.get().toFile(), (RenderTarget)Minecraft.getInstance().getMainRenderTarget(), co -> Minecraft.getInstance().execute(() -> Minecraft.getInstance().gui.getChat().addMessage(co)))).waitTicks(1).append(() -> IExtendedWindow.get().disableOverride()).buildInClient();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component grabPanoramixScreenshot(String name, int width, int height) {
        MutableComponent mutablecomponent;
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        LocalPlayer player = mc.player;
        File gameDirectory = FMLPaths.GAMEDIR.get().toFile();
        int l = window.getWidth();
        int i1 = window.getHeight();
        RenderTarget rendertarget = mc.getMainRenderTarget();
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = player.xRotO;
        float f3 = player.yRotO;
        mc.gameRenderer.setRenderBlockOutline(false);
        try {
            mc.gameRenderer.setPanoramicScreenshotParameters(new PanoramicScreenshotParameters((Vector3fc)new Vector3f(mc.gameRenderer.getMainCamera().forwardVector())));
            window.setWidth(width);
            window.setHeight(height);
            rendertarget.resize(width, height);
            for (int j1 = 0; j1 < 6; ++j1) {
                switch (j1) {
                    case 0: {
                        player.setYRot(f1);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 1: {
                        player.setYRot((f1 + 90.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 2: {
                        player.setYRot((f1 + 180.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 3: {
                        player.setYRot((f1 - 90.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 4: {
                        player.setYRot(f1);
                        player.setXRot(-90.0f);
                        break;
                    }
                    default: {
                        player.setYRot(f1);
                        player.setXRot(90.0f);
                    }
                }
                player.yRotO = player.getYRot();
                player.xRotO = player.getXRot();
                mc.gameRenderer.updateCamera(DeltaTracker.ONE);
                mc.gameRenderer.renderLevel(DeltaTracker.ONE);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.grab((File)gameDirectory, (String)(name + "_" + j1 + ".png"), (RenderTarget)rendertarget, (int)1, p_231415_ -> {});
            }
            MutableComponent component = Component.literal((String)gameDirectory.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_392492_ -> p_392492_.withClickEvent((ClickEvent)new ClickEvent.OpenFile(gameDirectory.getAbsoluteFile())));
            MutableComponent mutableComponent = Component.translatable((String)"screenshot.success", (Object[])new Object[]{component});
            return mutableComponent;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save image", (Throwable)exception);
            mutablecomponent = Component.translatable((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
        }
        finally {
            player.setXRot(f);
            player.setYRot(f1);
            player.xRotO = f2;
            player.yRotO = f3;
            mc.gameRenderer.setRenderBlockOutline(true);
            window.setWidth(l);
            window.setHeight(i1);
            rendertarget.resize(l, i1);
            mc.gameRenderer.setPanoramicScreenshotParameters(null);
        }
        return mutablecomponent;
    }
}

