/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.annotations.MethodsReturnNonnullByDefault;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xkball.panoramic_screenshot.utils.ThrowableSupplier;
import com.xkball.panoramic_screenshot.utils.VanillaUtils;
import com.xkball.panoramic_screenshot.utils.WeightLootTable;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.CubeMapTexture;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@EventBusSubscriber
public class SkyboxLoader
extends SimplePreparableReloadListener<List<Pair<Identifier, SkyboxData>>> {
    public static SkyboxLoader INSTANCE = new SkyboxLoader();

    protected List<Pair<Identifier, SkyboxData>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Map resources = resourceManager.listResources("textures/gui/title/background", rl -> rl.getPath().endsWith(".json"));
        return resources.entrySet().stream().map(entry -> Pair.of((Object)((Identifier)entry.getKey()), (Object)ThrowableSupplier.getOrThrow(() -> VanillaUtils.readJsonFromResource((Resource)entry.getValue())))).map(pair -> Pair.of((Object)((Identifier)pair.getFirst()), (Object)SkyboxData.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)pair.getSecond())))).map(pair -> Pair.of((Object)((Identifier)pair.getFirst()), (Object)((SkyboxData)((Pair)((DataResult)pair.getSecond()).getOrThrow()).getFirst()))).toList();
    }

    protected void apply(List<Pair<Identifier, SkyboxData>> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (object.isEmpty()) {
            return;
        }
        WeightLootTable<Pair> loot = new WeightLootTable<Pair>(object, o -> ((SkyboxData)o.getSecond()).weight);
        Pair data = loot.roll(RandomSource.create());
        Identifier rl = (Identifier)data.getFirst();
        Identifier cubeMapRl = Identifier.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath().substring(0, rl.getPath().lastIndexOf(47) + 1) + ((SkyboxData)data.getSecond()).name));
        CubeMap cubeMap = new CubeMap(cubeMapRl);
        Minecraft.getInstance().getTextureManager().registerAndLoad(cubeMapRl, (ReloadableTexture)new CubeMapTexture(cubeMapRl));
        Minecraft.getInstance().gameRenderer.cubeMap.close();
        Minecraft.getInstance().gameRenderer.cubeMap = cubeMap;
        Minecraft.getInstance().gameRenderer.panorama = new PanoramaRenderer(cubeMap);
    }

    @SubscribeEvent
    public static void onDataPackReload(AddClientReloadListenersEvent event) {
        event.addListener(VanillaUtils.modRL("skybox"), (PreparableReloadListener)INSTANCE);
    }

    public record SkyboxData(String name, int weight) {
        public static final Codec<SkyboxData> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("name").forGetter(SkyboxData::name), (App)Codec.INT.fieldOf("weight").forGetter(SkyboxData::weight)).apply((Applicative)ins, SkyboxData::new));
    }
}

