/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot.utils;

import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@FunctionalInterface
public interface ThrowableSupplier<T> {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static <T> Supplier<T> unwrapOrThrow(ThrowableSupplier<T> supplier) {
        return () -> ThrowableSupplier.getOrThrow(supplier);
    }

    public static <T> T getOrThrow(ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getOrThrow(ThrowableSupplier<T> supplier, String errMsg) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            LOGGER.error(errMsg, e);
            throw new RuntimeException(errMsg, e);
        }
    }

    public static <T> T getOrElse(ThrowableSupplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static <T> T getOrElse(ThrowableSupplier<T> supplier, T defaultValue, String errMsg) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            LOGGER.error(errMsg, e);
            return defaultValue;
        }
    }

    public static <T> T getOrElse(ThrowableSupplier<T> supplier, T defaultValue, Consumer<Throwable> exceptionHandler) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return defaultValue;
        }
    }

    @Nullable
    public static <T> T getOrNull(ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    public static <T> T getOrNull(ThrowableSupplier<T> supplier, String errMsg) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            LOGGER.error(errMsg, e);
            return null;
        }
    }

    @Nullable
    public static <T> T getOrNull(ThrowableSupplier<T> supplier, Consumer<Throwable> exceptionHandler) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    @NotNull
    public T get() throws Throwable;
}

