/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot.utils;

import com.mojang.datafixers.util.Pair;
import com.xkball.panoramic_screenshot.utils.TickSequenceHandler;
import java.util.LinkedList;
import java.util.Queue;

public class TickSequence {
    private final Queue<Pair<String, Runnable>> tickSequence;

    private TickSequence(Queue<Pair<String, Runnable>> tickSequence) {
        this.tickSequence = tickSequence;
    }

    public void accept(String tickPhase) {
        if (this.isEmpty()) {
            return;
        }
        if (((String)this.tickSequence.peek().getFirst()).equals(tickPhase)) {
            ((Runnable)this.tickSequence.poll().getSecond()).run();
        }
    }

    public boolean isEmpty() {
        return this.tickSequence.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Queue<Pair<String, Runnable>> tickSequence = new LinkedList<Pair<String, Runnable>>();

        public Builder append(String tickPhase, Runnable runnable) {
            this.tickSequence.add((Pair<String, Runnable>)Pair.of((Object)tickPhase, (Object)runnable));
            return this;
        }

        public Builder append(Runnable runnable) {
            this.tickSequence.add((Pair<String, Runnable>)Pair.of((Object)"tick pre", (Object)runnable));
            return this;
        }

        public Builder waitTicks(int i) {
            for (int j = 0; j < i; ++j) {
                this.tickSequence.add((Pair<String, Runnable>)Pair.of((Object)"tick pre", () -> {}));
            }
            return this;
        }

        public TickSequence buildInClient() {
            TickSequence result = new TickSequence(this.tickSequence);
            TickSequenceHandler.CLIENT_HANDLER.submit(result);
            return result;
        }
    }
}

