/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.xkball.panoramic_screenshot.Config;
import com.xkball.panoramic_screenshot.IExtendedWindow;
import com.xkball.panoramic_screenshot.PanoramicScreenShotHelper;
import com.xkball.panoramic_screenshot.utils.TickSequence;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.command.EnumArgument;
import org.slf4j.Logger;

@Mod(value="panoramic_screenshot")
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PanoramicScreenshot {
    public static final String MODID = "panoramic_screenshot";
    private static final Logger LOGGER = LogUtils.getLogger();

    public PanoramicScreenshot(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public static void onRegClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"screenshot").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"normal").executes(c -> {
            Screenshot.m_92289_((File)FMLPaths.GAMEDIR.get().toFile(), (RenderTarget)Minecraft.m_91087_().m_91385_(), co -> Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(co)));
            return 0;
        })).then(Commands.m_82129_((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(PanoramicScreenshot::screenshotWithSize))))).then(Commands.m_82127_((String)"panoramic").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", (ArgumentType)EnumArgument.enumArgument(PanoramicScreenShotHelper.Mode.class)).executes(PanoramicScreenShotHelper.INSTANCE::startDefault)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).then(Commands.m_82129_((String)"fov", (ArgumentType)IntegerArgumentType.integer((int)1, (int)179)).then(Commands.m_82129_((String)"yaw_start", (ArgumentType)IntegerArgumentType.integer((int)0, (int)360)).then(Commands.m_82129_((String)"frame_delay", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(PanoramicScreenShotHelper.INSTANCE::start)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"skybox").executes(c -> {
            Component co = PanoramicScreenshot.grabPanoramixScreenshot("skybox", 2048, 2048);
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(co));
            return 0;
        })).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16384)).executes(c -> {
            String name = StringArgumentType.getString((CommandContext)c, (String)"name");
            int size = IntegerArgumentType.getInteger((CommandContext)c, (String)"size");
            Component co = PanoramicScreenshot.grabPanoramixScreenshot(name, size, size);
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(co));
            return 0;
        })))));
    }

    public static int screenshotWithSize(CommandContext<CommandSourceStack> context) {
        int width = IntegerArgumentType.getInteger(context, (String)"width");
        int height = IntegerArgumentType.getInteger(context, (String)"height");
        TickSequence.builder().append(() -> IExtendedWindow.get().enableOverride(width, height)).waitTicks(1).append("after game render", () -> Screenshot.m_92289_((File)FMLPaths.GAMEDIR.get().toFile(), (RenderTarget)Minecraft.m_91087_().m_91385_(), co -> Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(co)))).waitTicks(1).append(() -> IExtendedWindow.get().disableOverride()).buildInClient();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component grabPanoramixScreenshot(String name, int width, int height) {
        MutableComponent mutablecomponent;
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        LocalPlayer player = mc.f_91074_;
        File gameDirectory = FMLPaths.GAMEDIR.get().toFile();
        int i = window.m_85441_();
        int j = window.m_85442_();
        TextureTarget rendertarget = new TextureTarget(width, height, true, Minecraft.f_91002_);
        float f = mc.f_91074_.m_146909_();
        float f1 = mc.f_91074_.m_146908_();
        float f2 = mc.f_91074_.f_19860_;
        float f3 = mc.f_91074_.f_19859_;
        mc.f_91063_.m_172775_(false);
        try {
            mc.f_91063_.m_172779_(true);
            mc.f_91060_.m_173014_();
            window.m_166450_(width);
            window.m_166452_(height);
            for (int k = 0; k < 6; ++k) {
                switch (k) {
                    case 0: {
                        player.m_146922_(f1);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 1: {
                        player.m_146922_((f1 + 90.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 2: {
                        player.m_146922_((f1 + 180.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 3: {
                        player.m_146922_((f1 - 90.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 4: {
                        player.m_146922_(f1);
                        player.m_146926_(-90.0f);
                        break;
                    }
                    default: {
                        player.m_146922_(f1);
                        player.m_146926_(90.0f);
                    }
                }
                player.f_19859_ = player.m_146908_();
                player.f_19860_ = player.m_146909_();
                rendertarget.m_83947_(true);
                mc.f_91063_.m_109089_(1.0f, 0L, new PoseStack());
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.m_92295_((File)gameDirectory, (String)(name + "_" + k + ".png"), (RenderTarget)rendertarget, p_231415_ -> {});
            }
            MutableComponent component = Component.m_237113_((String)gameDirectory.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_231426_ -> p_231426_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, gameDirectory.getAbsolutePath())));
            MutableComponent mutableComponent = Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{component});
            return mutableComponent;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save image", (Throwable)exception);
            mutablecomponent = Component.m_237110_((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
        }
        finally {
            player.m_146926_(f);
            player.m_146922_(f1);
            player.f_19860_ = f2;
            player.f_19859_ = f3;
            mc.f_91063_.m_172775_(true);
            window.m_166450_(i);
            window.m_166452_(j);
            rendertarget.m_83930_();
            mc.f_91063_.m_172779_(false);
            mc.f_91060_.m_173014_();
            mc.m_91385_().m_83947_(true);
        }
        return mutablecomponent;
    }
}

