/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.codec.binary.Base64;

public class VanillaUtils {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final ResourceLocation MISSING_TEXTURE = ResourceLocation.withDefaultNamespace((String)"missingno");
    public static final int TRANSPARENT = VanillaUtils.getColor(255, 255, 255, 0);
    public static final int GUI_GRAY = VanillaUtils.getColor(30, 30, 30, 200);

    public static ResourceLocation modRL(String path) {
        return VanillaUtils.rLOf("panoramic_screenshot", path);
    }

    public static ResourceLocation rLOf(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static EquipmentSlot equipmentSlotFromHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static void runCommand(String command, MinecraftServer server, UUID playerUUID) {
        ServerPlayer player = server.m_6846_().m_11259_(playerUUID);
        if (player != null) {
            server.m_129892_().m_230957_(player.m_20203_().m_81325_(2), command);
        }
    }

    public static int getColor(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int parseColorHEX(String color) throws IllegalArgumentException {
        if (color.length() == 6) {
            return VanillaUtils.getColor(Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4, 6), 16), 255);
        }
        if (color.length() == 8) {
            return VanillaUtils.getColor(Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4, 6), 16), Integer.parseInt(color.substring(6, 8), 16));
        }
        throw new IllegalArgumentException("Format of color must be RGB or RGBA digits");
    }

    public static String hexColorFromInt(int color) {
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return String.format("%02X%02X%02X%02X", r, g, b, a).toUpperCase();
    }

    public static Vec2 rotate90FromBlockCenterYP(Vec2 point, int times) {
        if ((times %= 4) == 0) {
            return point;
        }
        float x = point.f_82470_;
        float y = point.f_82471_;
        if (times == 1) {
            return new Vec2(16.0f - y, x);
        }
        if (times == 2) {
            return new Vec2(16.0f - x, 16.0f - y);
        }
        return new Vec2(y, 16.0f - x);
    }

    public static String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(input.getBytes());
            return HexFormat.of().formatHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String removeAfterLastCharOf(String str, char c) {
        return str.substring(0, str.lastIndexOf(c));
    }

    public static List<String> searchStartWith(String key, Collection<String> src) {
        ArrayList<String> startWithList = new ArrayList<String>();
        for (String str : src) {
            String searchEntry = str.toLowerCase();
            if (!searchEntry.startsWith(key)) continue;
            startWithList.add(str);
        }
        startWithList.sort(String::compareTo);
        return startWithList;
    }

    public static List<String> searchInLowerCase(String key, Collection<String> src) {
        key = key.toLowerCase();
        ArrayList<String> startWithList = new ArrayList<String>();
        ArrayList<String> containsList = new ArrayList<String>();
        for (String str : src) {
            String searchEntry = str.toLowerCase();
            if (searchEntry.startsWith(key)) {
                startWithList.add(str);
                continue;
            }
            if (!searchEntry.contains(key)) continue;
            containsList.add(str);
        }
        startWithList.sort(String::compareTo);
        containsList.sort(String::compareTo);
        startWithList.addAll(containsList);
        return startWithList;
    }

    public static List<String> search(String key, Collection<String> src) {
        ArrayList<String> startWithList = new ArrayList<String>();
        ArrayList<String> containsList = new ArrayList<String>();
        for (String str : src) {
            if (str.startsWith(key)) {
                startWithList.add(str);
                continue;
            }
            if (!str.contains(key)) continue;
            containsList.add(str);
        }
        startWithList.sort(String::compareTo);
        containsList.sort(String::compareTo);
        startWithList.addAll(containsList);
        return startWithList;
    }

    public static JsonElement readJsonFromResource(Resource resource) throws IOException {
        try (BufferedReader reader = resource.m_215508_();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            return jsonElement;
        }
    }
}

