/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.util.RandomSource;

public class WeightLootTable<T> {
    private final List<T> loops = new ArrayList<T>();
    private final int[] weightSums;
    private int weightCount;

    public WeightLootTable(List<T> loots, ToIntFunction<T> weightFunction) {
        this.loops.addAll(loots);
        int[] weights = new int[loots.size()];
        this.weightSums = new int[loots.size()];
        weights[0] = weightFunction.applyAsInt(loots.get(0));
        this.weightSums[0] = weights[0];
        this.weightCount = weights[0];
        for (int i = 1; i < weights.length; ++i) {
            weights[i] = weightFunction.applyAsInt(loots.get(i));
            this.weightSums[i] = this.weightSums[i - 1] + weights[i];
            this.weightCount += weights[i];
        }
    }

    public T roll(RandomSource random) {
        int i = random.m_188503_(this.weightCount + 1);
        int index = Arrays.binarySearch(this.weightSums, i);
        if (index < 0) {
            return this.loops.get(Math.min(-(index + 1), this.loops.size() - 1));
        }
        return this.loops.get(index);
    }
}

