/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.xkball.panoramic_screenshot.IExtendedWindow;
import com.xkball.panoramic_screenshot.PauseOverlay;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class PanoramicScreenShotHelper {
    public static final PanoramicScreenShotHelper INSTANCE = new PanoramicScreenShotHelper();
    public int fov;
    public int yaw_start;
    public int frame_delay;
    public int screenHeight;
    private int delay;
    private float rotation;
    public boolean takeScreenShot;
    private int colWidth;
    private float fovPerPixel;
    private int currentX;
    private NativeImage image;
    private State state = State.IDLE;
    private Mode mode = Mode.PRECISE;

    private PanoramicScreenShotHelper() {
    }

    public void writeImageSection(NativeImage image) {
        Window window = Minecraft.m_91087_().m_91268_();
        int h = window.m_85442_();
        int w = (int)((float)h * ((float)window.m_85441_() / (float)window.m_85442_()));
        int centerStart = (int)((float)w / 2.0f - (float)this.colWidth / 2.0f);
        for (int x = 0; x < this.colWidth; ++x) {
            for (int y = 0; y < h; ++y) {
                this.image.m_84988_(x + this.currentX, y, image.m_84985_(centerStart + x, y));
            }
        }
        this.currentX += this.colWidth;
        image.close();
    }

    public void startDefault(Mode mode) {
        this.screenHeight = Minecraft.m_91087_().m_91268_().m_85444_();
        this.fov = (Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_();
        this.yaw_start = 0;
        this.frame_delay = 0;
        this.mode = mode;
        this.state = State.PREPARE;
    }

    public int startDefault(CommandContext<CommandSourceStack> source) {
        this.startDefault((Mode)((Object)source.getArgument("mode", Mode.class)));
        return 0;
    }

    public int start(CommandContext<CommandSourceStack> source) {
        this.screenHeight = IntegerArgumentType.getInteger(source, (String)"height");
        this.fov = IntegerArgumentType.getInteger(source, (String)"fov");
        this.yaw_start = IntegerArgumentType.getInteger(source, (String)"yaw_start");
        this.frame_delay = IntegerArgumentType.getInteger(source, (String)"frame_delay");
        this.mode = (Mode)((Object)source.getArgument("mode", Mode.class));
        this.state = State.PREPARE;
        return 0;
    }

    @SubscribeEvent
    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        switch (PanoramicScreenShotHelper.INSTANCE.state) {
            case IDLE: {
                break;
            }
            case PREPARE: {
                PanoramicScreenShotHelper.INSTANCE.state = State.CAPTURING;
                Window window = Minecraft.m_91087_().m_91268_();
                int h = PanoramicScreenShotHelper.INSTANCE.screenHeight;
                float as = (float)window.m_85441_() / (float)window.m_85442_();
                int w = (int)((float)h * as);
                IExtendedWindow.cast(window).enableOverride(w, h);
                if (PanoramicScreenShotHelper.INSTANCE.mode == Mode.FAST) {
                    PanoramicScreenShotHelper.INSTANCE.colWidth = h / PanoramicScreenShotHelper.INSTANCE.fov;
                    PanoramicScreenShotHelper.INSTANCE.fovPerPixel = 1.0f;
                    PanoramicScreenShotHelper.INSTANCE.image = new NativeImage(PanoramicScreenShotHelper.INSTANCE.colWidth * 360, h, false);
                } else {
                    PanoramicScreenShotHelper.INSTANCE.colWidth = 1;
                    PanoramicScreenShotHelper.INSTANCE.fovPerPixel = (float)PanoramicScreenShotHelper.INSTANCE.fov / (float)h;
                    PanoramicScreenShotHelper.INSTANCE.image = new NativeImage((int)(360.0f / PanoramicScreenShotHelper.INSTANCE.fovPerPixel) + 1, h, false);
                }
                PanoramicScreenShotHelper.INSTANCE.rotation = 0.0f;
                PanoramicScreenShotHelper.INSTANCE.currentX = 0;
                Minecraft.m_91087_().m_91150_((Overlay)new PauseOverlay());
                break;
            }
            case CAPTURING: {
                if (PanoramicScreenShotHelper.INSTANCE.takeScreenShot) break;
                if (PanoramicScreenShotHelper.INSTANCE.rotation >= 360.0f) {
                    PanoramicScreenShotHelper.INSTANCE.state = State.FINISHING;
                    break;
                }
                event.setYaw((PanoramicScreenShotHelper.INSTANCE.rotation + (float)PanoramicScreenShotHelper.INSTANCE.yaw_start) % 360.0f);
                event.setPitch(0.0f);
                if (PanoramicScreenShotHelper.INSTANCE.delay < PanoramicScreenShotHelper.INSTANCE.frame_delay) {
                    ++PanoramicScreenShotHelper.INSTANCE.delay;
                    break;
                }
                PanoramicScreenShotHelper.INSTANCE.delay = 0;
                PanoramicScreenShotHelper.INSTANCE.rotation += PanoramicScreenShotHelper.INSTANCE.mode.advanceRotation();
                PanoramicScreenShotHelper.INSTANCE.takeScreenShot = true;
                break;
            }
            case FINISHING: {
                PanoramicScreenShotHelper.INSTANCE.state = State.IDLE;
                Path file = FMLPaths.GAMEDIR.get().resolve("screenshots").resolve("panorama" + Util.m_241986_() + ".png");
                try {
                    file.getParent().toFile().mkdirs();
                    PanoramicScreenShotHelper.INSTANCE.image.m_85066_(file);
                    PanoramicScreenShotHelper.INSTANCE.image.close();
                    PanoramicScreenShotHelper.INSTANCE.image = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Minecraft.m_91087_().m_91150_(null);
                IExtendedWindow.cast(Minecraft.m_91087_().m_91268_()).disableOverride();
                Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)file.toFile().getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.toFile().getAbsolutePath())))));
            }
        }
    }

    @SubscribeEvent
    public static void onSetupFov(ViewportEvent.ComputeFov event) {
        if (PanoramicScreenShotHelper.INSTANCE.state == State.CAPTURING) {
            event.setFOV((double)PanoramicScreenShotHelper.INSTANCE.fov);
        }
    }

    public static enum State {
        IDLE,
        PREPARE,
        CAPTURING,
        FINISHING;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        FAST{

            @Override
            public float advanceRotation() {
                return 1.0f;
            }
        }
        ,
        PRECISE{

            @Override
            public float advanceRotation() {
                return PanoramicScreenShotHelper.INSTANCE.fovPerPixel;
            }
        };


        public float advanceRotation() {
            return 0.0f;
        }
    }
}

