/*
 * Decompiled with CFR 0.152.
 */
package com.xkball.panoramic_screenshot;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xkball.panoramic_screenshot.utils.ThrowableSupplier;
import com.xkball.panoramic_screenshot.utils.VanillaUtils;
import com.xkball.panoramic_screenshot.utils.WeightLootTable;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkyboxLoader
extends SimplePreparableReloadListener<List<Pair<ResourceLocation, SkyboxData>>> {
    public static SkyboxLoader INSTANCE = new SkyboxLoader();

    protected List<Pair<ResourceLocation, SkyboxData>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Map resources = resourceManager.m_214159_("textures/gui/title/background", rl -> rl.m_135815_().endsWith(".json"));
        return resources.entrySet().stream().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)ThrowableSupplier.getOrThrow(() -> VanillaUtils.readJsonFromResource((Resource)entry.getValue())))).map(pair -> Pair.of((Object)((ResourceLocation)pair.getFirst()), (Object)SkyboxData.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)pair.getSecond())))).map(pair -> Pair.of((Object)((ResourceLocation)pair.getFirst()), (Object)((SkyboxData)((Pair)((DataResult)pair.getSecond()).getOrThrow(false, s -> {})).getFirst()))).toList();
    }

    protected void apply(List<Pair<ResourceLocation, SkyboxData>> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (object.isEmpty()) {
            return;
        }
        WeightLootTable<Pair> loot = new WeightLootTable<Pair>(object, o -> ((SkyboxData)o.getSecond()).weight);
        Pair data = loot.roll(RandomSource.m_216327_());
        ResourceLocation rl = (ResourceLocation)data.getFirst();
        TitleScreen.f_96716_ = new CubeMap(new ResourceLocation(rl.m_135827_(), rl.m_135815_().substring(0, rl.m_135815_().lastIndexOf(47) + 1) + ((SkyboxData)data.getSecond()).name));
    }

    @SubscribeEvent
    public static void onDataPackReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    public record SkyboxData(String name, int weight) {
        public static final Codec<SkyboxData> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("name").forGetter(SkyboxData::name), (App)Codec.INT.fieldOf("weight").forGetter(SkyboxData::weight)).apply((Applicative)ins, SkyboxData::new));
    }
}

