/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.teamabyssalofficial.client.special.model.ModelGeckoPlayerThirdPerson;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoRenderPlayer;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventInterface {
    INSTANCE;

    @OnlyIn(value=Dist.CLIENT)
    public GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;

    @SubscribeEvent
    public void addedToWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.geckoPlayer = new GeckoPlayer.GeckoPlayerThirdPerson(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        if (event.getEntity() instanceof Player) {
            if (!((Boolean)DawnOfTheFloodConfig.SERVER.hasPlayerCustomAnimations.get()).booleanValue()) {
                return;
            }
            Player player = (Player)event.getEntity();
            if (player == null) {
                return;
            }
            float delta = event.getPartialTick();
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer1 = this.geckoPlayer;
            if (geckoPlayer1 != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer1.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer1.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    event.setCanceled(true);
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayer)event.getEntity(), event.getEntity().m_146908_(), delta, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), this.geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer1;
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        if (event.side == LogicalSide.CLIENT && (geckoPlayer1 = this.geckoPlayer) != null) {
            geckoPlayer1.tick();
        }
    }
}

