/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.client.model.MarineFormModel;
import net.teamabyssalofficial.entity.custom.MarineFormEntity;
import net.teamabyssalofficial.guns.muzzle_flash.GunMuzzleFlashResources;
import net.teamabyssalofficial.guns.muzzle_flash.GunMuzzleVisuals;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class MarineFormRenderer
extends GeoEntityRenderer<MarineFormEntity> {
    MarineFormEntity golem;
    MultiBufferSource bufferIn;
    ResourceLocation text;

    public MarineFormRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new MarineFormModel());
        this.f_114477_ = 0.0f;
    }

    public void preRender(PoseStack poseStack, MarineFormEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem = animatable;
        this.bufferIn = bufferSource;
        this.text = this.m_5478_((Entity)animatable);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(MarineFormEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        switch (entity.getVariant()) {
            case 0: {
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                poseStack.m_85841_(0.97f, 0.97f, 0.97f);
                break;
            }
            case 2: {
                poseStack.m_85841_(1.03f, 1.03f, 1.03f);
            }
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack stack, MarineFormEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(stack, (Entity)animatable, bone, renderType, this.bufferIn, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (bone.getName().equals("item")) {
            stack.m_85836_();
            stack.m_85841_(1.75f, 1.75f, 1.75f);
            switch (animatable.getGunVariant()) {
                case 1: {
                    stack.m_85837_(-0.41, 0.35, 0.65);
                    break;
                }
                case 2: {
                    stack.m_85837_(-0.41, 0.37, 0.67);
                    break;
                }
                case 3: {
                    stack.m_85837_(-0.39, 0.25, 0.6);
                }
            }
            stack.m_252781_(Axis.f_252529_.m_252977_(-85.0f));
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            ItemStack itemstack = animatable.m_21205_();
            if (!itemstack.m_41619_()) {
                Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.f_118083_, stack, this.bufferIn, animatable.m_9236_(), 0);
            }
            if (animatable.isMuzzleFlashRendered()) {
                switch (animatable.getGunVariant()) {
                    case 1: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.45f, 16, -2.5f, -1.9f, -0.3f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                        break;
                    }
                    case 2: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.45f, 16, -2.6f, -1.8f, -0.5f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                        break;
                    }
                    case 3: {
                        GunMuzzleVisuals.renderMuzzleFlash(stack, bone, this.bufferIn, buffer, this.text, (LivingEntity)animatable, 0.5f, 16, -2.4f, -1.9f, -1.4f, GunMuzzleFlashResources.MUZZLE_FLASH_TEXTURE);
                    }
                }
            }
            stack.m_85849_();
            buffer = this.bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
        }
    }
}

