/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.animation;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.client.special.GeckoMath;
import net.teamabyssalofficial.client.special.animation.GeckoFactory;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class GeckoAnimationTemp<T extends GeoAnimatable> {
    public void crossbowAnimationLeftArm(LivingEntity animatable, CoreGeoBone left_arm) {
        assert (animatable != null);
        float initRotX = -0.97079635f;
        GeckoFactory.rotateForEach(left_arm, initRotX, left_arm.getRotY(), left_arm.getRotZ());
        float f = CrossbowItem.m_40939_((ItemStack)animatable.m_21211_());
        float f1 = GeckoMath.clamp((float)animatable.m_21252_(), 0.0f, f);
        float f2 = f1 / f;
        float rotX = -GeckoMath.lerp(f2, left_arm.getRotX(), -((float)GeckoFactory.fromPI()) / 2.0f);
        float rotY = -GeckoMath.lerp(f2, 0.4f, 0.85f);
        GeckoFactory.rotateForEach(left_arm, rotX, rotY, left_arm.getRotZ());
        GeckoFactory.endAnimation(left_arm);
    }

    public void crossbowAnimationRightArm(LivingEntity animatable, CoreGeoBone right_arm) {
        assert (animatable != null);
        float rotX = (float)GeckoFactory.fromBb(119.2822);
        float rotY = (float)GeckoFactory.fromBb(2.5759);
        float rotZ = (float)GeckoFactory.fromBb(-17.1658);
        GeckoFactory.rotateForEach(right_arm, rotX, rotY, rotZ);
        GeckoFactory.endAnimation(right_arm);
    }

    public void swimAnimation(LivingEntity animatable, CoreGeoBone rightArm, CoreGeoBone leftArm, AnimationState<T> animationState) {
        assert (animatable != null);
        float pPartialTick = animationState.getPartialTick();
        float pAgeInTicks = (float)animatable.f_19797_ + pPartialTick;
        float swimAmount = animatable.m_20998_(pPartialTick);
        if (swimAmount > 0.0f) {
            float rightArmYRot = rightArm.getRotY();
            float rightArmXRot = GeckoMath.rotlerpRad(swimAmount, rightArm.getRotX(), -2.5132742f) + swimAmount * 0.35f * GeckoMath.sin(0.1f * pAgeInTicks);
            float rightArmZRot = GeckoMath.rotlerpRad(swimAmount, rightArm.getRotZ(), -0.15f);
            float leftArmYRot = leftArm.getRotY();
            float leftArmXRot = GeckoMath.rotlerpRad(swimAmount, leftArm.getRotX(), -2.5132742f) - swimAmount * 0.35f * GeckoMath.sin(0.1f * pAgeInTicks);
            float leftArmZRot = GeckoMath.rotlerpRad(swimAmount, leftArm.getRotZ(), 0.15f);
            GeckoFactory.rotateForEach(rightArm, rightArmXRot, rightArmYRot, rightArmZRot);
            GeckoFactory.rotateForEach(leftArm, leftArmXRot, leftArmYRot, leftArmZRot);
            GeckoFactory.endAnimation(rightArm);
            GeckoFactory.endAnimation(leftArm);
        }
    }

    public void spellcastAnimation(LivingEntity animatable, CoreGeoBone rightArm, CoreGeoBone leftArm, AnimationState<T> animationState) {
        assert (animatable != null);
        float pPartialTick = animationState.getPartialTick();
        float pAgeInTicks = (float)animatable.f_19797_ + pPartialTick;
        float rightArmZ = 0.0f;
        float rightArmX = -1.0f;
        float rightArmY = rightArm.getPosY();
        float leftArmZ = 0.0f;
        float leftArmX = 1.0f;
        float leftArmY = leftArm.getPosY();
        GeckoFactory.positionForEach(rightArm, rightArmX, rightArmY, rightArmZ);
        GeckoFactory.positionForEach(leftArm, leftArmX, leftArmY, leftArmZ);
        float rightArmXRot = Mth.m_14089_((float)(pAgeInTicks * 0.6662f)) * 0.25f;
        float rightArmYRot = 0.0f;
        float rightArmZRot = 2.3561945f;
        float leftArmXRot = Mth.m_14089_((float)(pAgeInTicks * 0.6662f)) * 0.25f;
        float leftArmYRot = 0.0f;
        float leftArmZRot = -2.3561945f;
        GeckoFactory.rotateForEach(rightArm, rightArmXRot, rightArmYRot, rightArmZRot);
        GeckoFactory.rotateForEach(leftArm, leftArmXRot, leftArmYRot, leftArmZRot);
        GeckoFactory.endAnimation(rightArm);
        GeckoFactory.endAnimation(leftArm);
    }

    public void applyHeadRotation(LivingEntity animatable, CoreGeoBone head, AnimationState<T> animationState) {
        assert (animatable != null);
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        float headXRot = entityData.headPitch() * 0.01f;
        float headYRot = entityData.netHeadYaw() * 0.01f;
        float headZRot = head.getRotZ();
        GeckoFactory.rotateForEach(head, headXRot, headYRot, headZRot);
        GeckoFactory.endAnimation(head);
    }

    public void applyRadianHeadRotation(LivingEntity animatable, CoreGeoBone head) {
        assert (animatable != null);
        float DEG = 180.0f;
        float PI = (float)GeckoFactory.fromPI();
        float headXRot = head.getRotX();
        float headYRot = PI / DEG;
        float headZRot = head.getRotZ();
        GeckoFactory.rotateForEach(head, headXRot, headYRot, headZRot);
        GeckoFactory.endAnimation(head);
    }

    public void applyNullRPP(LivingEntity animatable, CoreGeoBone pAny) {
        assert (animatable != null);
        GeckoFactory.rotateMirror(pAny, 0.0f);
        GeckoFactory.positionMirror(pAny, 0.0f);
        GeckoFactory.pivotMirror(pAny, 0.0f);
        GeckoFactory.endAnimation(pAny);
    }

    public void resetAnimationTemp(LivingEntity animatable, CoreGeoBone coreGeoBone) {
        assert (animatable != null);
        GeckoFactory.endAnimation(coreGeoBone);
    }
}

