/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.player;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.teamabyssalofficial.client.ClientEventInterface;
import net.teamabyssalofficial.client.special.model.GeckoClassModel;
import net.teamabyssalofficial.client.special.model.ModelGeckoPlayerThirdPerson;
import net.teamabyssalofficial.client.special.player.GeckoPlayerController;
import net.teamabyssalofficial.client.special.player.GeckoRenderPlayer;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class GeckoPlayer
implements GeoEntity {
    protected GeoRenderer<GeckoPlayer> renderer;
    protected GeckoClassModel<GeckoPlayer> model;
    protected GeckoPlayerController<GeckoPlayer> controller;
    private int tickTimer = 0;
    private Player player;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String THIRD_PERSON_CONTROLLER_NAME = "thirdPersonAnimation";

    public GeckoPlayer(Player player) {
        this.player = player;
        this.setup(player);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller = new GeckoPlayerController<GeckoPlayer>(this, this.getControllerName(), 0, this::predicate, 0.0);
        controllers.add(new AnimationController[]{this.controller});
    }

    public static GeckoPlayerController<GeckoPlayer> getAnimationController(Player player, Perspective perspective) {
        GeckoPlayerThirdPerson geckoPlayer = ClientEventInterface.INSTANCE.geckoPlayer;
        if (geckoPlayer != null) {
            return geckoPlayer.controller;
        }
        return null;
    }

    public GeckoPlayerController<GeckoPlayer> getController() {
        return this.controller;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void tick() {
        ++this.tickTimer;
    }

    public double getTick(Object entity) {
        return ((GeckoPlayer)entity).tickTimer;
    }

    public <E extends GeoEntity> PlayState predicate(AnimationState<E> e) {
        e.getController().transitionLength(0);
        Player player = this.getPlayer();
        if (player == null) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public GeoRenderer<GeckoPlayer> getPlayerRenderer() {
        return this.renderer;
    }

    public GeckoClassModel<GeckoPlayer> getModel() {
        return this.model;
    }

    public abstract String getControllerName();

    public abstract Perspective getPerspective();

    public abstract void setup(Player var1);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class GeckoPlayerThirdPerson
    extends GeckoPlayer {
        public static GeckoRenderPlayer GECKO_RENDERER_THIRD_PERSON_NORMAL;
        public static ModelGeckoPlayerThirdPerson GECKO_MODEL_THIRD_PERSON_NORMAL;
        public static GeckoRenderPlayer GECKO_RENDERER_THIRD_PERSON_SLIM;
        public static ModelGeckoPlayerThirdPerson GECKO_MODEL_THIRD_PERSON_SLIM;
        protected GeoRenderer<GeckoPlayer> rendererSlim;
        protected GeckoClassModel<GeckoPlayer> modelSlim;

        public GeckoPlayerThirdPerson(Player player) {
            super(player);
        }

        @Override
        public String getControllerName() {
            return GeckoPlayer.THIRD_PERSON_CONTROLLER_NAME;
        }

        @Override
        public Perspective getPerspective() {
            return Perspective.THIRD_PERSON;
        }

        @Override
        public void setup(Player player) {
            this.model = GECKO_MODEL_THIRD_PERSON_NORMAL;
            this.renderer = GECKO_RENDERER_THIRD_PERSON_NORMAL;
            this.modelSlim = GECKO_MODEL_THIRD_PERSON_SLIM;
            this.rendererSlim = GECKO_RENDERER_THIRD_PERSON_SLIM;
            this.getAnimatableInstanceCache().getManagerForId(this.renderer.getInstanceId((GeoAnimatable)this));
            this.getController().setLastModel((CoreGeoModel<GeckoPlayer>)this.model);
        }

        public boolean isPlayerSlim() {
            return ((AbstractClientPlayer)this.getPlayer()).m_108564_().equals("slim");
        }

        @Override
        public GeckoClassModel<GeckoPlayer> getModel() {
            return this.isPlayerSlim() ? this.modelSlim : this.model;
        }

        @Override
        public GeoRenderer<GeckoPlayer> getPlayerRenderer() {
            return this.isPlayerSlim() ? this.rendererSlim : this.renderer;
        }

        public static void initRenderer() {
            GECKO_MODEL_THIRD_PERSON_NORMAL = new ModelGeckoPlayerThirdPerson();
            GECKO_MODEL_THIRD_PERSON_SLIM = new ModelGeckoPlayerThirdPerson();
            GECKO_MODEL_THIRD_PERSON_SLIM.setUseSmallArms(true);
            Minecraft minecraft = Minecraft.m_91087_();
            EntityRenderDispatcher dispatcher = minecraft.m_91290_();
            ItemRenderer itemRenderer = minecraft.m_91291_();
            ResourceManager resourceManager = minecraft.m_91098_();
            EntityModelSet entityModelSet = minecraft.m_167973_();
            Font font = minecraft.f_91062_;
            EntityRendererProvider.Context context = new EntityRendererProvider.Context(dispatcher, itemRenderer, minecraft.m_91289_(), dispatcher.m_234586_(), resourceManager, entityModelSet, font);
            GeckoRenderPlayer geckoRenderer = new GeckoRenderPlayer(context, false, GECKO_MODEL_THIRD_PERSON_NORMAL);
            if (!geckoRenderer.getModelsToLoad().containsKey(GeckoPlayerThirdPerson.class)) {
                geckoRenderer.getModelsToLoad().put(GeckoPlayerThirdPerson.class, geckoRenderer);
            }
            GECKO_RENDERER_THIRD_PERSON_NORMAL = geckoRenderer;
            GeckoRenderPlayer geckoRendererSlim = new GeckoRenderPlayer(context, true, GECKO_MODEL_THIRD_PERSON_SLIM);
            if (!geckoRendererSlim.getModelsToLoad().containsKey(GeckoPlayerThirdPerson.class)) {
                geckoRendererSlim.getModelsToLoad().put(GeckoPlayerThirdPerson.class, geckoRendererSlim);
            }
            GECKO_RENDERER_THIRD_PERSON_SLIM = geckoRendererSlim;
        }
    }

    public static enum Perspective {
        THIRD_PERSON;

    }
}

