/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.player;

import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.TestOnly;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;

public class GeckoPlayerController<T extends GeoAnimatable>
extends AnimationController<T> {
    private double timingOffset;

    public GeckoPlayerController(T animatable, String name, int transitionLength, AnimationController.AnimationStateHandler<T> animationHandler, double timingOffset) {
        super(animatable, name, transitionLength, animationHandler);
        this.timingOffset = timingOffset;
    }

    public void playAnimation(T animatable, RawAnimation animation) {
        this.forceAnimationReset();
        this.setAnimation(animation);
        this.currentAnimation = (AnimationProcessor.QueuedAnimation)this.animationQueue.poll();
        this.isJustStarting = true;
        this.adjustTick(animatable.getTick(animatable) + (double)Minecraft.m_91087_().getPartialTick());
        this.transitionLength = 0.0;
    }

    protected double adjustTick(double tick) {
        if (this.shouldResetTick) {
            if (this.getAnimationState() == AnimationController.State.TRANSITIONING) {
                this.tickOffset = tick;
            } else if (this.getAnimationState() != AnimationController.State.STOPPED) {
                this.tickOffset += this.transitionLength;
            }
            this.shouldResetTick = false;
        }
        double adjustedTick = (Double)this.animationSpeedModifier.apply(this.animatable) * Math.max(tick - this.tickOffset, 0.0) + this.timingOffset;
        if (this.currentAnimation != null && this.currentAnimation.loopType() == Animation.LoopType.LOOP) {
            adjustedTick %= this.currentAnimation.animation().length();
        }
        if (adjustedTick == this.timingOffset) {
            this.isJustStarting = true;
        }
        return adjustedTick;
    }

    public void setLastModel(CoreGeoModel<T> coreGeoModel) {
        this.lastModel = coreGeoModel;
    }

    @TestOnly
    public <E extends GeoEntity> void checkAndReloadAnims() {
        String currentAnimationName;
        Animation animation;
        if (this.lastModel != null && this.getCurrentAnimation() != null && this.getCurrentAnimation().animation() != null && !(animation = this.lastModel.getAnimation(this.animatable, currentAnimationName = this.getCurrentAnimation().animation().name())).equals((Object)this.getCurrentAnimation().animation())) {
            this.forceAnimationReset();
            this.currentAnimation = (AnimationProcessor.QueuedAnimation)this.animationQueue.poll();
            this.isJustStarting = true;
            this.adjustTick(this.animatable.getTick((Object)this.animatable) + (double)Minecraft.m_91087_().getPartialTick());
            this.transitionLength = 0.0;
        }
    }
}

