/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.weapon.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.client.weapon.model.EnergySwordModel;
import net.teamabyssalofficial.item.EnergySwordItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class EnergySwordRenderer
extends GeoItemRenderer<EnergySwordItem>
implements GeoRenderer<EnergySwordItem> {
    private static final String APPENDIX = "_glowmask";
    private static final ResourceLocation GLOWING_TEXTURE = new ResourceLocation("dotf", "textures/weapon/energy_sword_glowmask.png");
    private MultiBufferSource bufferIn;
    private ItemDisplayContext renderType;
    EnergySwordItem golem;
    ResourceLocation text;

    private ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = GeoAbstractTexture.appendToPath((ResourceLocation)baseResource, (String)APPENDIX);
        this.generateTexture(path, textureManager -> textureManager.m_118495_(path, (AbstractTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    protected void generateTexture(ResourceLocation texturePath, Consumer<TextureManager> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (!(textureManager.m_174786_(texturePath, (AbstractTexture)MissingTextureAtlasSprite.m_118080_()) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public EnergySwordRenderer() {
        super((GeoModel)new EnergySwordModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<EnergySwordItem>((GeoRenderer)this){

            protected RenderType getRenderType(EnergySwordItem animatable) {
                return RenderType.m_110488_((ResourceLocation)EnergySwordRenderer.this.getEmissiveResource(GLOWING_TEXTURE));
            }
        });
    }

    protected void renderInGui(ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void preRender(PoseStack poseStack, EnergySwordItem animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem = animatable;
        this.bufferIn = bufferSource;
        this.text = this.getTextureLocation(animatable);
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.bufferIn = bufferSource;
        this.renderType = transformType;
        super.m_108829_(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void renderRecursively(PoseStack poseStack, EnergySwordItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, this.bufferIn, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        Minecraft client = Minecraft.m_91087_();
        boolean renderArms = false;
        poseStack.m_85836_();
        if (this.renderType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            switch (bone.getName()) {
                case "leftArm": 
                case "rightArm": {
                    bone.setHidden(true);
                    bone.setChildrenHidden(false);
                    renderArms = true;
                }
            }
            if (renderArms) {
                assert (client.f_91074_ != null);
                PlayerRenderer playerEntityRenderer = (PlayerRenderer)client.m_91290_().m_114382_((Entity)client.f_91074_);
                PlayerModel playerEntityModel = (PlayerModel)playerEntityRenderer.m_7200_();
                RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                ResourceLocation playerSkin = client.f_91074_.m_108560_();
                VertexConsumer arm = this.bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
                VertexConsumer sleeve = this.bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
                if (bone.getName().equals("leftArm")) {
                    poseStack.m_85841_(2.37f, 1.33f, 1.67f);
                    poseStack.m_85837_(-0.1, -0.43625, 0.3625);
                    playerEntityModel.f_102812_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_102812_.f_104203_ = 179.2f;
                    playerEntityModel.f_102812_.f_104204_ = 0.0f;
                    playerEntityModel.f_102812_.f_104205_ = 0.0f;
                    playerEntityModel.f_102812_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    playerEntityModel.f_103374_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_103374_.f_104203_ = 0.0f;
                    playerEntityModel.f_103374_.f_104204_ = 0.0f;
                    playerEntityModel.f_103374_.f_104205_ = 0.0f;
                    playerEntityModel.f_103374_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (bone.getName().equals("rightArm")) {
                    poseStack.m_85841_(0.97f, 1.33f, 0.97f);
                    poseStack.m_85837_(0.1, -0.15, -0.015);
                    playerEntityModel.f_102811_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_102811_.f_104203_ = 179.1f;
                    playerEntityModel.f_102811_.f_104204_ = 0.0f;
                    playerEntityModel.f_102811_.f_104205_ = 0.0f;
                    playerEntityModel.f_102811_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    playerEntityModel.f_103375_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_103375_.f_104203_ = 0.0f;
                    playerEntityModel.f_103375_.f_104204_ = 0.0f;
                    playerEntityModel.f_103375_.f_104205_ = 0.0f;
                    playerEntityModel.f_103375_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        } else {
            switch (bone.getName()) {
                case "leftArm": 
                case "rightArm": {
                    bone.setHidden(true);
                    bone.setChildrenHidden(false);
                }
            }
        }
        poseStack.m_85849_();
        buffer = this.bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
    }
}

