/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.teamabyssalofficial.client.ClientEventInterface;
import net.teamabyssalofficial.client.ClientLayerRegistry;
import net.teamabyssalofficial.client.ClientShaderInstances;
import net.teamabyssalofficial.client.ClientShaders;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoPlayerAnimated;
import net.teamabyssalofficial.dotf.CommonProxy;
import net.teamabyssalofficial.dotf.DawnOfTheFlood;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static final ResourceLocation ENERGY_SHIELD_SHADER = new ResourceLocation("dotf", "shaders/post/energy_shield.json");
    public static final ResourceLocation POSITION_COLOR_TEX = new ResourceLocation("dotf", "shaders/post/position_color_tex.json");
    public static final ResourceLocation POSITION_COLOR_TEX_LIGHTMAP = new ResourceLocation("dotf", "shaders/post/position_color_tex_lightmap.json");
    public static final ResourceLocation POSITION_TEX_COLOR = new ResourceLocation("dotf", "shaders/post/position_tex_color.json");
    public static final Minecraft minecraft = Minecraft.m_91087_();

    @Override
    public void init(IEventBus bus) {
        bus.addListener(ClientLayerRegistry::onAddLayers);
        bus.addListener(this::registerShaders);
        MinecraftForge.EVENT_BUS.register((Object)ClientEventInterface.INSTANCE);
        ClientShaders.registerEffect(ENERGY_SHIELD_SHADER);
        ClientShaders.registerEffect(POSITION_COLOR_TEX);
        ClientShaders.registerEffect(POSITION_COLOR_TEX_LIGHTMAP);
        ClientShaders.registerEffect(POSITION_TEX_COLOR);
        if (ClientProxy.minecraft.f_91074_ != null) {
            GeckoPlayerAnimated.stopAnimation((Player)ClientProxy.minecraft.f_91074_, GeckoPlayer.Perspective.THIRD_PERSON);
        }
    }

    private void registerShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "rendertype_energy_shield"), DefaultVertexFormat.f_85818_), ClientShaderInstances::setRenderTypeEnergyShieldShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_color_tex"), DefaultVertexFormat.f_85818_), ClientShaderInstances::setRenderTypePositionColorTexShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_color_tex_lightmap"), DefaultVertexFormat.f_85820_), ClientShaderInstances::setRenderTypePositionColorTexLightMapShader);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("dotf", "position_tex_color"), DefaultVertexFormat.f_85819_), ClientShaderInstances::setRenderTypePositionTexColorShader);
            DawnOfTheFlood.LOGGER.info("Registered internal shaders");
        }
        catch (IOException exception) {
            DawnOfTheFlood.LOGGER.error("Could not register internal shaders");
            exception.printStackTrace();
        }
    }
}

