/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EndermanFormEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(EndermanFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(0.96f, 0.96f, 0.96f);
    public final double noSpeed = 0.0;
    public final float randFactor = 2.5f;

    public EndermanFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        this.m_274367_(0.75f);
        this.f_21364_ = 10;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("aggroTicks", this.getAggroTicks());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setAggroTicks(nbt.m_128451_("aggroTicks"));
    }

    public boolean hasOvercomeWaterWeakness() {
        ServerLevel world;
        Level level = this.m_9236_();
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() >= 5 || (Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_sensible_to_water.get() == false;
    }

    public boolean m_6126_() {
        return !this.hasOvercomeWaterWeakness();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.enderman_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.enderman_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.35).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22284_, 5.0);
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !EndermanFormEntity.this.hasOvercomeWaterWeakness();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkEndermanFormRules(EntityType<? extends EndermanFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && EndermanFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && EndermanFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 2;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (!event.isMoving() && !this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_()) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.walk"));
            }
            if (event.isMoving() && this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("enderman.form.target"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public float getVolume() {
        return 1.85f;
    }

    public float getPitch(RandomSource random) {
        return 0.75f;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_HURT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_((SoundEvent)SoundRegistry.ENTITY_FORM_STEP.get(), this.getVolume() / 2.0f, this.getPitch(this.f_19796_) + 0.25f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.FLOOD_ENDERMAN_IDLE.get();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        if (pSource.m_7639_() != null && Math.random() <= 0.9 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
            this.shortTp();
        }
        if (this.m_6673_(pSource)) {
            return false;
        }
        boolean flag = pSource.m_7640_() instanceof ThrownPotion;
        if (pSource.m_269533_(DamageTypeTags.f_268524_) && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
            this.shortTp();
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268524_) && !flag) {
            boolean flag2 = super.m_6469_(pSource, pAmount);
            if (!this.m_9236_().m_5776_() && !(pSource.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(8) != 0 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
                this.teleport();
            }
            return flag2;
        }
        boolean flag1 = flag && this.hurtWithCleanWater(pSource, (ThrownPotion)pSource.m_7640_(), pAmount);
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport() || !((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) continue;
            return true;
        }
        return flag1;
    }

    public int getSubtractionPoints() {
        return 150;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.75), this.m_20187_() + 0.25, this.m_20262_(0.75), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        super.m_8107_();
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 2) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5448_() != null && this.m_217043_().m_188503_(17) == 0 && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_teleportation.get()).booleanValue()) {
            this.teleportTowards((Entity)this.m_5448_());
            this.m_6710_(this.m_5448_());
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
            if (((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_reinforcements.get()).booleanValue() && Math.random() <= (Double)DawnOfTheFloodConfig.SERVER.enderman_form_reinforcement_rate.get()) {
                this.teleportAlly();
                this.m_6710_(this.m_5448_());
            }
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.carrier_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.enderman_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(240) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 1.5) {
            this.m_5634_(1.5f);
        }
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    protected boolean teleportToTarget() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_5448_() != null) {
            double d0 = this.m_5448_().m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 6.0;
            double d1 = this.m_5448_().m_20186_() + (double)(this.f_19796_.m_188503_(24) - 12);
            double d2 = this.m_5448_().m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 6.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    public void teleportAlly() {
        AABB boundingBox = this.m_20191_().m_82400_(100.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        Random random = new Random();
        if (!entities.isEmpty()) {
            for (int i = 0; i < 1; ++i) {
                LivingEntity livingEntity;
                int randomIndex = random.nextInt(entities.size());
                Entity entity = (Entity)entities.get(randomIndex);
                if (!(entity instanceof LivingEntity) || !((livingEntity = (LivingEntity)entity) instanceof BaseForm) || livingEntity instanceof SangheiliFormEntity) continue;
                double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double d1 = this.m_20186_() + Mth.m_14005_((double)0.0, (double)0.5);
                double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
                livingEntity.m_6021_(d0, d1, d2);
                if (this.m_20067_()) continue;
                livingEntity.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                livingEntity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }

    protected boolean shortTp() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(60) - 12);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 24.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity pTarget) {
        Vec3 vec3 = new Vec3(this.m_20185_() - pTarget.m_20185_(), this.m_20227_(0.5) - pTarget.m_20188_(), this.m_20189_() - pTarget.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    private boolean hurtWithCleanWater(DamageSource pSource, ThrownPotion pPotion, float pAmount) {
        ItemStack itemstack = pPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty() && !this.hasOvercomeWaterWeakness();
        return flag ? super.m_6469_(pSource, pAmount) : false;
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.enderman_form_aggro_ticks.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.stackScaler.randomizeScale(this.f_19796_, this.randFactor);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }
}

