/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.CrossbowMultishotGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.LeapAttackGoal;
import net.teamabyssalofficial.entity.ai.OpenFenceGateGoal;
import net.teamabyssalofficial.entity.ai.ParkourGoal;
import net.teamabyssalofficial.entity.ai.TargetCropsGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.DeadPlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.impl.ReentrantBoolean;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.DateUtils;
import net.teamabyssalofficial.util.MathhaxUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.RangedBuff;
import net.teamabyssalofficial.util.SoundPacket;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlayerFormEntity
extends BaseForm
implements GeoEntity,
SoundUtils,
RangedAttackMob,
RangedBuff,
CrossbowAttackMob {
    private static final EntityDataAccessor<Integer> SPAWN_TIMER = SynchedEntityData.m_135353_(PlayerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROAR_TIMER = SynchedEntityData.m_135353_(PlayerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(PlayerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public static final byte ATTACK = 1;
    public static final byte FIST_ATTACK = 2;
    public static final int ROAR_TIME = 50;
    private Potion potion = null;
    private ReentrantBoolean spyglassLock = new ReentrantBoolean(false);
    private ReentrantBoolean pearlLock = new ReentrantBoolean(false);

    public PlayerFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.isCombat = false;
        this.isSangheili = false;
        this.aggroTicks = 0L;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)30);
        this.f_19804_.m_135372_(ROAR_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.base_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.base_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.15).m_22268_(Attributes.f_22283_, 1.1).m_22268_(Attributes.f_22278_, 0.35).m_22268_(Attributes.f_22284_, 5.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CrossbowAttackStrafeGoal<PlayerFormEntity>(this, 0.8, 12.0f){

            @Override
            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && !PlayerFormEntity.this.isImmobile && PlayerFormEntity.this.noWater() && PlayerFormEntity.this.m_5448_() != null && (double)PlayerFormEntity.this.m_20270_((Entity)PlayerFormEntity.this.m_5448_()) > 4.5 && (level = PlayerFormEntity.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new UseItemGoal<PlayerFormEntity>(this, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43587_), SoundEvents.f_12551_, p_35882_ -> {
            ServerLevel world;
            Level patt7210$temp;
            return this.m_21223_() < this.m_21233_() / 2.0f && this.noWater() && (Boolean)DawnOfTheFloodConfig.SERVER.use_potions.get() != false && (patt7210$temp = this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)patt7210$temp).getWave() > 2 && !this.isImmobile;
        }){});
        this.f_21345_.m_25352_(1, (Goal)new UseItemGoal((Mob)this, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43611_), SoundEvents.f_12551_, p_35882_ -> {
            ServerLevel world;
            Level patt7792$temp;
            return this.m_6060_() && this.m_21225_() != null && this.noWater() && this.m_21225_() == this.m_269291_().m_269387_() && !this.m_21023_(MobEffects.f_19607_) && (Boolean)DawnOfTheFloodConfig.SERVER.use_potions.get() != false && (patt7792$temp = this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)patt7792$temp).getWave() > 2 && !this.isImmobile;
        }));
        this.f_21345_.m_25352_(4, (Goal)new BuffAlliesGoal((RangedBuff)this, BaseForm.class, 0.95, (int)((Integer)DawnOfTheFloodConfig.SERVER.buff_potion_meter.get()), (int)((Integer)DawnOfTheFloodConfig.SERVER.buff_potion_meter.get()), 3.0f, livingEntity -> !(livingEntity instanceof PlayerFormEntity)){

            @Override
            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && PlayerFormEntity.this.noWater() && (Boolean)DawnOfTheFloodConfig.SERVER.use_potions.get() != false && this.mob.m_21188_() == null && (level = this.mob.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2 && !PlayerFormEntity.this.isImmobile;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.6f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new PlayerFormMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PlayerFormFistAttackGoal(this));
        this.f_21345_.m_25352_(4, new BaseForm.LongDistancePatrolGoal<PlayerFormEntity>(this, 1.0, 0.9));
        this.f_21345_.m_25352_(5, (Goal)new TargetCropsGoal((PathfinderMob)this, 1.3, 32));
        this.f_21345_.m_25352_(2, new CrossbowMultishotGoal<PlayerFormEntity>(this, 1.0, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new LeapAttackGoal((Mob)this, 0.5f){

            @Override
            public void m_8037_() {
                PlayerFormEntity.this.setLeaping(true);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !PlayerFormEntity.this.isImmobile;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OpenFenceGateGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new ParkourGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !PlayerFormEntity.this.isImmobile;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && !PlayerFormEntity.this.isImmobile;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }

            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && (level = PlayerFormEntity.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2;
            }
        });
    }

    public boolean noWater() {
        return !this.m_5842_();
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getRoarTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("player.form.roar"));
            }
            if (this.getSpawnTimer() > 0 && this.isTransformed()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("player.form.transform"));
            }
            if (this.isLeaping() && !this.m_20096_() && this.attackID == 0 && !this.isClimbing()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("player.form.leap"));
            }
            if (this.m_20069_() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("player.form.leap"));
            }
            if (this.isClimbing() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("player.form.climb"));
            }
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("player.form.death"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("player.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("player.form.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("player.form.target"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("player.form.attack"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("player.form.fist.attack"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public int getRoarTimer() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TIMER);
    }

    public void setRoarTimer(int ticks) {
        this.f_19804_.m_135381_(ROAR_TIMER, (Object)ticks);
    }

    @Override
    protected void m_8024_() {
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getRoarTimer() > 0) {
            this.setRoarTimer(this.getRoarTimer() - 1);
        }
        super.m_8024_();
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon == Items.f_42717_;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pChargingCrossbow) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pChargingCrossbow);
    }

    public void m_5811_(LivingEntity entity, ItemStack itemStack, Projectile projectile, float f) {
        if (projectile instanceof Arrow) {
            ((Arrow)projectile).m_36870_(new MobEffectInstance(MobEffects.f_19614_, 100));
        }
        this.m_32322_((LivingEntity)this, entity, projectile, f, 1.5707964f);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        this.m_6674_(InteractionHand.MAIN_HAND);
        this.m_6674_(InteractionHand.OFF_HAND);
        this.f_20885_ = 30.0f;
        this.m_32336_((LivingEntity)this, 1.85f);
    }

    public boolean m_20329_(Entity entity) {
        ServerLevel world;
        Level level;
        LivingEntity target = this.m_5448_();
        if (target != null && !this.m_21205_().equals(new ItemStack((ItemLike)Items.f_42717_)) && (double)this.m_20270_((Entity)target) > 4.5 && (level = this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        }
        return super.m_20329_(entity);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor groupData, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = groupData.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        return super.m_6518_(groupData, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public int getItemChance() {
        return this.getArmorChance() / 3;
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        String[] string;
        ItemStack mainHandG = ItemStack.f_41583_;
        ItemStack helmetG = ItemStack.f_41583_;
        ItemStack chestG = ItemStack.f_41583_;
        ItemStack legsG = ItemStack.f_41583_;
        ItemStack bootG = ItemStack.f_41583_;
        for (String str : (List)DawnOfTheFloodConfig.DATAGEN.player_form_main_hand.get()) {
            string = str.split("\\|");
            ItemStack mainHand = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string[0]))));
            if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / (float)this.getItemChance()))) continue;
            mainHandG = mainHand;
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.player_form_armor.get()).booleanValue()) {
            for (String str : (List)DawnOfTheFloodConfig.DATAGEN.base_form_helmet.get()) {
                string = str.split("\\|");
                ItemStack helmet = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string[0]))));
                if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / (float)this.getArmorChance()))) continue;
                helmetG = helmet;
            }
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_canHaveChestplate.get()).booleanValue()) {
                for (String str : (List)DawnOfTheFloodConfig.DATAGEN.base_form_chestplate.get()) {
                    string = str.split("\\|");
                    ItemStack chest = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string[0]))));
                    if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / (float)this.getArmorChance()))) continue;
                    chestG = chest;
                }
            }
            for (String str : (List)DawnOfTheFloodConfig.DATAGEN.base_form_legs.get()) {
                string = str.split("\\|");
                ItemStack legs = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string[0]))));
                if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / (float)this.getArmorChance()))) continue;
                legsG = legs;
            }
            for (String str : (List)DawnOfTheFloodConfig.DATAGEN.base_form_feet.get()) {
                string = str.split("\\|");
                ItemStack boot = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string[0]))));
                if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string[1]) / (float)this.getArmorChance()))) continue;
                bootG = boot;
            }
            if (this.m_6844_(EquipmentSlot.HEAD).m_41619_() && DateUtils.isHalloween() && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.15f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
            this.m_8061_(EquipmentSlot.MAINHAND, mainHandG);
            this.m_8061_(EquipmentSlot.HEAD, helmetG);
            this.m_8061_(EquipmentSlot.CHEST, chestG);
            this.m_8061_(EquipmentSlot.LEGS, legsG);
            this.m_8061_(EquipmentSlot.FEET, bootG);
        }
        List name = (List)DawnOfTheFloodConfig.DATAGEN.name.get();
        Random rand = new Random();
        if (this.m_7770_() == null) {
            for (int i = 0; i < 1; ++i) {
                int randomIndex = rand.nextInt(name.size());
                Component component = Component.m_130674_((String)((String)name.get(randomIndex)));
                this.m_6593_(component);
            }
        }
    }

    @Override
    public void performRangedBuff(LivingEntity entity, float f) {
        Vec3 vec3 = entity.m_20184_();
        double d0 = entity.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = entity.m_20188_() - (double)1.1f - this.m_20186_();
        double d2 = entity.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.potion = entity.m_21223_() < entity.m_21233_() && !entity.m_6060_() ? Potions.f_43587_ : (entity.m_6060_() && !entity.m_21023_(MobEffects.f_19607_) ? Potions.f_43610_ : (d3 <= 4.0 && this.getBuffPotion() != null ? this.getBuffPotion() : Potions.f_43623_));
        ThrownPotion thrownpotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
        thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)this.potion));
        thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
        thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        assert (thrownpotion != null);
        this.m_9236_().m_7967_((Entity)thrownpotion);
    }

    private Potion getBuffPotion() {
        Random rand = new Random();
        List ev = (List)DawnOfTheFloodConfig.SERVER.buffing_potions.get();
        int randomIndex = rand.nextInt(ev.size());
        ResourceLocation randomElement1 = new ResourceLocation((String)ev.get(randomIndex));
        return (Potion)ForgeRegistries.POTIONS.getValue(randomElement1);
    }

    public float getVolume() {
        return 1.25f;
    }

    public float getPitch(RandomSource random) {
        return 0.95f;
    }

    public void m_8107_() {
        ServerLevel world;
        Level level;
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (this.m_6084_() && attackTarget != null && this.m_142582_((Entity)attackTarget) && this.m_20270_((Entity)attackTarget) <= 10.0f && ((Boolean)DawnOfTheFloodConfig.SERVER.player_form_breaks_blocks.get()).booleanValue() && (level = this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > 2) {
            SoundPacket soundPacket = new SoundPacket((SoundEvent)SoundRegistry.ENTITY_FORM_IDLE.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
            BlockUtils.destroyBlocks(this.m_9236_(), (LivingEntity)this, 0.25, this.getDestroySpeed(), 80, soundPacket);
        }
    }

    public int getDestroySpeed() {
        return 1;
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.m_21205_().m_41720_() == Items.f_42409_ && Math.random() <= (double)0.2f) {
            pEntity.m_20254_(5);
        }
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 2;
        }
        return true;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("spawnTimer", this.getSpawnTimer());
        nbt.m_128405_("roarTimer", this.getRoarTimer());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSpawnTimer(nbt.m_128451_("spawnTimer"));
        this.setRoarTimer(nbt.m_128451_("roarTimer"));
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_(1.85);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_((Player)null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.35f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)0.95f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target == null && this.m_6084_() && this.potion != null && this.m_21205_() != PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)this.potion)) {
            this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)this.potion));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.getSpawnTimer() > 0 || this.getRoarTimer() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getSpawnTimer() == 0 && this.getRoarTimer() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.getSpawnTimer() == 28 && this.isTransformed()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_));
        }
        if (this.getSpawnTimer() == 7 && this.getRoarTimer() == 0 && this.isTransformed()) {
            this.setRoarTimer(50);
        }
        if (this.getRoarTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getRoarTimer() == 46) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_ROAR.get(), this.m_5720_(), this.getVolume() + 0.65f, this.getPitch(this.f_19796_));
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 16.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.13f, (int)36, (int)9);
            }
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        Item spyglass = Items.f_151059_;
        Item pearl = Items.f_42584_;
        if (this.m_21205_().m_41720_() == spyglass) {
            if (!this.spyglassLock.isLocked()) {
                double f = 32.0 + Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22135_();
                Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22100_(f);
                this.spyglassLock.lock();
            }
        } else if (this.m_21205_().m_41720_() == pearl && !this.pearlLock.isLocked() && this.m_5448_() != null && MathhaxUtils.betweenInclusive(this.m_20270_((Entity)this.m_5448_()), 6.0f, 12.0f) && Math.random() <= 0.25) {
            double addX = this.f_19796_.m_216339_(2, 6);
            double addY = 0.0;
            double addZ = this.f_19796_.m_216339_(2, 6);
            this.m_6021_(this.m_20185_() + addX, this.m_20186_() + addY, this.m_20189_() + addZ);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.pearlLock.lock();
        }
    }

    @Override
    public void m_6667_(DamageSource source) {
        if (Math.random() <= (double)0.15f && !this.isReanimated() && ((Boolean)DawnOfTheFloodConfig.SERVER.corpse_spawn.get()).booleanValue()) {
            this.dropBody((Entity)this);
            this.vanish();
            this.setIsReanimated(true);
            this.willDiscard(true);
        } else {
            this.willDiscard(false);
        }
        super.m_6667_(source);
    }

    protected void m_6153_() {
        super.m_6153_();
        ++this.f_20919_;
        if (this.f_20919_ == 1 && this.shouldDiscard()) {
            this.m_146870_();
        } else if (this.f_20919_ == 30 && !this.shouldDiscard()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void dropBody(Entity entity) {
        DeadPlayerFormEntity deadPlayerFormEntity = new DeadPlayerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.DEAD_PLAYER_FORM.get()), entity.m_9236_());
        deadPlayerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        deadPlayerFormEntity.setVariant(this.getVariant());
        deadPlayerFormEntity.m_8061_(EquipmentSlot.MAINHAND, this.m_21205_());
        deadPlayerFormEntity.m_146926_(entity.m_146909_());
        deadPlayerFormEntity.m_146922_(entity.m_146908_());
        deadPlayerFormEntity.m_5618_(this.f_20883_);
        deadPlayerFormEntity.m_5616_(this.f_20885_);
        deadPlayerFormEntity.m_21563_().m_24964_(entity.m_20154_());
        deadPlayerFormEntity.m_6593_(entity.m_7770_());
        deadPlayerFormEntity.m_8061_(EquipmentSlot.HEAD, this.m_6844_(EquipmentSlot.HEAD));
        deadPlayerFormEntity.m_8061_(EquipmentSlot.CHEST, this.m_6844_(EquipmentSlot.CHEST));
        deadPlayerFormEntity.m_8061_(EquipmentSlot.LEGS, this.m_6844_(EquipmentSlot.LEGS));
        deadPlayerFormEntity.m_8061_(EquipmentSlot.FEET, this.m_6844_(EquipmentSlot.FEET));
        entity.m_9236_().m_7967_((Entity)deadPlayerFormEntity);
    }

    private void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(5), 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_REMOVED.get(), SoundSource.HOSTILE, 1.05f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
    }

    class PlayerFormMeleeAttackGoal
    extends Goal {
        private final PlayerFormEntity playerFormEntity;
        private LivingEntity attackTarget;

        public PlayerFormMeleeAttackGoal(PlayerFormEntity playerFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.playerFormEntity = playerFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.playerFormEntity.m_5448_();
            return this.attackTarget != null && this.playerFormEntity.attackID == 1 && !PlayerFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.playerFormEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.playerFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.playerFormEntity.attacktick < 27;
        }

        public void m_8037_() {
            if (PlayerFormEntity.this.attacktick == 8) {
                float f1 = (float)Math.cos(Math.toRadians(PlayerFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(PlayerFormEntity.this.m_146908_() + 90.0f));
                PlayerFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (PlayerFormEntity.this.attacktick == 13) {
                float volume = this.playerFormEntity.getVolume() + 0.15f;
                float pitch = this.playerFormEntity.getPitch(this.playerFormEntity.m_217043_()) - 0.5f;
                this.playerFormEntity.m_9236_().m_5594_((Player)null, this.playerFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (PlayerFormEntity.this.attacktick == 21) {
                PlayerFormEntity.this.destroySwingable();
                PlayerFormEntity.this.sweep((Entity)this.attackTarget);
                if (PlayerFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f) {
                    this.attackTarget.m_6469_(PlayerFormEntity.this.getDamage(), (float)PlayerFormEntity.this.m_21133_(Attributes.f_22281_));
                }
            }
            PlayerFormEntity.this.m_21573_().m_26569_();
        }
    }

    class PlayerFormFistAttackGoal
    extends Goal {
        private final PlayerFormEntity playerFormEntity;
        private LivingEntity attackTarget;

        public PlayerFormFistAttackGoal(PlayerFormEntity playerFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.playerFormEntity = playerFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.playerFormEntity.m_5448_();
            return this.attackTarget != null && this.playerFormEntity.attackID == 2 && !PlayerFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.playerFormEntity.setAttackID(2);
        }

        public void m_8041_() {
            this.playerFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.playerFormEntity.attacktick < 30;
        }

        public void m_8037_() {
            if (PlayerFormEntity.this.attacktick == 8) {
                PlayerFormEntity.this.f_20883_ = PlayerFormEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(PlayerFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(PlayerFormEntity.this.m_146908_() + 90.0f));
                PlayerFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (PlayerFormEntity.this.attacktick == 13) {
                float volume = this.playerFormEntity.getVolume() + 0.15f;
                float pitch = this.playerFormEntity.getPitch(this.playerFormEntity.m_217043_()) - 0.5f;
                this.playerFormEntity.m_9236_().m_5594_((Player)null, this.playerFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (PlayerFormEntity.this.attacktick == 22) {
                PlayerFormEntity.this.destroySwingable();
                if (PlayerFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f) {
                    this.attackTarget.m_6469_(PlayerFormEntity.this.getDamage(), (float)PlayerFormEntity.this.m_21133_(Attributes.f_22281_) * 1.3f);
                    if (this.attackTarget.m_6084_()) {
                        Player player;
                        double dx = MathUtils.sin((float)MathUtils.APPROX_PI) * 2.25f;
                        double dz = this.attackTarget.m_20189_();
                        double strength = 1.85f;
                        this.attackTarget.m_147240_(strength, dx, dz);
                        LivingEntity livingEntity = this.attackTarget;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    }
                }
            }
            PlayerFormEntity.this.m_21573_().m_26569_();
        }
    }

    public class CrossbowAttackStrafeGoal<T extends Monster & CrossbowAttackMob>
    extends Goal {
        public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
        private final T mob;
        private CrossbowState crossbowState = CrossbowState.UNCHARGED;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private int attackDelay;
        private int updatePathDelay;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ PlayerFormEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public CrossbowAttackStrafeGoal(T t, double pAttackRadius, float f) {
            void pMob;
            this.this$0 = (PlayerFormEntity)this$0;
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.attackRadiusSqr = (float)(pAttackRadius * pAttackRadius);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.isValidTarget() && this.isHoldingCrossbow();
        }

        private boolean isHoldingCrossbow() {
            return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public boolean m_8045_() {
            return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
        }

        private boolean isValidTarget() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.m_6710_((LivingEntity)null);
            this.seeTime = 0;
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
                ((CrossbowAttackMob)this.mob).m_6136_(false);
                CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                double d1 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                if (!(d1 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d1 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d1 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Entity entity = this.mob.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                    }
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                double d0 = this.mob.m_20280_((Entity)livingentity);
                boolean flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                if (this.crossbowState == CrossbowState.UNCHARGED) {
                    if (!flag2) {
                        this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                        this.crossbowState = CrossbowState.CHARGING;
                        ((CrossbowAttackMob)this.mob).m_6136_(true);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGING) {
                    ItemStack itemstack;
                    int i;
                    if (!this.mob.m_6117_()) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                    }
                    if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.mob.m_21211_()))) {
                        this.mob.m_21253_();
                        this.crossbowState = CrossbowState.CHARGED;
                        this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                        ((CrossbowAttackMob)this.mob).m_6136_(false);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGED) {
                    --this.attackDelay;
                    if (this.attackDelay == 0) {
                        this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    }
                } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                    ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                    ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }

        private boolean canRun() {
            return this.crossbowState == CrossbowState.UNCHARGED;
        }

        static enum CrossbowState {
            UNCHARGED,
            CHARGING,
            CHARGED,
            READY_TO_ATTACK;

        }
    }

    public class BuffAlliesGoal
    extends Goal {
        protected final Level level;
        public final Mob mob;
        private final RangedBuff rangedAttackMob;
        private final TargetingConditions PARTNER_TARGETING;
        private final Class<? extends Mob> partnerClass;
        @Nullable
        protected Mob partner;
        private int attackTime = -1;
        private final double speedModifier;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;

        public BuffAlliesGoal(RangedBuff mob1, Class<? extends Mob> partnerClass, double speedModifier, int attackTime, int attackTime1, float attackRadius) {
            this(mob1, partnerClass, speedModifier, attackTime, attackTime1, attackRadius, null);
        }

        public BuffAlliesGoal(RangedBuff mob1, Class<? extends Mob> partnerClass, double speedModifier, int attackTime, int attackTime1, @Nullable float attackRadius, Predicate<LivingEntity> en) {
            this.partnerClass = partnerClass;
            if (!(mob1 instanceof LivingEntity)) {
                throw new IllegalArgumentException("Buff");
            }
            this.level = ((LivingEntity)mob1).m_9236_();
            this.rangedAttackMob = mob1;
            this.mob = (Mob)mob1;
            this.PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(this.mob.m_21172_(Attributes.f_22277_)).m_26888_(en);
            this.speedModifier = speedModifier;
            this.attackIntervalMin = attackTime;
            this.attackIntervalMax = attackTime1;
            this.attackRadius = attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() != null || this.getFreePartner() == null) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partnerClass != null;
        }

        public boolean m_8045_() {
            return this.partner != null && (this.partner.m_6084_() || this.getFreePartner() != null);
        }

        public void m_8041_() {
            this.partner = null;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            assert (this.partner != null);
            double d0 = this.mob.m_20275_(this.partner.m_20185_(), this.partner.m_20186_(), this.partner.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.partner);
            this.mob.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
            this.mob.m_21563_().m_24960_((Entity)this.partner, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.performRangedBuff((LivingEntity)this.partner, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }

        @Nullable
        private Mob getFreePartner() {
            List list = this.level.m_45971_(this.partnerClass, this.PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(this.mob.m_21172_(Attributes.f_22277_)));
            double d0 = Double.MAX_VALUE;
            Mob inf = null;
            for (Mob inf1 : list) {
                if (!(this.mob.m_20280_((Entity)inf1) < d0)) continue;
                inf = inf1;
                d0 = this.mob.m_20280_((Entity)inf1);
            }
            return inf;
        }
    }
}

