/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.controls.WallMovementControl;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.ReanimateOthersGoal;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PodInfectorEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> SIZE_VARIANT = SynchedEntityData.m_135353_(PodInfectorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BURROW_TIMER = SynchedEntityData.m_135353_(PodInfectorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GRABBED_TIMER = SynchedEntityData.m_135353_(PodInfectorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int SIZE0 = 0;
    public static final int SIZE1 = 1;
    public static final int SIZE2 = 2;
    public static final int SIZE3 = 3;
    public static final int SIZE4 = 4;
    private static boolean leaping = false;
    private final int maxFace;
    public static final int BURROW_ANIM_TIME = 35;
    public boolean playedBiteSound;

    public PodInfectorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.maxFace = (Integer)DawnOfTheFloodConfig.SERVER.pod_infector_ticks_before_exploding.get();
        this.playedBiteSound = false;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 32.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -3.2f);
        this.f_21342_ = new WallMovementControl((Mob)this);
        this.f_21344_ = new WallClimberNavigation((Mob)this, pLevel);
        this.m_274367_(0.5f);
        this.f_21364_ = 0;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROW_TIMER, (Object)0);
        this.f_19804_.m_135372_(SIZE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(GRABBED_TIMER, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("sizeVariant", this.getSizeVariant());
        nbt.m_128405_("burrowTimer", this.getBurrowTimer());
        nbt.m_128405_("grabbedTimer", this.getGrabbedTimer());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSizeVariant(nbt.m_128451_("sizeVariant"));
        this.setBurrowTimer(nbt.m_128451_("burrowTimer"));
        this.setGrabbedTimer(nbt.m_128451_("grabbedTimer"));
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public int m_8100_() {
        return 15 + this.f_19796_.m_188503_(15);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.pod_infector_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.pod_infector_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22283_, 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.5 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.65f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(4, (Goal)new ReanimateOthersGoal((PathfinderMob)this, 1.2, BodyEntity.class));
        this.f_21345_.m_25352_(6, (Goal)new PodRidesTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PodLeapGoal((Mob)this, 0.65f));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkPodInfectorRules(EntityType<? extends PodInfectorEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && PodInfectorEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && PodInfectorEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 0;
    }

    public boolean doAirAnim() {
        return !this.m_20096_() && leaping;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerV", 7, event -> {
            if (event.isMoving() && !this.m_5912_() && this.m_20096_()) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("pod.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.m_20096_()) {
                event.getController().setAnimationSpeed(1.8);
                return event.setAndContinue(RawAnimation.begin().thenLoop("pod.target"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.m_20096_()) {
                event.getController().setAnimationSpeed(1.2);
                return event.setAndContinue(RawAnimation.begin().thenLoop("pod.idle"));
            }
            if (this.getBurrowTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("pod.burrow"));
            }
            return PlayState.CONTINUE;
        })});
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerK", 7, event -> {
            if (this.doAirAnim() && this.getBurrowTimer() == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("pod.air"));
            }
            return PlayState.STOP;
        })});
    }

    public int getBurrowTimer() {
        return (Integer)this.f_19804_.m_135370_(BURROW_TIMER);
    }

    public void setBurrowTimer(int ticks) {
        this.f_19804_.m_135381_(BURROW_TIMER, (Object)ticks);
    }

    public int getGrabbedTimer() {
        return (Integer)this.f_19804_.m_135370_(GRABBED_TIMER);
    }

    public void setGrabbedTimer(int ticks) {
        this.f_19804_.m_135381_(GRABBED_TIMER, (Object)ticks);
    }

    public int getSizeVariant() {
        return (Integer)this.f_19804_.m_135370_(SIZE_VARIANT);
    }

    public void setSizeVariant(int variant) {
        this.f_19804_.m_135381_(SIZE_VARIANT, (Object)variant);
    }

    protected void m_8024_() {
        if (this.getBurrowTimer() > 0) {
            this.setBurrowTimer(this.getBurrowTimer() - 1);
        }
        super.m_8024_();
    }

    public float getVolume() {
        return 1.85f;
    }

    public float getPitch(RandomSource random) {
        return 0.95f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundRegistry.POD_INFECTOR_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.POD_INFECTOR_IDLE.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.POD_INFECTOR_IDLE.get();
    }

    public int getSubtractionPoints() {
        return 5;
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(6);
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        cloud.m_19734_(Mth.m_14107_((double)((double)cloud.m_19748_() / 3.0 * 1.2)));
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void popThis() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_146870_();
            if (Math.random() <= (double)0.1f) {
                this.m_19998_((ItemLike)ItemRegistry.POD_FRAGMENT.get());
            }
        }
    }

    private void killWithPod() {
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.pod_infector_instant_latch_kill.get()).booleanValue()) {
            this.m_5448_().m_6469_(DamageTypeRegistry.pod_pop_damage((Entity)this), Float.MAX_VALUE);
        }
    }

    private void burst() {
        this.killWithPod();
        AABB boundingBox = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && !EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) {
                float dist = this.m_20270_((Entity)livingEntity);
                double math = 29.299374f / MathUtils.randLog((float)((float)Math.E), (float)((float)Math.PI));
                livingEntity.m_6469_(DamageTypeRegistry.pod_pop_damage((Entity)this), (float)(this.m_21133_(Attributes.f_22281_) * math * (double)0.85f * (Double)DawnOfTheFloodConfig.SERVER.pod_infector_extra_explosion_damage.get() * (double)((float)Math.PI / dist)));
            }
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockUtils.generateBlood(this.m_9236_(), blockpos);
            }
        }
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.POD_INFECTOR_POP.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
        if (((Boolean)DawnOfTheFloodConfig.SERVER.pod_infector_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(5), (float)0.15f, (int)4, (int)9);
        }
        this.spawnLingeringCloud();
        this.popThis();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(0.5f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(17), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_) * 0.5);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.35), PerformanceEngine.getParticleCount(3), 0.1, 0.2, 0.1, 0.01);
        }
    }

    private void dieBurst() {
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.POD_INFECTOR_POP.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
        this.popThis();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(0.5f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(13), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            server.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.35), PerformanceEngine.getParticleCount(3), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
        if (PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(5), (float)0.1f, (int)4, (int)7);
        }
        AABB boundingBox = this.m_20191_().m_82400_(2.2);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) continue;
            livingEntity.m_6469_(DamageTypeRegistry.pod_pop_damage((Entity)this), (float)(this.m_21133_(Attributes.f_22281_) * 3.1415927410125732 * (Double)DawnOfTheFloodConfig.SERVER.pod_infector_extra_explosion_damage.get() / 6.0));
        }
    }

    private void weakBurst() {
        AABB boundingBox = this.m_20191_().m_82400_(2.5);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) continue;
            livingEntity.m_6469_(DamageTypeRegistry.pod_pop_damage((Entity)this), (float)(this.m_21133_(Attributes.f_22281_) * 3.1415927410125732 * (Double)DawnOfTheFloodConfig.SERVER.pod_infector_extra_explosion_damage.get() / 6.0));
        }
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.POD_INFECTOR_POP.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
        if (((Boolean)DawnOfTheFloodConfig.SERVER.pod_infector_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(6), (float)0.1f, (int)4, (int)7);
        }
        this.popThis();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)server, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPodExplosionSmoke().clone().scale(0.5f).position(this.m_20182_()));
            }
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(13), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            server.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.35), PerformanceEngine.getParticleCount(3), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    private void chainedBurst() {
        AABB boundingBox = this.m_20191_().m_82400_(2.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof PodInfectorEntity)) continue;
            PodInfectorEntity podInfector = (PodInfectorEntity)entity;
            LivingEntity target1 = this.m_5448_();
            LivingEntity target2 = podInfector.m_5448_();
            if (target1 == null || target2 == null || target1 != target2) continue;
            podInfector.dieBurst();
        }
    }

    private void chainedWeakBurst() {
        AABB boundingBox = this.m_20191_().m_82400_(10.0);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            if (!(entity instanceof PodInfectorEntity)) continue;
            PodInfectorEntity podInfector = (PodInfectorEntity)entity;
            LivingEntity target1 = this.m_5448_();
            LivingEntity target2 = podInfector.m_5448_();
            if (target1 == null || target2 == null || target1 != target2 || !(this.m_20270_((Entity)target1) < 1.9f) || !(podInfector.m_20270_((Entity)target2) < 2.5f)) continue;
            podInfector.weakBurst();
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public boolean hasBodyNearby() {
        AABB bodyArea = this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_) / 2.0);
        List entities = this.m_9236_().m_45933_((Entity)this, bodyArea);
        ArrayList<BodyEntity> bodyEntityList = new ArrayList<BodyEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof BodyEntity)) continue;
            BodyEntity bodyEntity = (BodyEntity)entity;
            bodyEntityList.add(bodyEntity);
        }
        return !bodyEntityList.isEmpty();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.hasBodyNearby() && !this.isAttachedToHost()) {
            if (this.m_5448_() != null) {
                this.m_6710_(null);
            }
            if (this.m_5912_()) {
                this.m_21561_(false);
            }
        }
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if ((target = this.m_5448_()) != null) {
            if (target.m_20363_((Entity)this)) {
                this.setGrabbedTimer(this.getGrabbedTimer() + 1);
                if (this.getGrabbedTimer() > this.maxFace + this.f_19796_.m_188503_(15)) {
                    this.burst();
                }
                if (this.f_19796_.m_188503_(7) == 0) {
                    if (this.m_6060_()) {
                        this.m_20254_(5);
                    }
                    this.m_5634_(0.5f);
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        player.m_36399_(1.5f);
                    }
                }
                if (this.f_19797_ > 0) {
                    this.summonFloodParticle();
                    if (this.getBurrowTimer() == 0) {
                        this.setBurrowTimer(35);
                    }
                }
                if (this.f_19797_ % this.maxFace == 0) {
                    this.burst();
                }
                if (!this.playedBiteSound) {
                    this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.POD_INFECTOR_BITE.get(), SoundSource.HOSTILE, this.getVolume() + 0.15f, this.getPitch(this.f_19796_));
                    this.playedBiteSound = true;
                }
            } else {
                this.playedBiteSound = false;
            }
        }
        if (this.m_6084_() && target != null) {
            this.chainedWeakBurst();
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.pod_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(500) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 0.5) {
            this.m_5634_(0.5f);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity;
        if (this.isAttachedToHost() && Math.random() <= 0.75) {
            this.detachFromHost();
        }
        if ((entity = pSource.m_7640_()) instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void detachFromHost() {
        Entity vehicle = this.m_20202_();
        this.m_19877_();
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        return super.m_7688_(passenger);
    }

    public boolean isAttachedToHost() {
        return this.m_20202_() instanceof LivingEntity;
    }

    public void grabTarget(LivingEntity entity) {
        ServerPlayer player;
        this.m_7998_((Entity)entity, true);
        this.m_21561_(false);
        entity.f_20883_ = this.f_20883_;
        entity.f_20900_ = 0.0f;
        entity.f_20902_ = 0.0f;
        entity.f_20901_ = 0.0f;
        entity.f_20883_ = -90.0f;
        entity.m_7910_(0.0f);
        if (!(!(entity instanceof ServerPlayer) || (player = (ServerPlayer)entity).m_7500_() && player.m_5833_())) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)entity));
        }
    }

    public void m_6667_(DamageSource source) {
        this.dieBurst();
        this.chainedBurst();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 1) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        int rand = this.f_19796_.m_188503_(5);
        switch (rand) {
            case 0: {
                this.setSizeVariant(0);
                break;
            }
            case 1: {
                this.setSizeVariant(1);
                break;
            }
            case 2: {
                this.setSizeVariant(2);
                break;
            }
            case 3: {
                this.setSizeVariant(3);
                break;
            }
            case 4: {
                this.setSizeVariant(4);
            }
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    static class Variants {
        public static final int SIZE0 = 0;
        public static final int SIZE1 = 1;
        public static final int SIZE2 = 2;
        public static final int SIZE3 = 3;
        public static final int SIZE4 = 4;

        Variants() {
        }
    }

    public class PodRidesTargetGoal
    extends Goal {
        private final PodInfectorEntity podInfectorEntity;

        public PodRidesTargetGoal(PodInfectorEntity podInfectorEntity) {
            this.podInfectorEntity = podInfectorEntity;
        }

        public boolean isValidTarget() {
            LivingEntity attackTarget = this.podInfectorEntity.m_5448_();
            return attackTarget != null && this.podInfectorEntity.m_20270_((Entity)attackTarget) < 2.0f;
        }

        public boolean m_8036_() {
            return this.podInfectorEntity.m_5448_() != null && this.podInfectorEntity.m_6084_() && !this.podInfectorEntity.m_20160_() && this.podInfectorEntity.m_217043_().m_188503_(7) == 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.podInfectorEntity.m_5448_() != null && this.isValidTarget()) {
                PodInfectorEntity.this.grabTarget(this.podInfectorEntity.m_5448_());
            }
        }
    }

    public static class PodLeapGoal
    extends Goal {
        private final Mob mob;
        private LivingEntity target;
        private final float yd;
        private boolean canJump = true;

        public PodLeapGoal(Mob mob, float v) {
            this.mob = mob;
            this.yd = v;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.target == null) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            double d0 = this.mob.m_20270_((Entity)this.target);
            if (d0 > 3.0 && d0 < 12.0) {
                if (!this.mob.m_20096_()) {
                    return false;
                }
                return this.mob.m_217043_().m_188503_(PodLeapGoal.m_186073_((int)5)) == 0 && this.canJump;
            }
            return false;
        }

        public void m_8037_() {
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                this.mob.m_146926_(this.target.m_146909_());
                leaping = true;
            }
        }

        public void m_8056_() {
            this.canJump = this.mob.m_217043_().m_188503_(2) == 0;
            Vec3 vec3 = this.mob.m_20184_();
            Vec3 vec31 = new Vec3(this.target.m_20185_() - this.mob.m_20185_(), 0.0, this.target.m_20189_() - this.mob.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(2.0).m_82549_(vec3.m_82490_(1.5));
            }
            this.mob.m_20334_(vec31.f_82479_ + (double)(this.yd * 0.04027683f), (double)this.yd + (double)MathUtils.APPROX_PI / 12.0, vec31.f_82481_ + (double)this.yd);
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }
}

