/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.MathUtils;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.controls.WallMovementControl;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.LeapAttackGoal;
import net.teamabyssalofficial.entity.ai.OpenFenceGateGoal;
import net.teamabyssalofficial.entity.ai.ParkourGoal;
import net.teamabyssalofficial.entity.ai.TargetCropsGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.DeadSangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBlamiteCrystalEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.guns.gun.GunItem;
import net.teamabyssalofficial.guns.gun.GunRegistry;
import net.teamabyssalofficial.guns.helper.GunVariant;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.SoundPacket;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SangheiliFormEntity
extends BaseForm
implements GeoEntity,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GUN_VARIANT = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPAWN_TIMER = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROAR_TIMER = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENERGY_SHIELD_COUNT = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> MUZZLE_FLASH = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAND_POSE = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ENERGY_SHIELD = SynchedEntityData.m_135353_(SangheiliFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final GunVariant MAGNUM = new GunVariant("magnum", 1, 15.0f, 0.1f, ((Double)DawnOfTheFloodConfig.SERVER.magnum_bullet_damage.get()).floatValue() / 1.65f, 1, 8, (SoundEvent)SoundRegistry.MAGNUM_SHOOT.get(), SoundEvents.f_271165_, false);
    public static final GunVariant MK50_SIDEKICK = new GunVariant("mk50_sidekick", 2, 15.0f, 0.1f, ((Double)DawnOfTheFloodConfig.SERVER.mk50_sidekick_bullet_damage.get()).floatValue() / 1.65f, 1, 12, (SoundEvent)SoundRegistry.MK50_SIDEKICK_SHOOT.get(), SoundEvents.f_271165_, false);
    public static final GunVariant NEEDLER = new GunVariant("needler", 3, 15.5f, 0.15f, ((Double)DawnOfTheFloodConfig.SERVER.needler_bullet_damage.get()).floatValue() / 1.65f, 2, 26, (SoundEvent)SoundRegistry.NEEDLER_SHOOT.get(), (SoundEvent)SoundRegistry.NEEDLER_RELOAD_DONE.get(), false);
    private final int NO_GUN = 0;
    private final int ENERGY_SWORD = 4;
    public boolean noAmmo = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public static final byte ATTACK = 1;
    public static final byte PIERCE_ATTACK = 2;
    public static final byte SWORD_ATTACK = 3;
    public static final int ATTACK_LENGTH = 16;
    public static final int PIERCE_ATTACK_LENGTH = 14;
    public static final int SWORD_ATTACK_LENGTH = 18;
    public static final int ROAR_TICKS = 88;
    public static final int SPAWN_TICKS = 35;
    public static final int SUPERIOR = 0;
    public static final int SPIKY = 1;
    public static final int TOUGH = 2;
    public static final int DEFAULT = 0;
    public static final int PURPLE = 1;
    public static final int RED = 2;
    public static final int DARK = 3;
    private boolean isAlreadySuperior = false;
    private boolean isAlreadySpiky = false;
    private boolean isAlreadyTough = false;
    public boolean isDefault = false;
    public boolean isPurple = false;
    public boolean isRed = false;
    public boolean isDark = false;
    public float shieldOpacity = 0.55f;

    public SangheiliFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 32.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        if (((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_climb.get()).booleanValue()) {
            this.f_21342_ = new WallMovementControl((Mob)this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, pLevel);
        }
        this.m_274367_(1.5f);
        this.f_21364_ = 20;
        this.isCombat = false;
        this.isSangheili = true;
        this.aggroTicks = this.getAggroTicks();
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(GUN_VARIANT, (Object)0);
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)35);
        this.f_19804_.m_135372_(ROAR_TIMER, (Object)0);
        this.f_19804_.m_135372_(AMMO, (Object)0);
        this.f_19804_.m_135372_(ENERGY_SHIELD_COUNT, (Object)0);
        this.f_19804_.m_135372_(MUZZLE_FLASH, (Object)false);
        this.f_19804_.m_135372_(HAND_POSE, (Object)false);
        this.f_19804_.m_135372_(ENERGY_SHIELD, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.45).m_22268_(Attributes.f_22283_, 1.35).m_22268_(Attributes.f_22278_, 1.25).m_22268_(Attributes.f_22284_, 10.0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant());
        pCompound.m_128405_("Texture_Variant", this.getTextureVariant());
        pCompound.m_128405_("Gun_Variant", this.getGunVariant());
        pCompound.m_128405_("ammo", this.getAmmo());
        pCompound.m_128405_("aggroTicks", this.getAggroTicks());
        pCompound.m_128405_("spawnTimer", this.getSpawnTimer());
        pCompound.m_128405_("roarTimer", this.getRoarTimer());
        pCompound.m_128405_("energyShieldCount", this.getEnergyShieldCount());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(pCompound.m_128451_("Variant"));
        this.setTextureVariant(pCompound.m_128451_("Texture_Variant"));
        this.setGunVariant(pCompound.m_128451_("Gun_Variant"));
        this.setAmmo(pCompound.m_128451_("ammo"));
        this.setAggroTicks(pCompound.m_128451_("aggroTicks"));
        this.setSpawnTimer(pCompound.m_128451_("spawnTimer"));
        this.setRoarTimer(pCompound.m_128451_("roarTimer"));
        this.setEnergyShieldCount(pCompound.m_128451_("energyShieldCount"));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FireGunAttackGoal(this, 0.85, 5, 15.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SangheiliFormEntity.this.isImmobile && SangheiliFormEntity.this.noWater() && SangheiliFormEntity.this.isHoldingGun() && SangheiliFormEntity.this.gunPredicate() && SangheiliFormEntity.this.getGunVariant() == MAGNUM.getId();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new FireGunAttackGoal(this, 0.9, 5, 14.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SangheiliFormEntity.this.isImmobile && SangheiliFormEntity.this.noWater() && SangheiliFormEntity.this.isHoldingGun() && SangheiliFormEntity.this.gunPredicate() && SangheiliFormEntity.this.getGunVariant() == MK50_SIDEKICK.getId();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new FireGunAttackGoal(this, 0.95, 3, 13.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SangheiliFormEntity.this.isImmobile && SangheiliFormEntity.this.noWater() && SangheiliFormEntity.this.isHoldingGun() && SangheiliFormEntity.this.gunPredicate() && SangheiliFormEntity.this.getGunVariant() == NEEDLER.getId();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new SangheiliFormMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SangheiliFormPierceAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SangheiliFormSwordAttackGoal(this));
        this.f_21345_.m_25352_(4, new BaseForm.LongDistancePatrolGoal<SangheiliFormEntity>(this, 1.0, 0.9));
        this.f_21345_.m_25352_(5, (Goal)new TargetCropsGoal((PathfinderMob)this, 1.2, 32));
        this.f_21345_.m_25352_(3, (Goal)new LeapAttackGoal((Mob)this, 0.45f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SangheiliFormEntity.this.isImmobile;
            }

            @Override
            public void m_8037_() {
                SangheiliFormEntity.this.setLeaping(true);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OpenFenceGateGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new ParkourGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SangheiliFormEntity.this.isImmobile;
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }
        });
    }

    public boolean noWater() {
        return !this.m_5842_();
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getRoarTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.roar"));
            }
            if (this.getSpawnTimer() > 0 && this.isTransformed()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.transform"));
            }
            if (this.isLeaping() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.leap"));
            }
            if (this.m_5842_() && !this.m_20096_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.swim"));
            }
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.death"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("sangheili.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                event.getController().setAnimationSpeed(1.5);
                return event.setAndContinue(RawAnimation.begin().thenLoop("sangheili.form.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                event.getController().setAnimationSpeed(1.65);
                return event.setAndContinue(RawAnimation.begin().thenLoop("sangheili.form.target"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.attack"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("sangheili.form.target.attack"));
            }
            if (this.attackID == 3) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("sangheili.form.sword.attack"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public int getRoarTimer() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TIMER);
    }

    public void setRoarTimer(int ticks) {
        this.f_19804_.m_135381_(ROAR_TIMER, (Object)ticks);
    }

    public int getAmmo() {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public void setAmmo(int ammo) {
        this.f_19804_.m_135381_(AMMO, (Object)ammo);
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public int getGunVariant() {
        return (Integer)this.f_19804_.m_135370_(GUN_VARIANT);
    }

    public void setGunVariant(int variant) {
        this.f_19804_.m_135381_(GUN_VARIANT, (Object)variant);
    }

    public int getEnergyShieldCount() {
        return (Integer)this.f_19804_.m_135370_(ENERGY_SHIELD_COUNT);
    }

    public void setEnergyShieldCount(int count) {
        this.f_19804_.m_135381_(ENERGY_SHIELD_COUNT, (Object)count);
    }

    public boolean isMuzzleFlashRendered() {
        return (Boolean)this.f_19804_.m_135370_(MUZZLE_FLASH);
    }

    public void renderMuzzleFlash(boolean pMuzzle) {
        this.f_19804_.m_135381_(MUZZLE_FLASH, (Object)pMuzzle);
    }

    public boolean isHandPosing() {
        return (Boolean)this.f_19804_.m_135370_(HAND_POSE);
    }

    public void poseHand(boolean pPose) {
        this.f_19804_.m_135381_(HAND_POSE, (Object)pPose);
    }

    public boolean hasEnergyShield() {
        return (Boolean)this.f_19804_.m_135370_(ENERGY_SHIELD);
    }

    public void setHasEnergyShield(boolean pEnergyShield) {
        this.f_19804_.m_135381_(ENERGY_SHIELD, (Object)pEnergyShield);
    }

    public boolean isHoldingGun() {
        return this.getAmmo() > 0 && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) >= 4.0f && this.getGunVariant() != 0 && this.getGunVariant() != 4;
    }

    public boolean gunPredicate() {
        return this.m_5448_() != null && !(this.m_5448_() instanceof Squid) && !(this.m_5448_() instanceof Animal) && !(this.m_5448_() instanceof ArmorStand) && !(this.m_5448_() instanceof AbstractFish) && !(this.m_5448_() instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(this.m_5448_().m_20078_());
    }

    @Override
    protected void m_8024_() {
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getRoarTimer() > 0) {
            this.setRoarTimer(this.getRoarTimer() - 1);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            if (this.getGunVariant() == 4) {
                int random = this.f_19796_.m_188503_(6);
                switch (random) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.attackID = 1;
                        break;
                    }
                    case 3: {
                        this.attackID = 2;
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.attackID = 3;
                    }
                }
            } else {
                this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 2;
            }
        }
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (this.m_6084_() && attackTarget != null && this.m_142582_((Entity)attackTarget) && this.m_20270_((Entity)attackTarget) <= 10.0f && ((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_breaks_blocks.get()).booleanValue()) {
            SoundPacket soundPacket = new SoundPacket((SoundEvent)SoundRegistry.COMBAT_HUMAN_VOICE.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
            BlockUtils.destroyBlocks(this.m_9236_(), (LivingEntity)this, 0.25, this.getDestroySpeed(), 55, soundPacket);
        }
    }

    public int getDestroySpeed() {
        return 2;
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().f_46443_) {
            this.renderMuzzleFlash(true);
            this.setAmmo(this.getAmmo() - 1);
            switch (this.getGunVariant()) {
                case 1: {
                    this.m_9236_().m_5594_(null, this.m_20183_(), MAGNUM.getShootSound(), SoundSource.PLAYERS, 2.0f, 1.0f);
                    for (int i = 0; i < MAGNUM.getPelletCount(); ++i) {
                        this.spawnBullet((LivingEntity)this, this.m_9236_(), MAGNUM.getDamage(), MAGNUM.getVelocity(), MAGNUM.getInaccuracy(), MAGNUM.doesDamageDecreaseWithDistance());
                    }
                    break;
                }
                case 2: {
                    this.m_9236_().m_5594_(null, this.m_20183_(), MK50_SIDEKICK.getShootSound(), SoundSource.PLAYERS, 2.0f, 1.0f);
                    for (int i = 0; i < MK50_SIDEKICK.getPelletCount(); ++i) {
                        this.spawnBullet((LivingEntity)this, this.m_9236_(), MK50_SIDEKICK.getDamage(), MK50_SIDEKICK.getVelocity(), MK50_SIDEKICK.getInaccuracy(), MK50_SIDEKICK.doesDamageDecreaseWithDistance());
                    }
                    break;
                }
                case 3: {
                    this.m_9236_().m_5594_(null, this.m_20183_(), NEEDLER.getShootSound(), SoundSource.PLAYERS, 2.0f, 1.0f);
                    for (int i = 0; i < NEEDLER.getPelletCount(); ++i) {
                        this.spawnBullet((LivingEntity)this, this.m_9236_(), NEEDLER.getDamage(), NEEDLER.getVelocity(), NEEDLER.getInaccuracy(), NEEDLER.doesDamageDecreaseWithDistance());
                    }
                    break;
                }
            }
        }
    }

    public void spawnBullet(LivingEntity user, Level world, double damage, float velocity, float inaccuracy, boolean doesDamageDecreaseWithDistance) {
        double point = (double)(this.f_19796_.m_188499_() ? 1 : -1) * 4.0;
        double pX = (double)inaccuracy * (double)this.f_19796_.m_188501_() * point;
        if (this.getGunVariant() != 3) {
            AbstractBullet abstractBullet = new AbstractBullet(user, world, damage, velocity, doesDamageDecreaseWithDistance);
            abstractBullet.m_146884_(user.m_20182_().m_82520_(pX, (double)user.m_20192_(), 0.0));
            abstractBullet.shoot(user.m_20154_());
            abstractBullet.m_5602_((Entity)user);
            world.m_7967_((Entity)abstractBullet);
        } else {
            AbstractBlamiteCrystalEntity abstractBlamiteCrystalEntity = new AbstractBlamiteCrystalEntity(user, world, damage, velocity, doesDamageDecreaseWithDistance);
            abstractBlamiteCrystalEntity.m_146884_(user.m_20182_().m_82520_(pX, (double)user.m_20192_(), 0.0));
            abstractBlamiteCrystalEntity.shoot(user.m_20154_());
            abstractBlamiteCrystalEntity.m_5602_((Entity)user);
            world.m_7967_((Entity)abstractBlamiteCrystalEntity);
        }
    }

    public static boolean checkFloodSangheiliFormRules(EntityType<? extends SangheiliFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && SangheiliFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && SangheiliFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 3;
    }

    @Override
    public int getSubtractionPoints() {
        return 120;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.ENTITY_FORM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.HUMAN_FORM_DEATH.get();
    }

    @Override
    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.COMBAT_HUMAN_VOICE.get();
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SoundRegistry.ENTITY_FORM_STEP.get(), this.getVolume() * 0.85f, this.getPitch(this.f_19796_) * 0.55f);
    }

    @Override
    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 3) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        if (Math.random() <= (double)0.15f && !this.isReanimated() && ((Boolean)DawnOfTheFloodConfig.SERVER.corpse_spawn.get()).booleanValue()) {
            this.dropBody((Entity)this);
            this.vanish();
            this.setIsReanimated(true);
            this.willDiscard(true);
        } else {
            this.willDiscard(false);
        }
        super.m_6667_(source);
    }

    protected void m_6153_() {
        super.m_6153_();
        ++this.f_20919_;
        if (this.f_20919_ == 1 && this.shouldDiscard()) {
            this.m_146870_();
        } else if (this.f_20919_ == 30 && !this.shouldDiscard()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        switch (this.getGunVariant()) {
            case 1: 
            case 2: {
                if (!(Math.random() <= 0.85)) break;
                this.m_19998_((ItemLike)GunRegistry.PISTOL_BULLET.get());
                break;
            }
            case 3: {
                if (!(Math.random() <= 0.55)) break;
                this.m_19998_((ItemLike)GunRegistry.BLAMITE_CRYSTAL.get());
                break;
            }
            case 4: {
                if (!(Math.random() <= 0.03)) break;
                this.m_19998_((ItemLike)ItemRegistry.ENERGY_SWORD.get());
            }
        }
    }

    private void dropBody(Entity entity) {
        DeadSangheiliFormEntity deadSangheiliFormEntity = new DeadSangheiliFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.DEAD_SANGHEILI_FORM.get()), entity.m_9236_());
        deadSangheiliFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        deadSangheiliFormEntity.setVariant(this.getVariant());
        deadSangheiliFormEntity.setTextureVariant(this.getTextureVariant());
        deadSangheiliFormEntity.setGunVariant(this.getGunVariant());
        deadSangheiliFormEntity.m_8061_(EquipmentSlot.MAINHAND, this.m_21205_());
        deadSangheiliFormEntity.setAmmo(this.getAmmo());
        deadSangheiliFormEntity.m_146926_(entity.m_146909_());
        deadSangheiliFormEntity.m_146922_(entity.m_146908_());
        deadSangheiliFormEntity.m_5618_(this.f_20883_);
        deadSangheiliFormEntity.m_5616_(this.f_20885_);
        deadSangheiliFormEntity.m_21563_().m_24964_(entity.m_20154_());
        deadSangheiliFormEntity.m_6593_(entity.m_7770_());
        entity.m_9236_().m_7967_((Entity)deadSangheiliFormEntity);
    }

    private void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(6), 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_REMOVED.get(), SoundSource.HOSTILE, 1.05f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
    }

    @Override
    public double getMovementSpeed() {
        switch (this.getVariant()) {
            case 0: {
                return 0.25;
            }
            case 1: {
                return 0.25;
            }
            case 2: {
                return 0.2;
            }
        }
        return 0.25;
    }

    private double getSweepingRange() {
        if (this.getGunVariant() != 4) {
            return 1.95;
        }
        return 2.25;
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_(this.getSweepingRange());
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_((Player)null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)0.95f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public int getAmmoCapacity() {
        switch (this.getGunVariant()) {
            case 1: {
                return MAGNUM.getAmmo();
            }
            case 2: {
                return MK50_SIDEKICK.getAmmo();
            }
            case 3: {
                return NEEDLER.getAmmo();
            }
        }
        return 0;
    }

    @Override
    public void m_8119_() {
        float f;
        super.m_8119_();
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && ((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_tremble_walk.get()).booleanValue() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            if (PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 12.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(12), (float)0.015f, (int)3, (int)2);
            }
            this.m_9236_().m_5594_((Player)null, this.m_20183_(), SoundEvents.f_12361_, SoundSource.HOSTILE, this.getVolume() * 1.25f, this.getPitch(this.f_19796_) * 0.75f);
        }
        if (this.shieldOpacity > 0.55f) {
            this.shieldOpacity -= 0.01f;
        }
        if (this.getAmmo() < this.getAmmoCapacity() && Math.random() <= 0.0211) {
            this.setAmmo(this.getAmmo() + 1);
        }
        if (this.getAmmo() == 0 && !this.noAmmo) {
            this.noAmmo = true;
            switch (this.getGunVariant()) {
                case 1: {
                    this.m_9236_().m_5594_((Player)null, this.m_20183_(), MAGNUM.getNoAmmoSound(), SoundSource.HOSTILE, this.getVolume() + 0.15f, 1.0f);
                    break;
                }
                case 2: {
                    this.m_9236_().m_5594_((Player)null, this.m_20183_(), MK50_SIDEKICK.getNoAmmoSound(), SoundSource.HOSTILE, this.getVolume() + 0.15f, 1.0f);
                    break;
                }
                case 3: {
                    this.m_9236_().m_5594_((Player)null, this.m_20183_(), NEEDLER.getNoAmmoSound(), SoundSource.HOSTILE, this.getVolume() + 0.15f, 1.0f);
                }
            }
        }
        if (this.m_21205_().m_41720_() instanceof GunItem) {
            ItemStack itemStack = this.m_21205_();
            CompoundTag compoundTag = itemStack.m_41784_();
            GunItem gunItem = (GunItem)itemStack.m_41720_();
            compoundTag.m_128405_("Clip", gunItem.getMagSize());
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.getSpawnTimer() > 0 || this.getRoarTimer() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getSpawnTimer() == 0 && this.getRoarTimer() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.getSpawnTimer() == 33 && this.isTransformed()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_) - 0.25f);
        }
        if (this.getSpawnTimer() == 7 && this.getRoarTimer() == 0 && this.isTransformed()) {
            this.setRoarTimer(88);
        }
        if (this.getRoarTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getRoarTimer() == 40) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_ROAR.get(), this.m_5720_(), this.getVolume() + 0.65f, this.getPitch(this.f_19796_) - 0.25f);
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 16.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(16), (float)0.18f, (int)35, (int)10);
            }
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        if (this.isSangheili && !this.isCombat) {
            if (this.getVariant() == 0 && !this.isAlreadySuperior) {
                this.isAlreadySuperior = true;
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_health.get() + 10.0);
                Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_damage.get() + 5.0);
            }
            if (this.getVariant() == 1 && !this.isAlreadySpiky) {
                this.isAlreadySpiky = true;
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_health.get() - 10.0);
                Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_damage.get() + 5.0);
            }
            if (this.getVariant() == 2 && !this.isAlreadyTough) {
                this.isAlreadyTough = true;
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.sangheili_form_health.get() + 5.0);
                Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
            }
            if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(180) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 1.5) {
                this.m_5634_(1.5f);
            }
        }
        if (this.getTextureVariant() == 0 && !this.isDefault) {
            this.isDefault = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(5.0);
        }
        if (this.getTextureVariant() == 1 && !this.isPurple) {
            this.isPurple = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(10.0);
        }
        if (this.getTextureVariant() == 2 && !this.isRed) {
            this.isRed = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(10.0);
        }
        if (this.getTextureVariant() == 3 && !this.isDark) {
            this.isDark = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(20.0);
        }
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.setHasEnergyShield(this.getEnergyShieldCount() > 0);
        if (pAmount >= 5.0f && pSource.m_7639_() != null) {
            this.setEnergyShieldCount(this.getEnergyShieldCount() - 1);
        }
        if (this.hasEnergyShield()) {
            if (pSource.m_7639_() != null && pSource.m_7639_().m_20270_((Entity)this) <= 2.2f) {
                this.shieldOpacity = 0.95f;
                pSource.m_7639_().m_6469_(this.getDamage(), 8.0f);
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.ENERGY_SWORD_DAMAGE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            return super.m_6469_(pSource, pAmount / 6.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setHasEnergyShield(true);
            this.setEnergyShieldCount(15 + this.f_19796_.m_188503_(11));
        }
        int variant = this.f_19796_.m_188503_(5);
        switch (variant) {
            case 0: {
                this.setVariant(0);
                break;
            }
            case 1: 
            case 2: {
                this.setVariant(1);
                break;
            }
            case 3: 
            case 4: {
                this.setVariant(2);
            }
        }
        int texture = this.f_19796_.m_188503_(18);
        switch (texture) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setTextureVariant(0);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.setTextureVariant(1);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.setTextureVariant(2);
                break;
            }
            case 17: {
                this.setTextureVariant(3);
            }
        }
        int gun = this.f_19796_.m_188503_(17);
        switch (gun) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setGunVariant(0);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setGunVariant(MK50_SIDEKICK.getId());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.setGunVariant(NEEDLER.getId());
                break;
            }
            case 12: 
            case 13: {
                this.setGunVariant(MAGNUM.getId());
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.setGunVariant(4);
            }
        }
        switch (this.getGunVariant()) {
            case 0: 
            case 4: {
                this.setAmmo(0);
                break;
            }
            case 1: {
                this.setAmmo(MAGNUM.getAmmo() - this.f_19796_.m_188503_(3));
                break;
            }
            case 2: {
                this.setAmmo(MK50_SIDEKICK.getAmmo() - this.f_19796_.m_188503_(5));
                break;
            }
            case 3: {
                this.setAmmo(NEEDLER.getAmmo() - this.f_19796_.m_188503_(8));
            }
        }
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        switch (this.getGunVariant()) {
            case 0: {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                break;
            }
            case 1: {
                if (!((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_use_guns.get()).booleanValue()) break;
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GunRegistry.MAGNUM.get()));
                break;
            }
            case 2: {
                if (!((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_use_guns.get()).booleanValue()) break;
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GunRegistry.MK50_SIDEKICK.get()));
                break;
            }
            case 3: {
                if (!((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_use_guns.get()).booleanValue()) break;
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GunRegistry.NEEDLER.get()));
                break;
            }
            case 4: {
                if (!((Boolean)DawnOfTheFloodConfig.SERVER.sangheili_form_use_energy_swords.get()).booleanValue()) break;
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemRegistry.ENERGY_SWORD.get()));
            }
        }
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.sangheili_form_aggro_ticks.get();
    }

    private static class Variants {
        public static final int SUPERIOR = 0;
        public static final int SPIKY = 1;
        public static final int TOUGH = 2;

        private Variants() {
        }
    }

    class SangheiliFormMeleeAttackGoal
    extends Goal {
        private final SangheiliFormEntity sangheiliFormEntity;
        private LivingEntity attackTarget;

        public SangheiliFormMeleeAttackGoal(SangheiliFormEntity sangheiliFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.sangheiliFormEntity = sangheiliFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.sangheiliFormEntity.m_5448_();
            return this.attackTarget != null && this.sangheiliFormEntity.attackID == 1 && !SangheiliFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.sangheiliFormEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.sangheiliFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.sangheiliFormEntity.attacktick < 16;
        }

        public void m_8037_() {
            if (SangheiliFormEntity.this.attacktick == 8) {
                float f1 = (float)Math.cos(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                SangheiliFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (SangheiliFormEntity.this.attacktick == 7) {
                float volume = 1.15f;
                float pitch = 0.55f;
                this.sangheiliFormEntity.m_9236_().m_5594_((Player)null, this.sangheiliFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (SangheiliFormEntity.this.attacktick == 11) {
                SangheiliFormEntity.this.destroySwingable();
                SangheiliFormEntity.this.sweep((Entity)this.attackTarget);
                if (SangheiliFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(SangheiliFormEntity.this.getDamage(), (float)SangheiliFormEntity.this.m_21133_(Attributes.f_22281_));
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_() && Math.random() <= 0.75) {
                        player.m_36384_(true);
                    }
                }
            }
            SangheiliFormEntity.this.m_21573_().m_26569_();
        }
    }

    class SangheiliFormPierceAttackGoal
    extends Goal {
        private final SangheiliFormEntity sangheiliFormEntity;
        private LivingEntity attackTarget;

        public SangheiliFormPierceAttackGoal(SangheiliFormEntity sangheiliFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.sangheiliFormEntity = sangheiliFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.sangheiliFormEntity.m_5448_();
            return this.attackTarget != null && this.sangheiliFormEntity.attackID == 2 && !SangheiliFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.sangheiliFormEntity.setAttackID(2);
        }

        public void m_8041_() {
            this.sangheiliFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.sangheiliFormEntity.attacktick < 14;
        }

        public void m_8037_() {
            if (SangheiliFormEntity.this.attacktick == 8) {
                SangheiliFormEntity.this.f_20883_ = SangheiliFormEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                SangheiliFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (SangheiliFormEntity.this.attacktick == 9) {
                float volume = 1.15f;
                float pitch = 0.55f;
                this.sangheiliFormEntity.m_9236_().m_5594_((Player)null, this.sangheiliFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (SangheiliFormEntity.this.attacktick == 13) {
                SangheiliFormEntity.this.destroySwingable();
                if (SangheiliFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                    this.attackTarget.m_6469_(SangheiliFormEntity.this.getDamage(), (float)SangheiliFormEntity.this.m_21133_(Attributes.f_22281_) * 1.35f);
                    if (this.attackTarget.m_6084_()) {
                        Player player;
                        double dx = MathUtils.sin((float)MathUtils.APPROX_PI) * 2.05f;
                        double dz = this.attackTarget.m_20189_();
                        double strength = 2.35f;
                        this.attackTarget.m_147240_(strength, dx, dz);
                        LivingEntity livingEntity = this.attackTarget;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    }
                }
            }
            SangheiliFormEntity.this.m_21573_().m_26569_();
        }
    }

    class SangheiliFormSwordAttackGoal
    extends Goal {
        private final SangheiliFormEntity sangheiliFormEntity;
        private LivingEntity attackTarget;

        public SangheiliFormSwordAttackGoal(SangheiliFormEntity sangheiliFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.sangheiliFormEntity = sangheiliFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.sangheiliFormEntity.m_5448_();
            return this.attackTarget != null && this.sangheiliFormEntity.attackID == 3 && !SangheiliFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.sangheiliFormEntity.setAttackID(3);
        }

        public void m_8041_() {
            this.sangheiliFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.sangheiliFormEntity.attacktick < 18;
        }

        public void m_8037_() {
            if (SangheiliFormEntity.this.attacktick == 5) {
                float f1 = (float)Math.cos(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(SangheiliFormEntity.this.m_146908_() + 90.0f));
                SangheiliFormEntity.this.m_5997_((double)f1 * 0.2, 0.0, (double)f2 * 0.2);
            }
            if (SangheiliFormEntity.this.attacktick == 8) {
                float volume = 1.15f;
                float pitch = 0.55f;
                this.sangheiliFormEntity.m_9236_().m_5594_((Player)null, this.sangheiliFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
                this.sangheiliFormEntity.m_9236_().m_5594_((Player)null, this.sangheiliFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENERGY_SWORD_SWING.get(), SoundSource.HOSTILE, 1.25f, 1.0f);
            }
            if (SangheiliFormEntity.this.attacktick == 11) {
                SangheiliFormEntity.this.destroySwingable();
                if (SangheiliFormEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                    Player player;
                    LivingEntity livingEntity;
                    float f = 1.55f;
                    this.sangheiliFormEntity.m_9236_().m_5594_((Player)null, this.sangheiliFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENERGY_SWORD_DAMAGE.get(), SoundSource.HOSTILE, 1.25f, 1.0f);
                    this.attackTarget.m_6469_(SangheiliFormEntity.this.getDamage(), (float)SangheiliFormEntity.this.m_21133_(Attributes.f_22281_) * f);
                    SangheiliFormEntity.this.sweep((Entity)this.attackTarget);
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_() && Math.random() <= 0.75) {
                        player.m_36384_(true);
                    }
                }
            }
            SangheiliFormEntity.this.m_21573_().m_26569_();
        }
    }

    public class FireGunAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public FireGunAttackGoal(RangedAttackMob pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius) {
            this(pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackInterval, pAttackRadius);
        }

        public FireGunAttackGoal(RangedAttackMob pRangedAttackMob, double pSpeedModifier, int pAttackIntervalMin, int pAttackIntervalMax, float pAttackRadius) {
            if (!(pRangedAttackMob instanceof LivingEntity)) {
                throw new IllegalArgumentException("FireGunAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackMob = pRangedAttackMob;
            this.mob = (Mob)pRangedAttackMob;
            this.speedModifier = pSpeedModifier;
            this.attackIntervalMin = pAttackIntervalMin;
            this.attackIntervalMax = pAttackIntervalMax;
            this.attackRadius = pAttackRadius;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            SangheiliFormEntity.this.renderMuzzleFlash(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    SangheiliFormEntity.this.renderMuzzleFlash(false);
                    return;
                }
                SangheiliFormEntity.this.renderMuzzleFlash(true);
                if (SangheiliFormEntity.this.isHoldingGun()) {
                    SangheiliFormEntity.this.poseHand(true);
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.m_6504_(this.target, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            } else {
                SangheiliFormEntity.this.renderMuzzleFlash(false);
            }
        }
    }
}

