/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom.special;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.teamabyssalofficial.registry.EntityRegistry;

public class IronAxeEntity
extends AbstractArrow {
    protected static final int EXPIRE_TIME = 2400;
    private ItemStack hatchetStack = new ItemStack((ItemLike)Items.f_42386_);
    private boolean dealtDamage;

    public IronAxeEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IronAxeEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)EntityRegistry.IRON_AXE_ENTITY.get(), owner, world);
        this.hatchetStack = stack.m_41777_();
    }

    protected boolean m_5603_(Entity pTarget) {
        return super.m_5603_(pTarget) && pTarget != this.m_19749_();
    }

    public void m_6043_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!serverLevel.m_7726_().f_8325_.m_143145_().m_183913_(this.m_146902_().m_45588_())) {
                this.m_146870_();
            }
        }
    }

    public void m_8119_() {
        if (this.f_19797_ > 2400) {
            this.m_146870_();
            return;
        }
        this.handleHitDetection();
        super.m_8119_();
    }

    public void handleHitDetection() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.dealtDamage) {
            return false;
        }
        return super.m_7337_(pEntity);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        float f = 8.0f;
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, this.m_19749_() != null ? this.m_19749_() : null);
            livingEntity.m_6469_(damageSource, f += EnchantmentHelper.m_44833_((ItemStack)this.hatchetStack, (MobType)livingEntity.m_6336_()));
            livingEntity.m_6703_((LivingEntity)this.m_19749_());
            if (entity instanceof Player && (player = (Player)entity).m_21254_()) {
                player.m_36384_(true);
            }
        }
        this.dealtDamage = true;
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Hatchet", 10)) {
            this.hatchetStack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Hatchet"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
        this.f_19797_ = pCompound.m_128451_("Age");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Hatchet", (Tag)this.hatchetStack.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
        pCompound.m_128405_("Age", this.f_19797_);
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)Items.f_42386_);
    }

    public float getAgeException() {
        return 2.2f;
    }

    public boolean m_6087_() {
        return true;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42386_);
    }
}

