/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.event;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.guns.event.TickingEaser;

public class RotationScaler {
    private double previousYaw;
    private double targetYawTiltAngle;
    private double previousPitch;
    private double targetPitchTiltAngle;
    private double maxTiltAngle;
    private double tiltFactor;
    private double smoothingFactor;
    private double dampingFactor = 0.01;
    private float threshold = 0.01f;
    private long lastUpdateTime = System.nanoTime();
    private double roll;
    private double pitch;
    private double yaw;
    private float dynamicModifier;
    private TickingEaser dynamicModifierEaser = new TickingEaser(1000L);

    public RotationScaler(double tiltFactor, double smoothingFactor, double maxTiltAngle) {
        this.tiltFactor = tiltFactor;
        this.smoothingFactor = smoothingFactor;
        this.maxTiltAngle = maxTiltAngle;
        this.reset();
    }

    public void onUpdateState(LivingEntity player) {
        long currentTime = System.nanoTime();
        double deltaTime = (double)(currentTime - this.lastUpdateTime) / 1.0E9;
        this.lastUpdateTime = currentTime;
        float currentYaw = player.m_146908_();
        double deltaYaw = (double)currentYaw - this.previousYaw;
        double yawTurnSpeed = deltaYaw / deltaTime;
        float currentPitch = player.m_146909_();
        double deltaPitch = (double)currentPitch - this.previousPitch;
        double pitchTurnSpeed = deltaPitch / deltaTime;
        double scaledTiltFactor = this.tiltFactor * (double)this.dynamicModifierEaser.update(this.dynamicModifier);
        double yawInterpolationSpeed = this.smoothingFactor * deltaTime;
        ItemStack itemStack = player.m_21205_();
        if (Math.abs(yawTurnSpeed) >= (double)this.threshold) {
            this.targetYawTiltAngle = yawTurnSpeed * (itemStack.m_41784_().m_128471_("isAiming") ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetYawTiltAngle *= this.dampingFactor;
            yawInterpolationSpeed *= 30.0;
        }
        double pitchInterpolationSpeed = this.smoothingFactor * deltaTime;
        if (Math.abs(pitchTurnSpeed) >= (double)this.threshold) {
            this.targetPitchTiltAngle = pitchTurnSpeed * (itemStack.m_41784_().m_128471_("isAiming") ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetPitchTiltAngle *= this.dampingFactor;
            pitchInterpolationSpeed *= 30.0;
        }
        this.targetYawTiltAngle = Mth.m_14008_((double)this.targetYawTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.targetPitchTiltAngle = Mth.m_14008_((double)this.targetPitchTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.yaw += (this.targetYawTiltAngle - this.yaw) * yawInterpolationSpeed;
        this.pitch += (this.targetPitchTiltAngle - this.pitch) * pitchInterpolationSpeed;
        this.roll += (this.targetYawTiltAngle - this.roll) * yawInterpolationSpeed;
        this.previousYaw = currentYaw;
        this.previousPitch = currentPitch;
    }

    public void onRenderTick(LivingEntity player, ItemStack itemStack, ItemDisplayContext itemDisplayContext, float partialTicks) {
    }

    public void reset() {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = 0.0;
        this.previousPitch = 0.0;
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public void reset(Player player) {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = player.m_146908_();
        this.previousPitch = player.m_146909_();
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public double getRoll() {
        return this.roll;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    void setTiltFactor(double tiltFactor) {
        this.tiltFactor = tiltFactor;
    }

    void setSmoothingFactor(double smoothingFactor) {
        this.smoothingFactor = smoothingFactor;
    }

    void setMaxTiltAngle(double maxTiltAngle) {
        this.maxTiltAngle = maxTiltAngle;
    }

    public void setDynamicModifier(float dynamicModifier) {
        if (dynamicModifier < this.dynamicModifier) {
            this.dynamicModifierEaser.update(dynamicModifier, true);
        }
        this.dynamicModifier = dynamicModifier;
    }
}

