/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoPlayerAnimated;
import net.teamabyssalofficial.client.weapon.renderer.EnergySwordRenderer;
import net.teamabyssalofficial.dotf.DawnOfTheFlood;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.item.RenderedHandsItem;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.PerformanceEngine;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class EnergySwordItem
extends RenderedHandsItem
implements GeoAnimatable,
GeoItem {
    private final float damage;
    private final float reach;
    private final String description;
    public static final int ATTACK1_TICKS = 11;
    public static final int ATTACK2_TICKS = 11;
    public static final int ATTACK3_TICKS = 8;
    public static final int DRAW_TICKS = 15;
    public static final byte ATTACK_NONE = 0;
    public static final byte ATTACK1 = 1;
    public static final byte ATTACK2 = 2;
    public static final byte ATTACK3 = 3;
    private int drawTick;
    protected final AnimatableInstanceCache animationCache;

    public EnergySwordItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1).setNoRepair().m_41497_(Rarity.RARE));
        this.damage = new SAT(((Double)DawnOfTheFloodConfig.SERVER.energy_sword_damage.get()).floatValue()).get();
        this.reach = new SAT(((Double)DawnOfTheFloodConfig.SERVER.energy_sword_reach.get()).floatValue()).get();
        this.description = new Description("The Type-1 Energy Weapon/Sword, commonly known as the Energy Sword, is a close-quarters weapon of the Covenant Empire, for exclusive use of the Sangheili.").get();
        this.drawTick = 0;
        this.animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    private void setDefaultNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("attackTick", 0);
        nbtCompound.m_128344_("attackID", (byte)0);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        this.setDefaultNBT(pStack);
        if (pLevel instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel));
            this.triggerAnim((Entity)pPlayer, id, "controller", "idle.base");
        }
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Damage: " + this.getDamage())).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Entity Reach: " + this.getEntityReach())).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Description: " + this.getDesc())).m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"Press Shift to see stats").m_130940_(ChatFormatting.DARK_AQUA));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        ItemStack mainHandGun = ((Player)entity).m_21205_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        if (nbtCompound.m_128451_("attackTick") > 0) {
            nbtCompound.m_128405_("attackTick", nbtCompound.m_128451_("attackTick") - 1);
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (world.f_46443_) {
            FriendlyByteBuf bufA;
            Minecraft client = Minecraft.m_91087_();
            Options options = client.f_91066_;
            boolean canAnimate = options.m_92176_().m_90612_();
            this.updateBooleanTag(nbtCompound, "isDrawing", nbtCompound.m_128471_("isDrawn"));
            if (nbtCompound.m_128471_("isDrawing") && nbtCompound.m_128451_("drawnTick") < 15) {
                ++this.drawTick;
                nbtCompound.m_128405_("drawnTick", this.drawTick);
            }
            if (id == GeoItem.getId((ItemStack)((Player)entity).m_21205_())) {
                if (!nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128379_("isDrawn", true);
                }
                if (nbtCompound.m_128471_("isDrawing") && canAnimate) {
                    this.handleDrawingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController);
                }
            } else if (GeoItem.getId((ItemStack)((Player)entity).m_21205_()) != id) {
                if (nbtCompound.m_128471_("isDrawn")) {
                    nbtCompound.m_128473_("isDrawn");
                    nbtCompound.m_128473_("drawnTick");
                    this.drawTick = 0;
                }
                animationController.tryTriggerAnimation("idle.base");
            }
            if (animationController.getCurrentRawAnimation() != Animations.IDLE_BASE && !canAnimate) {
                animationController.tryTriggerAnimation("idle.base");
            }
            if (mainHandGun == stack && KeybindHelper.getShootMapping().m_90857_() && nbtCompound.m_128451_("drawnTick") >= 15) {
                int rand = ((Player)entity).m_217043_().m_188503_(10);
                bufA = PacketByteBufs.create();
                boolean canPlayAnim = animationController.getCurrentRawAnimation() != Animations.SWING1 && animationController.getCurrentRawAnimation() != Animations.SWING2 && animationController.getCurrentRawAnimation() != Animations.SWING3;
                boolean handSide = ((Player)entity).m_217043_().m_188499_();
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing1");
                        }
                        bufA.writeInt(11);
                        bufA.writeByte(1);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_ENERGY_SWORD_ATTACK, (FriendlyByteBuf)bufA);
                        GeckoPlayerAnimated.playAnimation((Player)entity, "energy_sword_swing1", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 0.85f);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing2");
                        }
                        bufA.writeInt(11);
                        bufA.writeByte(2);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_ENERGY_SWORD_ATTACK, (FriendlyByteBuf)bufA);
                        GeckoPlayerAnimated.playAnimation((Player)entity, "energy_sword_swing2", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 0.85f);
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (!canPlayAnim) break;
                        if (canAnimate) {
                            animationController.tryTriggerAnimation("swing3");
                        }
                        bufA.writeInt(8);
                        bufA.writeByte(3);
                        ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_ENERGY_SWORD_ATTACK, (FriendlyByteBuf)bufA);
                        GeckoPlayerAnimated.playAnimation((Player)entity, "energy_sword_swing3", GeckoPlayer.Perspective.THIRD_PERSON, Animation.LoopType.PLAY_ONCE, 1.05f);
                    }
                }
            }
            if (mainHandGun == stack && !((Player)entity).m_5833_()) {
                int hitTick;
                int n = hitTick = this.isPushAttack(stack) ? 5 : 2;
                if (nbtCompound.m_128451_("attackTick") == hitTick) {
                    bufA = PacketByteBufs.create();
                    ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.C2S_ENERGY_SWORD_DAMAGE, (FriendlyByteBuf)bufA);
                }
            }
        }
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    private void handleDrawingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController) {
        if (nbt.m_128451_("drawnTick") < 15) {
            animationController.tryTriggerAnimation("load");
        }
    }

    public boolean isPushAttack(ItemStack stack) {
        return stack.m_41784_().m_128445_("attackID") == 3;
    }

    public void attack(Player player, ItemStack stack) {
        float extra = this.isPushAttack(stack) ? 3.5f : 3.0f;
        float reach = this.isPushAttack(stack) ? this.getEntityReach() / 2.0f : this.getEntityReach();
        AABB boundingBox = player.m_20191_().m_82400_((double)reach);
        List entities = player.m_9236_().m_45933_((Entity)player, boundingBox);
        for (Entity entity : entities) {
            Player player1;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity) instanceof Villager || livingEntity instanceof IronGolem) continue;
            if (livingEntity instanceof Player && !player.m_7099_(player1 = (Player)livingEntity)) {
                return;
            }
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                if (!PerformanceEngine.hasPerformanceModeOn()) {
                    AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getWeaponSmoke().clone().scale(0.15f).position(livingEntity.m_20208_(0.25), livingEntity.m_20188_() - 0.1, livingEntity.m_20262_(0.25)));
                }
            }
            if (livingEntity.m_217043_().m_188503_(10) == 0 && EntityRegistry.FLOOD_FORMS.contains(livingEntity)) {
                livingEntity.m_6469_(livingEntity.m_269291_().m_269075_(player), Float.MAX_VALUE);
            }
            float dist = player.m_20270_((Entity)livingEntity);
            float f = player.m_21023_(MobEffects.f_19600_) ? (float)Objects.requireNonNull(player.m_21124_(MobEffects.f_19600_)).m_19564_() : 1.0f;
            livingEntity.m_6469_(livingEntity.m_269291_().m_269075_(player), this.getDamage() * (1.0f / dist) * f * extra);
            livingEntity.m_9236_().m_5594_((Player)null, livingEntity.m_20183_(), (SoundEvent)SoundRegistry.ENERGY_SWORD_DAMAGE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            livingEntity.f_20883_ = livingEntity.f_20885_;
            float f1 = (float)Math.cos(Math.toRadians(player.m_146908_() + 90.0f)) * 2.0f;
            float f2 = (float)Math.sin(Math.toRadians(player.m_146908_() + 90.0f)) * 2.0f;
            float res = (float)Objects.requireNonNull(livingEntity.m_21051_(Attributes.f_22278_)).m_22115_();
            float resistance = res > 3.0f ? 1.0f / (res + 0.1f) : 1.0f;
            livingEntity.m_5997_((double)(f1 * resistance * player.m_217043_().m_188501_()) * 1.2 * (double)(1.0f / dist), 0.2 * (double)player.m_217043_().m_188501_() * (double)resistance, (double)(f2 * player.m_217043_().m_188501_()) * 1.2 * (double)resistance * (double)(1.0f / dist));
            livingEntity.f_19864_ = true;
            if (!(livingEntity instanceof BodyEntity)) continue;
            BodyEntity bodyEntity = (BodyEntity)livingEntity;
            bodyEntity.vanish();
            bodyEntity.m_146870_();
        }
        if (this.isPushAttack(stack)) {
            float partialTicks = 0.99f;
            partialTicks *= partialTicks;
            float delta = (float)player.f_19797_ / 100.0f;
            if ((delta = 1.0f - delta) > partialTicks * 10.0f) {
                delta /= 4.0f;
            }
            float newCount = 1.0f - Mth.m_14154_((float)(partialTicks - delta));
            double angleX = player.m_20154_().f_82479_ + player.m_217043_().m_188500_() / (double)(partialTicks + newCount) / 1.0;
            double angleY = player.m_20154_().f_82480_ + player.m_217043_().m_188500_() / (double)(partialTicks + newCount) / 2.0;
            double angleZ = player.m_20154_().f_82481_ + player.m_217043_().m_188500_() / (double)(partialTicks + newCount) / 2.0;
            Vec3 newAngle = new Vec3(angleX, angleY, angleZ);
            player.m_20256_(newAngle.m_82490_((double)partialTicks));
            player.f_19864_ = true;
        }
        stack.m_41784_().m_128344_("attackID", (byte)0);
    }

    public int m_142159_(ItemStack pStack) {
        return Objects.requireNonNull(ChatFormatting.AQUA.m_126665_());
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private EnergySwordRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new EnergySwordRenderer();
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<EnergySwordItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle.base");
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate).triggerableAnim("idle.noBase", Animations.IDLE_NOBASE).triggerableAnim("idle.base", Animations.IDLE_BASE).triggerableAnim("unload", Animations.UNLOAD).triggerableAnim("load", Animations.LOAD).triggerableAnim("swing1", Animations.SWING1).triggerableAnim("swing2", Animations.SWING2).triggerableAnim("swing3", Animations.SWING3);
        controller.setOverrideEasingType(EasingType.EASE_IN_OUT_SINE);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    private void soundListener(SoundKeyframeEvent<EnergySwordItem> energySwordItemSoundKeyframeEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            switch (energySwordItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "load": {
                    player.m_5496_((SoundEvent)SoundRegistry.ENERGY_SWORD_READY.get(), 1.0f, 1.0f);
                    break;
                }
                case "unload": {
                    player.m_5496_(SoundEvents.f_271165_, 1.0f, 1.0f);
                    break;
                }
                case "swing": {
                    player.m_5496_((SoundEvent)SoundRegistry.ENERGY_SWORD_SWING.get(), 1.25f, 1.0f);
                }
            }
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public float getEntityReach() {
        return this.reach;
    }

    public String getDesc() {
        return this.description;
    }

    protected class SAT {
        protected final float SAT;

        protected SAT(float SAT2) {
            this.SAT = SAT2;
        }

        public float get() {
            return this.SAT;
        }
    }

    protected class Description {
        protected final String DESCRIPTION;

        protected Description(String DESCRIPTION) {
            this.DESCRIPTION = DESCRIPTION;
        }

        public String get() {
            return this.DESCRIPTION;
        }
    }

    public static class Animations {
        public static final RawAnimation IDLE_NOBASE = RawAnimation.begin().thenLoop("idle.noBase");
        public static final RawAnimation IDLE_BASE = RawAnimation.begin().thenLoop("idle.base");
        public static final RawAnimation LOAD = RawAnimation.begin().then("load", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation UNLOAD = RawAnimation.begin().then("unload", Animation.LoopType.HOLD_ON_LAST_FRAME);
        public static final RawAnimation SWING1 = RawAnimation.begin().then("swing1", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation SWING2 = RawAnimation.begin().then("swing2", Animation.LoopType.PLAY_ONCE);
        public static final RawAnimation SWING3 = RawAnimation.begin().then("swing3", Animation.LoopType.PLAY_ONCE);
    }
}

