/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.guns.bullet.BulletProjectileEntity;
import net.teamabyssalofficial.util.NeedlerSpike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements NeedlerSpike {
    private DamageSource source;
    @Unique
    private static final EntityDataAccessor<Integer> NEEDLER_SPIKES = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void capture(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.source = source;
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), index=0)
    private double modifyApplyKnockbackArgs(double original) {
        if (this.source.m_7639_() instanceof AbstractBullet || this.source.m_7639_() instanceof BulletProjectileEntity) {
            return (Double)DawnOfTheFloodConfig.SERVER.gun_bullet_knockback.get();
        }
        return original;
    }

    @Unique
    private SynchedEntityData dataTracker() {
        return ((LivingEntity)this).m_20088_();
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128405_("NeedlerSpikes", this.IgetNeedlerSpikesShot());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("NeedlerSpikes")) {
            this.IsetNeedlerSpikesShot(nbt.m_128451_("NeedlerSpikes"));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    private void defineSynchedData(CallbackInfo ci) {
        this.dataTracker().m_135372_(NEEDLER_SPIKES, (Object)0);
    }

    @Override
    public int IgetNeedlerSpikesShot() {
        return (Integer)this.dataTracker().m_135370_(NEEDLER_SPIKES);
    }

    @Override
    public void IsetNeedlerSpikesShot(int i) {
        this.dataTracker().m_135381_(NEEDLER_SPIKES, (Object)i);
    }
}

