/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.SoundPacket;

public class BlockUtils {
    public static BlockPos posFromCoords(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static BlockPos posFromVec3i(Vec3i vec3i) {
        return new BlockPos(vec3i);
    }

    public static void generateBlood(Level level, BlockPos blockpos) {
        BlockState blockState = level.m_8055_(blockpos);
        BlockState above = level.m_8055_(blockpos.m_7494_());
        BlockState east = level.m_8055_(blockpos.m_122029_());
        BlockState west = level.m_8055_(blockpos.m_122024_());
        int randomNextInt = level.f_46441_.m_188503_(10);
        if (Math.random() <= 0.25) {
            level.m_5594_(null, blockpos, (SoundEvent)SoundRegistry.BLOOD_SPILL.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
        }
        if (!level.m_5776_() && blockState.m_60804_((BlockGetter)level, blockpos) && above.m_60795_() && Math.random() < 0.9) {
            switch (randomNextInt) {
                case 0: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && west.m_60795_()) {
                        level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !east.m_60795_()) break;
                    level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH3.get()).m_49966_(), 3);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    level.m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && east.m_60795_()) {
                        level.m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !west.m_60795_()) break;
                    level.m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH4.get()).m_49966_(), 3);
                }
            }
        }
    }

    public static void destroyBlocks(Level level, LivingEntity entity, double area, int destroySpeed, int randChance, SoundPacket soundPacket) {
        if (entity.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            boolean flag = false;
            AABB aabb = entity.m_20191_().m_82400_(area);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (level.f_46441_.m_188503_(randChance) != 0 || !(blockstate.m_60800_((BlockGetter)level, blockpos) < (float)destroySpeed) || !(blockstate.m_60800_((BlockGetter)level, blockpos) >= 0.0f)) continue;
                level.m_5594_((Player)null, entity.m_20183_(), soundPacket.getSoundEvent(), soundPacket.getSoundSource(), soundPacket.getVolume(), soundPacket.getPitch());
                flag = level.m_46953_(blockpos, false, (Entity)entity) || flag;
            }
        }
    }
}

