/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.util;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;

public class WorldDataUtils
extends SavedData {
    private int score;
    private int wave;
    private int endermanTicks;
    private boolean hasWaveStarted;

    public int getScore() {
        this.m_77762_();
        return this.score;
    }

    public void setScore(int score) {
        this.score = score < 0 ? 0 : score;
        this.m_77762_();
    }

    public int getWave() {
        this.m_77762_();
        if (this.getScore() >= 0 && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave1_points.get()) {
            this.wave = 0;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave1_points.get() && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave2_points.get()) {
            this.wave = 1;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave2_points.get() && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave3_points.get()) {
            this.wave = 2;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave3_points.get() && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave4_points.get()) {
            this.wave = 3;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave4_points.get() && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave5_points.get()) {
            this.wave = 4;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave5_points.get() && this.getScore() < (Integer)DawnOfTheFloodConfig.DATAGEN.wave6_points.get()) {
            this.wave = 5;
        } else if (this.getScore() >= (Integer)DawnOfTheFloodConfig.DATAGEN.wave6_points.get()) {
            this.wave = 6;
        }
        return this.wave;
    }

    public void setWave(int wave) {
        switch (wave) {
            case 0: {
                this.setScore(0);
                break;
            }
            case 1: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave1_points.get());
                break;
            }
            case 2: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave2_points.get());
                break;
            }
            case 3: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave3_points.get());
                break;
            }
            case 4: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave4_points.get());
                break;
            }
            case 5: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave5_points.get());
                break;
            }
            case 6: {
                this.setScore((Integer)DawnOfTheFloodConfig.DATAGEN.wave6_points.get());
                break;
            }
            default: {
                this.setScore(0);
            }
        }
        this.wave = wave;
        this.m_77762_();
    }

    public int getMaxWave() {
        return 6;
    }

    public int getEndermanTicks() {
        this.m_77762_();
        return this.endermanTicks;
    }

    public void setEndermanTicks(int ticks) {
        this.endermanTicks = ticks < 0 ? 0 : ticks;
        this.m_77762_();
    }

    public void tick(ServerLevel world) {
        if (this.getEndermanTicks() > 0) {
            this.setEndermanTicks(this.getEndermanTicks() - 1);
        }
    }

    public void waveHandlerEvent(ServerLevel world, ServerPlayer player) {
        if (this.getWave() > 0 && !this.hasWaveStarted) {
            this.hasWaveStarted = true;
            player.m_213846_((Component)Component.m_237113_((String)"They're here.").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED}));
            player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)SoundRegistry.SHIP_EVENT.get(), SoundSource.MASTER, 1.2f, 1.0f);
            CovenantOrsShipEntity ship = (CovenantOrsShipEntity)((EntityType)EntityRegistry.COVENANT_FLOODED_SHIP.get()).m_20615_((Level)world);
            if (ship != null) {
                ship.m_6034_(player.m_20185_() - 64.0 + (double)player.m_217043_().m_188503_(128), 500.0, player.m_20189_() - 64.0 + (double)player.m_217043_().m_188503_(128));
                world.m_7967_((Entity)ship);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("score", this.score);
        nbt.m_128405_("wave", this.wave);
        nbt.m_128379_("hasWaveStarted", this.hasWaveStarted);
        return nbt;
    }

    public static WorldDataUtils fromNBT(CompoundTag nbt) {
        WorldDataUtils worldDataRegistry = new WorldDataUtils();
        worldDataRegistry.score = nbt.m_128451_("score");
        worldDataRegistry.wave = nbt.m_128451_("wave");
        worldDataRegistry.hasWaveStarted = nbt.m_128471_("hasWaveStarted");
        return worldDataRegistry;
    }

    public static WorldDataUtils getWorldDataRegistry(ServerLevel world) {
        WorldDataUtils WorldDataRegistry = (WorldDataUtils)world.m_8895_().m_164861_(WorldDataUtils::fromNBT, WorldDataUtils::new, "dotf");
        WorldDataRegistry.m_77762_();
        return WorldDataRegistry;
    }
}

