/*
 * Decompiled with CFR 0.152.
 */
package net.fabridge.fabricmc.keybind;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;

public final class KeyBindingRegistryImpl {
    private static final List<KeyMapping> MODDED_KEY_BINDINGS = new ReferenceArrayList();

    private KeyBindingRegistryImpl() {
    }

    public static KeyMapping registerKeyBinding(KeyMapping binding) {
        for (KeyMapping existingKeyBindings : MODDED_KEY_BINDINGS) {
            if (existingKeyBindings == binding) {
                throw new IllegalArgumentException("Attempted to register a key binding twice: " + binding.m_90863_());
            }
            if (!existingKeyBindings.m_90863_().equals(binding.m_90863_())) continue;
            throw new IllegalArgumentException("Attempted to register two key bindings with equal ID: " + binding.m_90863_() + "!");
        }
        MODDED_KEY_BINDINGS.add(binding);
        return binding;
    }

    public static KeyMapping[] process(KeyMapping[] keysAll) {
        ArrayList newKeysAll = Lists.newArrayList((Object[])keysAll);
        newKeysAll.removeAll(MODDED_KEY_BINDINGS);
        newKeysAll.addAll(MODDED_KEY_BINDINGS);
        return newKeysAll.toArray(new KeyMapping[0]);
    }

    static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        MODDED_KEY_BINDINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }
}

