/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.api.client.effekseer;

import java.util.Objects;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerManager;
import org.jetbrains.annotations.Nullable;

public class ParticleEmitter {
    public final int handle;
    public final Type type;
    public boolean isVisible = true;
    public boolean isPaused = false;
    private final EffekseerManager manager;
    @Nullable
    private PreDrawCallback callback;

    protected ParticleEmitter(int handle, EffekseerManager manager, Type type) {
        this.handle = handle;
        this.manager = manager;
        this.type = type;
        this.setVisibility(true);
        this.resume();
    }

    public void pause() {
        this.manager.getImpl().SetPaused(this.handle, true);
        this.isPaused = true;
    }

    public void resume() {
        this.manager.getImpl().SetPaused(this.handle, false);
        this.isPaused = false;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisibility(boolean visible) {
        this.manager.getImpl().SetShown(this.handle, visible);
        this.isVisible = visible;
    }

    public void stop() {
        this.manager.getImpl().Stop(this.handle);
    }

    public void setProgress(float frame) {
        this.manager.getImpl().UpdateHandleToMoveToFrame(this.handle, frame);
    }

    public void setPosition(float x, float y, float z) {
        this.manager.getImpl().SetEffectPosition(this.handle, x, y, z);
    }

    public void setRotation(float x, float y, float z) {
        this.manager.getImpl().SetEffectRotation(this.handle, x, y, z);
    }

    public void setScale(float x, float y, float z) {
        this.manager.getImpl().SetEffectScale(this.handle, x, y, z);
    }

    public void setTransformMatrix(float[] matrix) {
        this.manager.getImpl().SetEffectTransformMatrix(this.handle, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], matrix[6], matrix[7], matrix[8], matrix[9], matrix[10], matrix[11]);
    }

    public void setTransformMatrix(float[][] matrix) {
        int i = 0;
        this.manager.getImpl().SetEffectTransformMatrix(this.handle, matrix[i][0], matrix[i][1], matrix[i][2], matrix[i++][3], matrix[i][0], matrix[i][1], matrix[i][2], matrix[i++][3], matrix[i][0], matrix[i][1], matrix[i][2], matrix[i][3]);
    }

    public void setBaseTransformMatrix(float[] matrix) {
        this.manager.getImpl().SetEffectTransformBaseMatrix(this.handle, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], matrix[6], matrix[7], matrix[8], matrix[9], matrix[10], matrix[11]);
    }

    public void setBaseTransformMatrix(float[][] matrix) {
        int i = 0;
        this.manager.getImpl().SetEffectTransformBaseMatrix(this.handle, matrix[i][0], matrix[i][1], matrix[i][2], matrix[i++][3], matrix[i][0], matrix[i][1], matrix[i][2], matrix[i++][3], matrix[i][0], matrix[i][1], matrix[i][2], matrix[i][3]);
    }

    public boolean exists() {
        return this.manager.getImpl().Exists(this.handle);
    }

    public void setDynamicInput(int index, float value) {
        this.manager.getImpl().SetDynamicInput(this.handle, index, value);
    }

    public float getDynamicInput(int index) {
        return this.manager.getImpl().GetDynamicInput(this.handle, index);
    }

    public void sendTrigger(int index) {
        this.manager.getImpl().SendTrigger(this.handle, index);
    }

    public void addPreDrawCallback(PreDrawCallback callback) {
        Optional.ofNullable(this.callback).ifPresentOrElse(c -> {
            this.callback = this.callback.andThen((PreDrawCallback)c);
        }, () -> {
            this.callback = callback;
        });
    }

    public void runPreDrawCallbacks(float partial) {
        Optional.ofNullable(this.callback).ifPresent(c -> c.accept(this, partial));
    }

    public static enum Type {
        WORLD,
        FIRST_PERSON_MAINHAND,
        FIRST_PERSON_OFFHAND;

    }

    public static interface PreDrawCallback {
        public void accept(ParticleEmitter var1, float var2);

        default public PreDrawCallback andThen(PreDrawCallback after) {
            Objects.requireNonNull(after);
            return (emitter, partial) -> {
                this.accept(emitter, partial);
                after.accept(emitter, partial);
            };
        }
    }
}

