/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client;

import dev.architectury.registry.ReloadListenerRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import mod.chloeprime.aaaparticles.AAAParticles;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import mod.chloeprime.aaaparticles.client.Debug;
import mod.chloeprime.aaaparticles.client.installer.JarExtractor;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.loader.EffekAssetLoader;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AAAParticlesClient {
    public static void init() {
        AAAParticlesClient.installNativeLibrary();
        if (!NativePlatform.isDataGen()) {
            ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new EffekAssetLoader(), (ResourceLocation)AAAParticles.loc("effek"));
        }
        Debug.INSTANCE.registerDebugHooks();
    }

    public static void setup() {
    }

    private static void installNativeLibrary() {
        NativePlatform platform = NativePlatform.current();
        if (platform.isUnsupported()) {
            return;
        }
        String DLL_NAME = "EffekseerNativeForJava";
        File dll = platform.getNativeInstallPath(DLL_NAME);
        try {
            String resource = "assets/%s/%s".formatted("aaa_particles", platform.formatFileName(DLL_NAME));
            if (!dll.isFile()) {
                AAAParticles.LOGGER.info("Installing Effekseer native library at {}", (Object)dll.getCanonicalPath());
                JarExtractor.extract(resource, dll);
            } else {
                boolean updated = JarExtractor.update(resource, dll);
                if (updated) {
                    AAAParticles.LOGGER.info("Updating Effekseer native library at {}", (Object)dll.getCanonicalPath());
                } else {
                    AAAParticles.LOGGER.info("Loading Effekseer native library at {}", (Object)dll.getCanonicalPath());
                }
            }
            System.load(dll.getCanonicalPath());
        }
        catch (IOException | UnsatisfiedLinkError e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void addParticle(Level level, ParticleEmitterInfo info) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_9236_() != level) {
            return;
        }
        info.spawnInWorld(level, (Player)player);
    }

    public static void setParam(ParticleEmitter.Type type, ResourceLocation effek, ResourceLocation emitterName, DynamicParameter[] params) {
        Optional.ofNullable(EffectRegistry.get(effek)).flatMap(mng -> mng.getNamedEmitter(type, emitterName)).ifPresent(emitter -> {
            for (DynamicParameter param : params) {
                emitter.setDynamicInput(param.index(), param.value());
            }
        });
    }

    public static void sendTrigger(ParticleEmitter.Type type, ResourceLocation effek, ResourceLocation emitterName, int[] triggers) {
        Optional.ofNullable(EffectRegistry.get(effek)).flatMap(mng -> mng.getNamedEmitter(type, emitterName)).ifPresent(emitter -> Arrays.stream(triggers).forEach(emitter::sendTrigger));
    }
}

