/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.landofgoblins.network;

import java.util.function.Supplier;
import net.mcreator.landofgoblins.LandOfGoblinsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LandOfGoblinsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LandOfGoblinsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        LandOfGoblinsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.KillCountCreeptus = message.data.KillCountCreeptus;
                    variables.KillCountCrabtilus = message.data.KillCountCrabtilus;
                    variables.KillCountWitherFungus = message.data.KillCountWitherFungus;
                    variables.Creeptus = message.data.Creeptus;
                    variables.WitherFungus = message.data.WitherFungus;
                    variables.Crabtilus = message.data.Crabtilus;
                    variables.StunnedGlobal = message.data.StunnedGlobal;
                    variables.Catching = message.data.Catching;
                    variables.Swifty = message.data.Swifty;
                    variables.Enhanced = message.data.Enhanced;
                    variables.ShinyUndead = message.data.ShinyUndead;
                    variables.KillCountShinyUndead = message.data.KillCountShinyUndead;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double KillCountCreeptus = 0.0;
        public double KillCountCrabtilus = 0.0;
        public double KillCountWitherFungus = 0.0;
        public boolean Creeptus = false;
        public boolean WitherFungus = false;
        public boolean Crabtilus = false;
        public boolean StunnedGlobal = false;
        public boolean Catching = false;
        public boolean Swifty = false;
        public boolean Enhanced = false;
        public boolean ShinyUndead = false;
        public double KillCountShinyUndead = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("KillCountCreeptus", this.KillCountCreeptus);
            nbt.m_128347_("KillCountCrabtilus", this.KillCountCrabtilus);
            nbt.m_128347_("KillCountWitherFungus", this.KillCountWitherFungus);
            nbt.m_128379_("Creeptus", this.Creeptus);
            nbt.m_128379_("WitherFungus", this.WitherFungus);
            nbt.m_128379_("Crabtilus", this.Crabtilus);
            nbt.m_128379_("StunnedGlobal", this.StunnedGlobal);
            nbt.m_128379_("Catching", this.Catching);
            nbt.m_128379_("Swifty", this.Swifty);
            nbt.m_128379_("Enhanced", this.Enhanced);
            nbt.m_128379_("ShinyUndead", this.ShinyUndead);
            nbt.m_128347_("KillCountShinyUndead", this.KillCountShinyUndead);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.KillCountCreeptus = nbt.m_128459_("KillCountCreeptus");
            this.KillCountCrabtilus = nbt.m_128459_("KillCountCrabtilus");
            this.KillCountWitherFungus = nbt.m_128459_("KillCountWitherFungus");
            this.Creeptus = nbt.m_128471_("Creeptus");
            this.WitherFungus = nbt.m_128471_("WitherFungus");
            this.Crabtilus = nbt.m_128471_("Crabtilus");
            this.StunnedGlobal = nbt.m_128471_("StunnedGlobal");
            this.Catching = nbt.m_128471_("Catching");
            this.Swifty = nbt.m_128471_("Swifty");
            this.Enhanced = nbt.m_128471_("Enhanced");
            this.ShinyUndead = nbt.m_128471_("ShinyUndead");
            this.KillCountShinyUndead = nbt.m_128459_("KillCountShinyUndead");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("land_of_goblins", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "land_of_goblins_mapvars";
        public boolean PlayerAttackedShinyUndeadPowerCenter = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.PlayerAttackedShinyUndeadPowerCenter = nbt.m_128471_("PlayerAttackedShinyUndeadPowerCenter");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("PlayerAttackedShinyUndeadPowerCenter", this.PlayerAttackedShinyUndeadPowerCenter);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "land_of_goblins_worldvars";
        public boolean CreeptusCollide = false;
        public double CreeptusVisualScale = 1.35;
        public boolean Stunned = false;
        public boolean CrabtilusShell = false;
        public boolean LesslifeWitherFungus = false;
        public boolean WitherFungusOneTime = false;
        public boolean AdvancementLandofGoblins = false;
        public boolean MagmaSwordBroken = false;
        public double ParticlesMagmaSwordBrokenRadius = 0.0;
        public double ParticlesMagmaSwordBrokenAmount = 0.0;
        public double EnhancedAddition = 0.0;
        public boolean NoOtherAnimationWF = false;
        public double WFRottenAttackCooldown = 0.0;
        public boolean WFRottenAttackParticles = false;
        public double WFBuffDamage = 0.0;
        public double WFComboAttack1Cooldown = 0.0;
        public double WFComboAttack2Cooldown = 0.0;
        public double CRAttack2Cooldown = 0.0;
        public boolean NoOtherAnimationSU = false;
        public double SUAmethystAttackCooldown = 0.0;
        public boolean ShinyUndeadTotem = false;
        public boolean CrabtilusTotem = false;
        public boolean WitherFungusTotem = false;
        public boolean CreeptusTotem = false;
        public boolean PlayerShield = false;
        public boolean ShinyUndeadPowerCenterActivation = false;
        public boolean NoOtherAnimationCR = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.CreeptusCollide = nbt.m_128471_("CreeptusCollide");
            this.CreeptusVisualScale = nbt.m_128459_("CreeptusVisualScale");
            this.Stunned = nbt.m_128471_("Stunned");
            this.CrabtilusShell = nbt.m_128471_("CrabtilusShell");
            this.LesslifeWitherFungus = nbt.m_128471_("LesslifeWitherFungus");
            this.WitherFungusOneTime = nbt.m_128471_("WitherFungusOneTime");
            this.AdvancementLandofGoblins = nbt.m_128471_("AdvancementLandofGoblins");
            this.MagmaSwordBroken = nbt.m_128471_("MagmaSwordBroken");
            this.ParticlesMagmaSwordBrokenRadius = nbt.m_128459_("ParticlesMagmaSwordBrokenRadius");
            this.ParticlesMagmaSwordBrokenAmount = nbt.m_128459_("ParticlesMagmaSwordBrokenAmount");
            this.EnhancedAddition = nbt.m_128459_("EnhancedAddition");
            this.NoOtherAnimationWF = nbt.m_128471_("NoOtherAnimationWF");
            this.WFRottenAttackCooldown = nbt.m_128459_("WFRottenAttackCooldown");
            this.WFRottenAttackParticles = nbt.m_128471_("WFRottenAttackParticles");
            this.WFBuffDamage = nbt.m_128459_("WFBuffDamage");
            this.WFComboAttack1Cooldown = nbt.m_128459_("WFComboAttack1Cooldown");
            this.WFComboAttack2Cooldown = nbt.m_128459_("WFComboAttack2Cooldown");
            this.CRAttack2Cooldown = nbt.m_128459_("CRAttack2Cooldown");
            this.NoOtherAnimationSU = nbt.m_128471_("NoOtherAnimationSU");
            this.SUAmethystAttackCooldown = nbt.m_128459_("SUAmethystAttackCooldown");
            this.ShinyUndeadTotem = nbt.m_128471_("ShinyUndeadTotem");
            this.CrabtilusTotem = nbt.m_128471_("CrabtilusTotem");
            this.WitherFungusTotem = nbt.m_128471_("WitherFungusTotem");
            this.CreeptusTotem = nbt.m_128471_("CreeptusTotem");
            this.PlayerShield = nbt.m_128471_("PlayerShield");
            this.ShinyUndeadPowerCenterActivation = nbt.m_128471_("ShinyUndeadPowerCenterActivation");
            this.NoOtherAnimationCR = nbt.m_128471_("NoOtherAnimationCR");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("CreeptusCollide", this.CreeptusCollide);
            nbt.m_128347_("CreeptusVisualScale", this.CreeptusVisualScale);
            nbt.m_128379_("Stunned", this.Stunned);
            nbt.m_128379_("CrabtilusShell", this.CrabtilusShell);
            nbt.m_128379_("LesslifeWitherFungus", this.LesslifeWitherFungus);
            nbt.m_128379_("WitherFungusOneTime", this.WitherFungusOneTime);
            nbt.m_128379_("AdvancementLandofGoblins", this.AdvancementLandofGoblins);
            nbt.m_128379_("MagmaSwordBroken", this.MagmaSwordBroken);
            nbt.m_128347_("ParticlesMagmaSwordBrokenRadius", this.ParticlesMagmaSwordBrokenRadius);
            nbt.m_128347_("ParticlesMagmaSwordBrokenAmount", this.ParticlesMagmaSwordBrokenAmount);
            nbt.m_128347_("EnhancedAddition", this.EnhancedAddition);
            nbt.m_128379_("NoOtherAnimationWF", this.NoOtherAnimationWF);
            nbt.m_128347_("WFRottenAttackCooldown", this.WFRottenAttackCooldown);
            nbt.m_128379_("WFRottenAttackParticles", this.WFRottenAttackParticles);
            nbt.m_128347_("WFBuffDamage", this.WFBuffDamage);
            nbt.m_128347_("WFComboAttack1Cooldown", this.WFComboAttack1Cooldown);
            nbt.m_128347_("WFComboAttack2Cooldown", this.WFComboAttack2Cooldown);
            nbt.m_128347_("CRAttack2Cooldown", this.CRAttack2Cooldown);
            nbt.m_128379_("NoOtherAnimationSU", this.NoOtherAnimationSU);
            nbt.m_128347_("SUAmethystAttackCooldown", this.SUAmethystAttackCooldown);
            nbt.m_128379_("ShinyUndeadTotem", this.ShinyUndeadTotem);
            nbt.m_128379_("CrabtilusTotem", this.CrabtilusTotem);
            nbt.m_128379_("WitherFungusTotem", this.WitherFungusTotem);
            nbt.m_128379_("CreeptusTotem", this.CreeptusTotem);
            nbt.m_128379_("PlayerShield", this.PlayerShield);
            nbt.m_128379_("ShinyUndeadPowerCenterActivation", this.ShinyUndeadPowerCenterActivation);
            nbt.m_128379_("NoOtherAnimationCR", this.NoOtherAnimationCR);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Creeptus = original.Creeptus;
            clone.WitherFungus = original.WitherFungus;
            clone.Crabtilus = original.Crabtilus;
            clone.Catching = original.Catching;
            clone.Swifty = original.Swifty;
            clone.Enhanced = original.Enhanced;
            clone.ShinyUndead = original.ShinyUndead;
            if (!event.isWasDeath()) {
                clone.KillCountCreeptus = original.KillCountCreeptus;
                clone.KillCountCrabtilus = original.KillCountCrabtilus;
                clone.KillCountWitherFungus = original.KillCountWitherFungus;
                clone.StunnedGlobal = original.StunnedGlobal;
                clone.KillCountShinyUndead = original.KillCountShinyUndead;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                LandOfGoblinsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

