/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.luminousworld.network.BeastBook3ButtonMessage;
import net.mcreator.luminousworld.procedures.ReturnMummyProcedure;
import net.mcreator.luminousworld.world.inventory.BeastBook3Menu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BeastBook3Screen
extends AbstractContainerScreen<BeastBook3Menu> {
    private static final HashMap<String, Object> guistate = BeastBook3Menu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    ImageButton imagebutton_rarrowoff;
    ImageButton imagebutton_larrowoff;

    public BeastBook3Screen(BeastBook3Menu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 100;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ReturnMummyProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 125, this.topPos + 134, 50, 0.0f + (float)Math.atan((double)(this.leftPos + 125 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 85 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(new ResourceLocation("luminousworld:textures/screens/beastgui.png"), this.leftPos + -111, this.topPos + -21, 0.0f, 0.0f, 320, 198, 320, 198);
        guiGraphics.blit(new ResourceLocation("luminousworld:textures/screens/bigwraps.png"), this.leftPos + -19, this.topPos + 4, 0.0f, 0.0f, 48, 58, 48, 58);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_treent"), -59, -12, -5334167, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_120_health"), -94, 4, -5334167, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_located_in_forest_biome"), -95, 15, -10467291, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_forest_biome"), -94, 24, -5334167, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_forest"), -94, 35, -10467291, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_drops"), -94, 46, -5334167, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_magic_root"), -94, 57, -10467291, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_enemies_become_slow_when"), -94, 75, -8627122, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_ability"), -93, 104, -5334167, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_immune_to"), -94, 85, -8627122, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_changes_attacks"), -93, 116, -8627122, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_3.label_change_his_attack_type"), -93, 127, -8627122, false);
    }

    public void init() {
        super.init();
        this.imagebutton_rarrowoff = new ImageButton(this.leftPos + 165, this.topPos + 148, 18, 10, new WidgetSprites(new ResourceLocation("luminousworld:textures/screens/rarrowoff.png"), new ResourceLocation("luminousworld:textures/screens/rarrowon.png")), e -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BeastBook3ButtonMessage(0, this.x, this.y, this.z)});
            BeastBook3ButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_rarrowoff", this.imagebutton_rarrowoff);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_rarrowoff);
        this.imagebutton_larrowoff = new ImageButton(this.leftPos + -87, this.topPos + 147, 18, 10, new WidgetSprites(new ResourceLocation("luminousworld:textures/screens/larrowoff.png"), new ResourceLocation("luminousworld:textures/screens/larrowon.png")), e -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BeastBook3ButtonMessage(1, this.x, this.y, this.z)});
            BeastBook3ButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_larrowoff", this.imagebutton_larrowoff);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_larrowoff);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (int)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

