/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.entity;

import javax.annotation.Nullable;
import net.mcreator.luminousworld.init.LuminousworldModEntities;
import net.mcreator.luminousworld.procedures.Frost2SpawnProcedure;
import net.mcreator.luminousworld.procedures.FrostGolem2EntityIsHurtProcedure;
import net.mcreator.luminousworld.procedures.FrostGolemEntityDiesProcedure;
import net.mcreator.luminousworld.procedures.StepHeightFixProcedure;
import net.mcreator.luminousworld.procedures.YetiTick2Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrostGolem2Entity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_JustAttacked = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Counter = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_HalfHp = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_stop = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_DontAttack = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_AttackNumber = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_AttackStage = SynchedEntityData.defineId(FrostGolem2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public FrostGolem2Entity(EntityType<FrostGolem2Entity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setMaxUpStep(0.6f);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(SHOOT, (Object)false);
        this.entityData.define(ANIMATION, (Object)"undefined");
        this.entityData.define(TEXTURE, (Object)"yet22");
        this.entityData.define(DATA_JustAttacked, (Object)false);
        this.entityData.define(DATA_Counter, (Object)0);
        this.entityData.define(DATA_HalfHp, (Object)false);
        this.entityData.define(DATA_stop, (Object)false);
        this.entityData.define(DATA_DontAttack, (Object)false);
        this.entityData.define(DATA_AttackNumber, (Object)0);
        this.entityData.define(DATA_AttackStage, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 9.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, ServerPlayer.class, 10.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this));
    }

    public MobType getMobType() {
        return MobType.UNDEFINED;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.ravager.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.ravager.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.ravager.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.ravager.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        FrostGolem2EntityIsHurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        FrostGolemEntityDiesProcedure.execute((LevelAccessor)this.level(), (Entity)this, source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata, tag);
        StepHeightFixProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataJustAttacked", ((Boolean)this.entityData.get(DATA_JustAttacked)).booleanValue());
        compound.putInt("DataCounter", ((Integer)this.entityData.get(DATA_Counter)).intValue());
        compound.putBoolean("DataHalfHp", ((Boolean)this.entityData.get(DATA_HalfHp)).booleanValue());
        compound.putBoolean("Datastop", ((Boolean)this.entityData.get(DATA_stop)).booleanValue());
        compound.putBoolean("DataDontAttack", ((Boolean)this.entityData.get(DATA_DontAttack)).booleanValue());
        compound.putInt("DataAttackNumber", ((Integer)this.entityData.get(DATA_AttackNumber)).intValue());
        compound.putInt("DataAttackStage", ((Integer)this.entityData.get(DATA_AttackStage)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataJustAttacked")) {
            this.entityData.set(DATA_JustAttacked, (Object)compound.getBoolean("DataJustAttacked"));
        }
        if (compound.contains("DataCounter")) {
            this.entityData.set(DATA_Counter, (Object)compound.getInt("DataCounter"));
        }
        if (compound.contains("DataHalfHp")) {
            this.entityData.set(DATA_HalfHp, (Object)compound.getBoolean("DataHalfHp"));
        }
        if (compound.contains("Datastop")) {
            this.entityData.set(DATA_stop, (Object)compound.getBoolean("Datastop"));
        }
        if (compound.contains("DataDontAttack")) {
            this.entityData.set(DATA_DontAttack, (Object)compound.getBoolean("DataDontAttack"));
        }
        if (compound.contains("DataAttackNumber")) {
            this.entityData.set(DATA_AttackNumber, (Object)compound.getInt("DataAttackNumber"));
        }
        if (compound.contains("DataAttackStage")) {
            this.entityData.set(DATA_AttackStage, (Object)compound.getInt("DataAttackStage"));
        }
    }

    public void baseTick() {
        super.baseTick();
        YetiTick2Procedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDimensions(Pose p_33597_) {
        return super.getDimensions(p_33597_).scale(1.0f);
    }

    public static void init() {
        SpawnPlacements.register((EntityType)((EntityType)LuminousworldModEntities.FROST_GOLEM_2.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return Frost2SpawnProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 120.0);
        builder = builder.add(Attributes.ARMOR, 5.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.8);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 40) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

