/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.entity;

import net.mcreator.luminousworld.init.LuminousworldModEntities;
import net.mcreator.luminousworld.procedures.Mummy2HurtProcedure;
import net.mcreator.luminousworld.procedures.Mummy2LookProcedure;
import net.mcreator.luminousworld.procedures.Mummy2SpawnProcedure;
import net.mcreator.luminousworld.procedures.Mummy2TickProcedure;
import net.mcreator.luminousworld.procedures.MummyEntityDiesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mummy2Entity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_IsChanging = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Change1 = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Change2 = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_stop = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_stop2 = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Phase1Over = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_SkinVariable = SynchedEntityData.defineId(Mummy2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public Mummy2Entity(EntityType<Mummy2Entity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setMaxUpStep(0.6f);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(SHOOT, (Object)false);
        this.entityData.define(ANIMATION, (Object)"undefined");
        this.entityData.define(TEXTURE, (Object)"mummygreen");
        this.entityData.define(DATA_IsChanging, (Object)false);
        this.entityData.define(DATA_Change1, (Object)0);
        this.entityData.define(DATA_Change2, (Object)0);
        this.entityData.define(DATA_stop, (Object)false);
        this.entityData.define(DATA_stop2, (Object)false);
        this.entityData.define(DATA_Phase1Over, (Object)false);
        this.entityData.define(DATA_SkinVariable, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 2.25 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canUse() && Mummy2LookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canContinueToUse() && Mummy2LookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canUse() && Mummy2LookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canContinueToUse() && Mummy2LookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canUse() && Mummy2LookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canContinueToUse() && Mummy2LookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canUse() && Mummy2LookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canContinueToUse() && Mummy2LookProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canUse() && Mummy2LookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Mummy2Entity.this.getX();
                double y = Mummy2Entity.this.getY();
                double z = Mummy2Entity.this.getZ();
                Mummy2Entity entity = Mummy2Entity.this;
                Level world = Mummy2Entity.this.level();
                return super.canContinueToUse() && Mummy2LookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
    }

    public MobType getMobType() {
        return MobType.UNDEAD;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.husk.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.husk.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.husk.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.husk.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        Mummy2HurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        MummyEntityDiesProcedure.execute((LevelAccessor)this.level(), (Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataIsChanging", ((Boolean)this.entityData.get(DATA_IsChanging)).booleanValue());
        compound.putInt("DataChange1", ((Integer)this.entityData.get(DATA_Change1)).intValue());
        compound.putInt("DataChange2", ((Integer)this.entityData.get(DATA_Change2)).intValue());
        compound.putBoolean("Datastop", ((Boolean)this.entityData.get(DATA_stop)).booleanValue());
        compound.putBoolean("Datastop2", ((Boolean)this.entityData.get(DATA_stop2)).booleanValue());
        compound.putBoolean("DataPhase1Over", ((Boolean)this.entityData.get(DATA_Phase1Over)).booleanValue());
        compound.putInt("DataSkinVariable", ((Integer)this.entityData.get(DATA_SkinVariable)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataIsChanging")) {
            this.entityData.set(DATA_IsChanging, (Object)compound.getBoolean("DataIsChanging"));
        }
        if (compound.contains("DataChange1")) {
            this.entityData.set(DATA_Change1, (Object)compound.getInt("DataChange1"));
        }
        if (compound.contains("DataChange2")) {
            this.entityData.set(DATA_Change2, (Object)compound.getInt("DataChange2"));
        }
        if (compound.contains("Datastop")) {
            this.entityData.set(DATA_stop, (Object)compound.getBoolean("Datastop"));
        }
        if (compound.contains("Datastop2")) {
            this.entityData.set(DATA_stop2, (Object)compound.getBoolean("Datastop2"));
        }
        if (compound.contains("DataPhase1Over")) {
            this.entityData.set(DATA_Phase1Over, (Object)compound.getBoolean("DataPhase1Over"));
        }
        if (compound.contains("DataSkinVariable")) {
            this.entityData.set(DATA_SkinVariable, (Object)compound.getInt("DataSkinVariable"));
        }
    }

    public void baseTick() {
        super.baseTick();
        Mummy2TickProcedure.execute((Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDimensions(Pose p_33597_) {
        return super.getDimensions(p_33597_).scale(1.2f);
    }

    public static void init() {
        SpawnPlacements.register((EntityType)((EntityType)LuminousworldModEntities.MUMMY_2.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return Mummy2SpawnProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 110.0);
        builder = builder.add(Attributes.ARMOR, 5.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 3.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isAggressive())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 70) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

