/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.item;

import com.google.common.collect.Iterables;
import java.util.List;
import net.mcreator.luminousworld.procedures.ShellmetHelmetTickEventProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class ShellmetItem
extends ArmorItem {
    public ShellmetItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 15;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{2, 5, 6, 2})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 0;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of();
            }

            public String getName() {
                return "shellmet";
            }

            public float getToughness() {
                return 1.0f;
            }

            public float getKnockbackResistance() {
                return 0.2f;
            }
        }, type, properties);
    }

    public static class Helmet
    extends ShellmetItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"\u00a76WEARABLE \u00a7e- \u00a7eWhile \u00a7ewearing, \u00a7ethe \u00a7euser \u00a7ecan \u00a7erun \u00a7equickly \u00a7eon \u00a7eall \u00a7esand \u00a7eand \u00a7ered \u00a7esand \u00a7eblock \u00a7etypes"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "luminousworld:textures/entities/shellmet_layer_1.png";
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                ShellmetHelmetTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }
}

