/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.core.networking.packets;

import com.deriys.divinerelics.items.HeimdallGauntlet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class GauntletParticleS2CPacket {
    private final double playerX;
    private final double playerY;
    private final double playerZ;
    private final double tpX;
    private final double tpZ;

    public GauntletParticleS2CPacket(double playerX, double playerY, double playerZ, double tpX, double tpZ) {
        this.playerX = playerX;
        this.playerY = playerY;
        this.playerZ = playerZ;
        this.tpX = tpX;
        this.tpZ = tpZ;
    }

    public GauntletParticleS2CPacket(FriendlyByteBuf buf) {
        this.playerX = buf.readDouble();
        this.playerY = buf.readDouble();
        this.playerZ = buf.readDouble();
        this.tpX = buf.readDouble();
        this.tpZ = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.playerX);
        buf.writeDouble(this.playerY);
        buf.writeDouble(this.playerZ);
        buf.writeDouble(this.tpX);
        buf.writeDouble(this.tpZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null) {
                HeimdallGauntlet.addTeleportParticles((Level)level, this.playerX, this.playerY, this.playerZ, this.tpX, this.tpZ);
            }
        });
        return true;
    }
}

