/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.core.networking.packets;

import com.deriys.divinerelics.items.DraupnirSpear;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SpearExplosionParticleS2CPacket {
    private final double spearX;
    private final double spearY;
    private final double spearZ;
    private final double factor;
    private final double yRandom;
    private final int quantity;

    public SpearExplosionParticleS2CPacket(double spearX, double spearY, double playerZ, double factor, double yRandom, int quantity) {
        this.spearX = spearX;
        this.spearY = spearY;
        this.spearZ = playerZ;
        this.factor = factor;
        this.yRandom = yRandom;
        this.quantity = quantity;
    }

    public SpearExplosionParticleS2CPacket(FriendlyByteBuf buf) {
        this.spearX = buf.readDouble();
        this.spearY = buf.readDouble();
        this.spearZ = buf.readDouble();
        this.factor = buf.readDouble();
        this.yRandom = buf.readDouble();
        this.quantity = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.spearX);
        buf.writeDouble(this.spearY);
        buf.writeDouble(this.spearZ);
        buf.writeDouble(this.factor);
        buf.writeDouble(this.yRandom);
        buf.writeInt(this.quantity);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null) {
                DraupnirSpear.spawnSpearExplosionParticles((Level)level, this.spearX, this.spearY, this.spearZ, this.factor, this.yRandom, this.quantity);
            }
        });
        return true;
    }
}

