/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.core.networking.packets;

import com.deriys.divinerelics.entities.entity.ThrownDraupnirSpear;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SpearParticleS2CPacket {
    private final double spearX;
    private final double spearY;
    private final double spearZ;
    private final double throwerX;
    private final double throwerY;
    private final double throwerZ;
    private final float pitch;
    private final float height;

    public SpearParticleS2CPacket(double spearX, double spearY, double playerZ, double throwerX, double throwerY, double throwerZ, float pitch, float height) {
        this.spearX = spearX;
        this.spearY = spearY;
        this.spearZ = playerZ;
        this.throwerX = throwerX;
        this.throwerY = throwerY;
        this.throwerZ = throwerZ;
        this.pitch = pitch;
        this.height = height;
    }

    public SpearParticleS2CPacket(FriendlyByteBuf buf) {
        this.spearX = buf.readDouble();
        this.spearY = buf.readDouble();
        this.spearZ = buf.readDouble();
        this.throwerX = buf.readDouble();
        this.throwerY = buf.readDouble();
        this.throwerZ = buf.readDouble();
        this.pitch = buf.readFloat();
        this.height = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.spearX);
        buf.writeDouble(this.spearY);
        buf.writeDouble(this.spearZ);
        buf.writeDouble(this.throwerX);
        buf.writeDouble(this.throwerY);
        buf.writeDouble(this.throwerZ);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.height);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null) {
                ThrownDraupnirSpear.spawnSpearParticles(level, this.spearX, this.spearY, this.spearZ, this.throwerX, this.throwerY, this.throwerZ, this.pitch, this.height);
            }
        });
        return true;
    }
}

