/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.ai.hel_walker;

import com.deriys.divinerelics.entities.entity.HelWalkerEntity;
import com.deriys.divinerelics.items.DraupnirSpear;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;

public class HelWalkerAttackGoal
extends MeleeAttackGoal {
    private final HelWalkerEntity helWalker;
    private int attackDelay = 15;
    private int ticksUntilNextAttack = 30;
    private boolean shouldCountTillNextAttack = false;

    public HelWalkerAttackGoal(PathfinderMob pathfinderMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pathfinderMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.helWalker = (HelWalkerEntity)pathfinderMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 15;
        this.ticksUntilNextAttack = 30;
    }

    public boolean m_8045_() {
        return super.m_8045_();
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.helWalker.f_19853_.m_5594_(null, this.helWalker.m_20097_(), this.helWalker.getAttackSound(), SoundSource.HOSTILE, 1.0f, DraupnirSpear.RAND.nextFloat() * 0.1f + 0.95f);
                this.helWalker.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.helWalker.setAttacking(false);
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        float attackRange = 2.8f;
        return pDistToEnemySqr <= this.m_6639_(pEnemy) + (double)(attackRange * attackRange);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack == this.attackDelay;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack == this.attackDelay * 2;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        if (this.f_25540_.m_7327_((Entity)pEnemy) && pEnemy.m_6084_() && pEnemy instanceof Player) {
            Player player = (Player)pEnemy;
            if (!player.m_150110_().f_35937_) {
                pEnemy.m_146917_(pEnemy.m_146888_() + HelWalkerEntity.FREEZING_TIME);
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack && this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
            if (this.ticksUntilNextAttack == 0) {
                this.helWalker.setAttacking(false);
                this.m_25563_();
            }
        }
    }

    public void m_8041_() {
        this.helWalker.setAttacking(false);
        super.m_8041_();
    }
}

