/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.ai.thor;

import com.deriys.divinerelics.entities.entity.ThorEntity;
import com.deriys.divinerelics.items.DraupnirSpear;

public enum ThorAttackState {
    NONE,
    MELEE_ATTACK,
    LEG_ATTACK,
    CLAP_ATTACK,
    GROUND_ATTACK,
    MJOLNIR_THROW;


    public static ThorAttackState getState(byte i) {
        return ThorAttackState.values()[i];
    }

    public static int getAttackStateTicks(ThorAttackState state) {
        return switch (state) {
            case CLAP_ATTACK -> 24;
            case GROUND_ATTACK -> 25;
            case MJOLNIR_THROW, LEG_ATTACK -> 15;
            default -> 12;
        };
    }

    public static ThorAttackState genCloseState(ThorEntity thor, ThorAttackState lastAttack) {
        float rand = DraupnirSpear.RAND.nextFloat();
        if ((double)rand < 0.2 && !lastAttack.equals((Object)CLAP_ATTACK)) {
            return CLAP_ATTACK;
        }
        if (!thor.waitsForMjolnir()) {
            if ((double)DraupnirSpear.RAND.nextFloat() > 0.3) {
                return MELEE_ATTACK;
            }
            return LEG_ATTACK;
        }
        return LEG_ATTACK;
    }
}

