/*
 * Decompiled with CFR 0.152.
 */
package com.deriys.divinerelics.entities.entity;

import com.deriys.divinerelics.config.DivineRelicsCommonConfig;
import com.deriys.divinerelics.entities.ai.draugr.DraugrAttackGoal;
import com.deriys.divinerelics.init.DRItems;
import com.deriys.divinerelics.init.DRSounds;
import com.deriys.divinerelics.items.DraupnirSpear;
import com.deriys.divinerelics.items.HeimdallGauntlet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DraugrEntity
extends Monster
implements IAnimatable {
    private static final AttributeModifier SLOW_SPEED_MODIFIER = new AttributeModifier("SlowSpeed", -0.3, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier FAST_SPEED_MODIFIER = new AttributeModifier("FastSpeed", ((Double)DivineRelicsCommonConfig.DRAUGR_SPEED_MODIFIER.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE);
    public static final int BURNING_TIME = (Integer)DivineRelicsCommonConfig.DRAUGR_BURNING_TIME.get();
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(DraugrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackingTicks = 0;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private SoundEvent[] ambientSounds = new SoundEvent[]{(SoundEvent)DRSounds.DRAUGR_AMBIENT_1.get(), (SoundEvent)DRSounds.DRAUGR_AMBIENT_2.get(), (SoundEvent)DRSounds.DRAUGR_AMBIENT_3.get()};

    public DraugrEntity(EntityType<? extends DraugrEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.attackingTicks > 0) {
            --this.attackingTicks;
        }
        DraugrEntity.setChasing((LivingEntity)this, FAST_SPEED_MODIFIER, SLOW_SPEED_MODIFIER, (target = this.m_5448_()) != null && target.m_6084_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(1, (Goal)new DraugrAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{DraugrEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, ((Double)DivineRelicsCommonConfig.DRAUGR_FOLLOW_RANGE.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)DivineRelicsCommonConfig.DRAUGR_HP.get()).doubleValue()).m_22268_(Attributes.f_22278_, ((Double)DivineRelicsCommonConfig.DRAUGR_KB_RESISTANCE.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22281_, ((Double)DivineRelicsCommonConfig.DRAUGR_DAMAGE.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)DivineRelicsCommonConfig.DRAUGR_ARMOR.get()).doubleValue()).m_22266_(Attributes.f_22287_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isAttacking() && this.attackingTicks == 0) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.draugr.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            this.attackingTicks = 30;
            return PlayState.CONTINUE;
        }
        if (this.attackingTicks == 0) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.draugr.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.draugr.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public static void setChasing(LivingEntity livingEntity, AttributeModifier fast_speed_modifier, AttributeModifier slow_speed_modifier, boolean chasing) {
        AttributeInstance speedAttribute = livingEntity.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            if (chasing) {
                if (!speedAttribute.m_22109_(fast_speed_modifier)) {
                    speedAttribute.m_22118_(fast_speed_modifier);
                }
                if (speedAttribute.m_22109_(slow_speed_modifier)) {
                    speedAttribute.m_22130_(slow_speed_modifier);
                }
            } else {
                if (!speedAttribute.m_22109_(slow_speed_modifier)) {
                    speedAttribute.m_22118_(slow_speed_modifier);
                }
                if (speedAttribute.m_22109_(fast_speed_modifier)) {
                    speedAttribute.m_22130_(fast_speed_modifier);
                }
            }
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12381_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.ambientSounds[HeimdallGauntlet.RAND.nextInt(0, 3)];
    }

    public float m_6100_() {
        return DraupnirSpear.getRandomPitch();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    public void m_6667_(DamageSource p_21014_) {
        if (HeimdallGauntlet.RAND.nextFloat() > 0.5f) {
            this.m_19983_(new ItemStack((ItemLike)DRItems.HACKSILVER.get(), HeimdallGauntlet.RAND.nextInt(0, 2)));
        }
        if (HeimdallGauntlet.RAND.nextFloat() < 0.01f) {
            this.m_19983_(new ItemStack((ItemLike)DRItems.SCAPE_THEME_MUSIC_DISK.get()));
        }
        super.m_6667_(p_21014_);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean canSpawn(EntityType<DraugrEntity> draugrEntityEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return DraugrEntity.m_217057_(draugrEntityEntityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && serverLevelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }
}

